/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.cloud.rpc.io.message;

import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import net.jplugin.cloud.rpc.io.spi.AbstractMessageBodySerializer;
import net.jplugin.common.kits.AssertKit;
import net.jplugin.common.kits.JsonKit;
import net.jplugin.common.kits.StringKit;
import net.jplugin.netty.io.netty.buffer.ByteBuf;
import net.jplugin.netty.io.netty.buffer.ByteBufInputStream;
import net.jplugin.netty.io.netty.buffer.ByteBufOutputStream;

public final class RpcMessage<T> {
    public static final short TYPE_CLIENT_INFO = 1;
    public static final short TYPE_SERVER_INFO = 2;
    public static final short TYPE_CLIENT_REQ = 3;
    public static final short TYPE_SERVER_RES = 4;
    public static final short TYPE_CLIENT_HEART_BEAT = 14;
    public static final short TYPE_SERVER_HEART_BEAT = 15;
    public static final short TYPE_MSG_DOCODE_ERROR = 16;
    public static final String HEADER_CLIENT_APPCODE = "client-app-code";
    public static final String HEADER_CLIENT_SERVICECODE = "client-service-code";
    public static final String HEADER_SERIAL_TYPE = "serial-type";
    public static final String HEADER_REQ_ID = "req-id";
    public static final String HEADER_TENANT_ID = "tenant-id";
    public static final String HEADER_GLOBAL_REQ_ID = "g-req-id";
    public static final String HEADER_ERROR_INFO = "error-info";
    public static final String HEADER_DECODE_ERROR_MSG_FROM = "docode-error-msg-from";
    private short msgType;
    private Hashtable<String, String> header;
    private T body;
    private static final byte[] LENGTH_PLACEHOLDER = new byte[4];
    private static final byte[] HEADER_LEN_PLACEHOLDER = new byte[2];

    public short getMsgType() {
        return this.msgType;
    }

    public Map<String, String> getHeader() {
        return this.header;
    }

    public T getBody() {
        return this.body;
    }

    protected RpcMessage<T> type(short msgType) {
        this.msgType = msgType;
        return this;
    }

    public RpcMessage<T> header(String key, String val) {
        if (this.header == null) {
            this.header = new Hashtable();
        }
        this.header.put(key, val);
        return this;
    }

    public RpcMessage<T> headers(Map<String, String> map) {
        if (map == null) {
            return this;
        }
        if (this.header == null) {
            this.header = new Hashtable();
        }
        this.header.putAll(map);
        return this;
    }

    public RpcMessage<T> body(T body) {
        this.body = body;
        return this;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("type=").append(this.msgType).append(" ");
        if (this.header != null) {
            sb.append("\nheaders:");
            for (Map.Entry<String, String> en : this.header.entrySet()) {
                sb.append((Object)en.getKey()).append("=").append((Object)en.getValue()).append("   ");
            }
        } else {
            sb.append("\nheaders: null");
        }
        sb.append("\nbody=").append(this.body == null ? "null" : JsonKit.object2JsonEx(this.body));
        return sb.toString();
    }

    private RpcMessage() {
    }

    public static RpcMessage create(Short type, Map<String, String> header, Object body) {
        RpcMessage o = new RpcMessage();
        return o.type(type).headers(header).body(body);
    }

    public static RpcMessage create(Short type) {
        return new RpcMessage().type(type);
    }

    public static RpcMessage deSerialize(ByteBuf byteBuf) {
        try {
            ByteBufInputStream input = new ByteBufInputStream(byteBuf);
            RpcMessage<Object> msg = new RpcMessage<Object>();
            msg.type(input.readShort());
            short headLen = input.readShort();
            int headStart = byteBuf.readerIndex();
            if (headLen > 0) {
                msg.headers(new HashMap<String, String>());
                while (byteBuf.readerIndex() - headStart < headLen) {
                    msg.getHeader().put(input.readUTF(), input.readUTF());
                }
            }
            if (input.available() > 0) {
                msg.body(RpcMessage.deSerialBody(input, msg.getHeader()));
            }
            AssertKit.assertEqual((Object)input.available(), (Object)0);
            return msg;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void serializeWithLength(ByteBuf byteBuf, RpcMessage msg) {
        int startIdx = byteBuf.writerIndex();
        ByteBufOutputStream byteOutputStream = new ByteBufOutputStream(byteBuf);
        try {
            byteOutputStream.write(LENGTH_PLACEHOLDER);
            byteOutputStream.writeShort(msg.msgType);
            int headerStartIndex = byteBuf.writerIndex();
            byteOutputStream.write(HEADER_LEN_PLACEHOLDER);
            Map<String, String> header = msg.getHeader();
            if (msg.getHeader() != null) {
                for (Map.Entry<String, String> en : header.entrySet()) {
                    byteOutputStream.writeUTF(en.getKey());
                    byteOutputStream.writeUTF(en.getValue());
                }
            }
            int headerEndIdx = byteBuf.writerIndex();
            Object body = msg.getBody();
            if (msg.getBody() != null) {
                RpcMessage.serialBody(byteOutputStream, body, msg.getHeader());
            }
            int endIdx = byteBuf.writerIndex();
            byteBuf.setInt(startIdx, endIdx - startIdx - 4);
            byteBuf.setShort(headerStartIndex, headerEndIdx - headerStartIndex - 2);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Object deSerialBody(ByteBufInputStream input, Map<String, String> header) throws ClassNotFoundException, IOException {
        String bodyClazz = input.readUTF();
        AbstractMessageBodySerializer serializer = RpcMessage.getMessageBodySerializer(bodyClazz, header);
        return serializer.deSerialBody(input);
    }

    private static void serialBody(ByteBufOutputStream byteOutputStream, Object body, Map<String, String> header) throws IOException {
        AssertKit.assertNotNull((Object)body, (String)"body");
        byteOutputStream.writeUTF(body.getClass().getName());
        AbstractMessageBodySerializer serializer = RpcMessage.getMessageBodySerializer(body.getClass().getName(), header);
        serializer.serialBody(byteOutputStream, body);
    }

    private static AbstractMessageBodySerializer getMessageBodySerializer(String bodyClazz, Map<String, String> header) {
        String temp = header.get(HEADER_SERIAL_TYPE);
        if (StringKit.isNull((String)temp)) {
            throw new RuntimeException("Message Serializer must set");
        }
        return AbstractMessageBodySerializer.getSerializer(AbstractMessageBodySerializer.SerializerType.valueOf(temp), bodyClazz);
    }
}

