/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.cloud.rpc.io.handler;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.InetSocketAddress;
import java.util.concurrent.ThreadPoolExecutor;
import net.jplugin.cloud.rpc.common.util.ExceptionUtils;
import net.jplugin.cloud.rpc.io.handler.Util;
import net.jplugin.cloud.rpc.io.message.RpcMessage;
import net.jplugin.cloud.rpc.io.message.RpcRequest;
import net.jplugin.cloud.rpc.io.message.RpcResponse;
import net.jplugin.cloud.rpc.io.util.ChannelAttributeUtil;
import net.jplugin.cloud.rpc.io.util.MessageUtil;
import net.jplugin.cloud.rpc.io.util.ThreadPoolManager;
import net.jplugin.common.kits.JsonKit;
import net.jplugin.common.kits.ReflactKit;
import net.jplugin.common.kits.StringKit;
import net.jplugin.common.kits.tuple.Tuple2;
import net.jplugin.core.log.api.LogFactory;
import net.jplugin.core.log.api.Logger;
import net.jplugin.core.rclient.api.RemoteExecuteException;
import net.jplugin.core.service.impl.esf.ESFHelper2;
import net.jplugin.core.service.impl.esf.ESFRPCContext;
import net.jplugin.netty.io.netty.channel.Channel;
import net.jplugin.netty.io.netty.channel.ChannelFuture;
import net.jplugin.netty.io.netty.channel.ChannelFutureListener;
import net.jplugin.netty.io.netty.channel.ChannelHandlerContext;
import net.jplugin.netty.io.netty.channel.ChannelInboundHandlerAdapter;

public class RpcServerMessageHandler
extends ChannelInboundHandlerAdapter {
    private ThreadPoolExecutor serverWorkers = ThreadPoolManager.INSTANCE.getServerWorkers();
    private ThreadPoolExecutor heartWorkers = ThreadPoolManager.INSTANCE.getSendHeartWorkers();
    private static final Logger logger = LogFactory.getLogger(RpcServerMessageHandler.class);

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        RpcMessage message = (RpcMessage)msg;
        switch (message.getMsgType()) {
            case 1: {
                this.processClientInfo(ctx, msg);
                break;
            }
            case 14: {
                this.processClientHeartBeat(message, ctx);
                break;
            }
            case 3: {
                this.processClientReq(message, ctx);
                break;
            }
            case 16: {
                this.processDeserializeError(message, ctx);
                break;
            }
            default: {
                throw new RuntimeException("Unsupport Message Type." + message.getMsgType());
            }
        }
    }

    private void processDeserializeError(RpcMessage reqMessage, ChannelHandlerContext ctx) {
        logger.error((Object)("$$$$ Server decode error:" + reqMessage.toString()));
        long acceptTime = System.currentTimeMillis();
        RpcMessage<RpcResponse> respMessage = RpcMessage.create((short)16).header("docode-error-msg-from", "server-response").header("error-info", reqMessage.getHeader().get("error-info"));
        this.writeResponseMessage(ctx, reqMessage, acceptTime, respMessage);
    }

    private void processClientInfo(ChannelHandlerContext ctx, Object msg) {
        ChannelAttributeUtil.setClientInfo(ctx, (RpcMessage)msg);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Recept client info:" + this.getClientInfoString((RpcMessage)msg)));
        }
        RpcMessage serverInfoMessage = MessageUtil.getServerInfoMessage();
        ctx.writeAndFlush(serverInfoMessage);
    }

    private String getClientInfoString(RpcMessage msg) {
        return JsonKit.object2JsonEx(msg.getHeader());
    }

    private void processClientReq(RpcMessage message, ChannelHandlerContext ctx) {
        long acceptTime = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u6536\u5230\u670d\u52a1\u8bf7\u6c42 act=" + acceptTime + ",cid=" + message.getHeader().get("req-id")));
        }
        if (ChannelAttributeUtil.getClientInfo(ctx) == null) {
            throw new RuntimeException("client info is null");
        }
        this.serverWorkers.execute(() -> this.handleServerMethod(ctx, message, acceptTime));
    }

    private void handleServerMethod(ChannelHandlerContext ctx, RpcMessage message, long acceptTime) {
        ESFRPCContext esfRpcContext = this.getTheESFRpcContext(ctx, message);
        RpcMessage<RpcResponse> resp = this.getRpcResponseRpcMessage(esfRpcContext, message, acceptTime);
        this.writeResponseMessage(ctx, message, acceptTime, resp);
    }

    private RpcMessage<RpcResponse> getRpcResponseRpcMessage(ESFRPCContext esfCtx, RpcMessage message, long acceptTime) {
        RpcMessage resp = RpcMessage.create((short)4);
        RpcResponse response = new RpcResponse();
        resp.body(response);
        try {
            String serialAlgm;
            String reqid = message.getHeader().get("req-id");
            if (StringKit.isNotNull((String)reqid)) {
                resp.header("req-id", reqid);
            }
            if (StringKit.isNotNull((String)(serialAlgm = message.getHeader().get("serial-type")))) {
                resp.header("serial-type", serialAlgm);
            }
            Tuple2<Type, Object> ret = this.callServerMethod(esfCtx, message, acceptTime);
            response.setResult(ret.second);
            response.setResultType((Type)ret.first);
            response.setErrorCode("0");
        }
        catch (Throwable te) {
            Throwable e = te;
            if (te != null && !(te instanceof RemoteExecuteException) && (te instanceof InvocationTargetException || te.getCause() instanceof InvocationTargetException)) {
                e = ExceptionUtils.unwrapThrowable(te.getCause());
            }
            if (e instanceof RemoteExecuteException) {
                RemoteExecuteException re = (RemoteExecuteException)e;
                response.setErrorCode(re.getCode());
                response.setMessage(re.getMessage());
            } else {
                response.setErrorCode("-1");
                response.setMessage(e.getMessage());
            }
            this.logInvokeError(e, esfCtx, message, acceptTime);
        }
        return resp;
    }

    private void writeResponseMessage(final ChannelHandlerContext ctx, final RpcMessage message, final long acceptTime, RpcMessage<RpcResponse> resp) {
        Channel channel = ctx.channel();
        if (channel == null || !channel.isActive()) {
            if (logger.isInfoEnabled()) {
                this.logChannelInactive(ctx, message, acceptTime);
            }
        } else {
            channel.writeAndFlush(resp).addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        RpcServerMessageHandler.this.logWriteRespError(future.cause(), ctx, message, acceptTime);
                    } else if (logger.isDebugEnabled()) {
                        RpcServerMessageHandler.this.logWriteSuccess(ctx, message, acceptTime);
                    }
                }
            });
        }
    }

    private Tuple2<Type, Object> callServerMethod(ESFRPCContext esfRpcCtx, RpcMessage msg, long acceptTime) throws Throwable {
        RpcRequest req = (RpcRequest)msg.getBody();
        String uri = req.getUri();
        String methodName = req.getMethodName();
        Object obj = ESFHelper2.getObject((String)uri);
        if (obj == null) {
            throw new RuntimeException("uri error, " + uri);
        }
        Class implClass = ReflactKit.getNonJavaSisSuperClass(obj.getClass());
        Method method = Util.getMethod(implClass, methodName);
        Object[] args = req.getArguments();
        esfRpcCtx.setMsgReceiveTime(acceptTime);
        esfRpcCtx.setRequestUrl(Util.convertURL(uri, methodName, args));
        Object result = ESFHelper2.invokeRPC((ESFRPCContext)esfRpcCtx, (String)uri, (Object)obj, (Method)method, (Object[])args);
        return Tuple2.with((Object)method.getGenericReturnType(), (Object)result);
    }

    private ESFRPCContext getTheESFRpcContext(ChannelHandlerContext ctx, RpcMessage msg) {
        ESFRPCContext rcx = new ESFRPCContext();
        InetSocketAddress remoteAddress = (InetSocketAddress)ctx.channel().remoteAddress();
        rcx.setCallerIpAddress(remoteAddress.getAddress().getHostAddress());
        rcx.setClientAppCode(msg.getHeader().get("client-app-code"));
        rcx.setTenantId(msg.getHeader().get("tenant-id"));
        rcx.setGlobalReqId(msg.getHeader().get("g-req-id"));
        return rcx;
    }

    private void processClientHeartBeat(RpcMessage message, ChannelHandlerContext ctx) {
        throw new RuntimeException("not impl");
    }

    private void logWriteSuccess(ChannelHandlerContext ctx, RpcMessage message, long acceptTime) {
        logger.info((Object)"call success. ");
    }

    private void logWriteRespError(Throwable cause, ChannelHandlerContext ctx, RpcMessage message, long acceptTime) {
        logger.error((Object)"write error. ");
    }

    private void logChannelInactive(ChannelHandlerContext ctx, RpcMessage message, long acceptTime) {
        logger.error((Object)"channel error. ");
    }

    private void logInvokeError(Throwable e, ESFRPCContext ctx, RpcMessage message, long acceptTime) {
        logger.error((Object)"invoke error. ", e);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
        super.exceptionCaught(ctx, cause);
    }
}

