/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.cloud.rpc.io.handler;

import net.jplugin.cloud.rpc.io.message.RpcMessage;
import net.jplugin.netty.io.netty.buffer.ByteBuf;
import net.jplugin.netty.io.netty.channel.ChannelHandlerContext;
import net.jplugin.netty.io.netty.handler.codec.LengthFieldBasedFrameDecoder;

public class RpcMessageDecoder
extends LengthFieldBasedFrameDecoder {
    private static final int max_length = 0x500000;

    public RpcMessageDecoder() {
        super(0x500000, 0, 4, 0, 4);
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        RpcMessage msg;
        ByteBuf frame = (ByteBuf)super.decode(ctx, in);
        if (frame == null) {
            return null;
        }
        try {
            msg = RpcMessage.deSerialize(frame);
        }
        catch (Throwable th) {
            msg = RpcMessage.create((short)16).header("error-info", th.getMessage()).header("docode-error-msg-from", "server-decode");
        }
        return msg;
    }

    @Override
    protected ByteBuf extractFrame(ChannelHandlerContext ctx, ByteBuf buffer, int index, int length) {
        return buffer.slice(index, length);
    }
}

