/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.cloud.rpc.io.handler;

import java.lang.reflect.Type;
import java.util.concurrent.ThreadPoolExecutor;
import net.jplugin.cloud.rpc.io.client.ClientChannelHandler;
import net.jplugin.cloud.rpc.io.client.NettyClient;
import net.jplugin.cloud.rpc.io.future.CallFuture;
import net.jplugin.cloud.rpc.io.message.RpcMessage;
import net.jplugin.cloud.rpc.io.message.RpcResponse;
import net.jplugin.cloud.rpc.io.util.ChannelAttributeUtil;
import net.jplugin.cloud.rpc.io.util.ThreadPoolManager;
import net.jplugin.common.kits.JsonKit;
import net.jplugin.common.kits.StringKit;
import net.jplugin.core.log.api.LogFactory;
import net.jplugin.core.log.api.Logger;
import net.jplugin.core.rclient.api.RemoteExecuteException;
import net.jplugin.netty.io.netty.channel.Channel;
import net.jplugin.netty.io.netty.channel.ChannelHandlerContext;
import net.jplugin.netty.io.netty.channel.ChannelInboundHandlerAdapter;

public class RpcClientMessageHandler
extends ChannelInboundHandlerAdapter {
    private ThreadPoolExecutor clientWorks;
    private ThreadPoolExecutor sendHeartWorkers = ThreadPoolManager.INSTANCE.getSendHeartWorkers();
    private static final Logger logger = LogFactory.getLogger(RpcClientMessageHandler.class);

    public RpcClientMessageHandler() {
        this.clientWorks = ThreadPoolManager.INSTANCE.getClientWorks();
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        RpcMessage message = (RpcMessage)msg;
        switch (message.getMsgType()) {
            case 2: {
                this.processServerInfo(message, ctx);
                break;
            }
            case 4: {
                this.clientWorks.execute(() -> this.processServerResponse(ctx, message));
                break;
            }
            case 15: {
                this.processServerHeartBeat(message, ctx);
                break;
            }
            case 16: {
                this.processDeserializeErrorMsg(message, ctx);
                break;
            }
            default: {
                throw new RuntimeException("Unsupport Message Type");
            }
        }
    }

    private void processDeserializeErrorMsg(RpcMessage message, ChannelHandlerContext ctx) {
        logger.error((Object)("$$$$ docode message error. " + message));
    }

    private void processServerHeartBeat(RpcMessage message, ChannelHandlerContext ctx) {
        throw new RuntimeException("not impl");
    }

    private void processServerInfo(RpcMessage message, ChannelHandlerContext ctx) {
        NettyClient nc;
        ChannelAttributeUtil.setServerInfo(ctx, message);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Recept Server info:" + this.getServerInfoString(message)));
        }
        if ((nc = ChannelAttributeUtil.getNettyClient(ctx.channel())) == null) {
            throw new RuntimeException("Can't find nettyClient in attrs.");
        }
        nc.initChannel(ctx.channel());
    }

    private String getServerInfoString(RpcMessage message) {
        return JsonKit.object2JsonEx(message.getHeader());
    }

    private void processServerResponse(ChannelHandlerContext ctx, RpcMessage message) {
        RpcResponse resBody = (RpcResponse)message.getBody();
        String reqId = message.getHeader().get("req-id");
        if (StringKit.isNull((String)reqId)) {
            throw new RuntimeException("reqId is null");
        }
        Channel channel = ctx.channel();
        ClientChannelHandler clientChannelHandler = ChannelAttributeUtil.getOrCreateClientChannelHandler(channel);
        if (clientChannelHandler == null) {
            throw new RuntimeException("client channel handler is null");
        }
        CallFuture future = clientChannelHandler.removeFuture(reqId);
        if (future == null) {
            System.out.println("$$$$$$$$$$$$$$$$ Can't find the future ,perhaps time out");
        }
        Type resType = resBody.getResultType();
        Object result = null;
        if ("0".equals(resBody.getErrorCode())) {
            if (!Void.TYPE.equals(resType)) {
                result = resBody.getResult();
            }
        } else {
            String errCode = resBody.getErrorCode();
            String errMsg = resBody.getMessage();
            RemoteExecuteException ex = new RemoteExecuteException(Integer.parseInt(errCode), errMsg);
            if (future != null) {
                future.setException((Throwable)ex, channel.remoteAddress());
            }
        }
        if (future != null) {
            future.setVal(result);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("cid=" + reqId + ",Channel=[" + channel + "], cost(ms) : " + (System.currentTimeMillis() - future.getStartTime())));
        }
    }
}

