/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.cloud.rpc.io.future;

import java.lang.reflect.Type;
import java.net.SocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jplugin.cloud.rpc.common.config.AbstractConfig;
import net.jplugin.common.kits.ThreadFactoryBuilder;
import net.jplugin.common.kits.client.ICallback;
import net.jplugin.core.rclient.api.RemoteExecuteException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallFuture<T> {
    private static final long serialVersionUID = -8250017494915963821L;
    private static final Logger logger = LoggerFactory.getLogger(CallFuture.class);
    private T val;
    private Semaphore semaphore = new Semaphore(0);
    private AtomicBoolean done = new AtomicBoolean(false);
    private long timeout = AbstractConfig.getDefaultTimeoutInMills();
    private Throwable exception;
    private long startTime = System.currentTimeMillis();
    private ICallback callback;
    private boolean async = false;
    private static final ExecutorService ayncWorkers = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("esf-rpc-async-callback-%d").build());
    private String serverInfo;
    private Type rtnclz;
    private String contextId;

    public void setContextId(String ctx) {
        this.contextId = ctx;
    }

    public String getContextId() {
        return this.contextId;
    }

    public CallFuture(SocketAddress remoteAddress) {
        this.serverInfo = remoteAddress == null ? null : remoteAddress.toString();
        this.setStartTime(System.currentTimeMillis());
    }

    public T getVal() throws Exception {
        boolean done = this.isDone();
        try {
            if (!done) {
                done = this.semaphore.tryAcquire(this.timeout, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.setDone(true);
        if (done) {
            if (this.hasError()) {
                if (this.exception instanceof RuntimeException) {
                    throw (RuntimeException)this.exception;
                }
                throw new RuntimeException(this.exception.getMessage(), this.exception);
            }
            return this.val;
        }
        throw new TimeoutException("rpc\u670d\u52a1\u8bf7\u6c42\u8d85\u65f6,startTime(ms)=" + this.startTime + ",contextId=" + this.getContextId() + ",serverInfo=" + this.serverInfo);
    }

    public void setVal(Object val) {
        this.val = val;
        this.setDone(true);
    }

    public boolean isDone() {
        return this.done.get();
    }

    public void setDone(boolean done) {
        this.done.compareAndSet(false, done);
        this.semaphore.release();
        if (logger.isDebugEnabled()) {
            logger.debug("cid=" + this.getContextId() + ",cost(ms)=" + (System.currentTimeMillis() - this.startTime));
        }
        if (this.async && this.callback != null) {
            try {
                ayncWorkers.execute(() -> this.callback.callback((Object)(this.hasError() ? this.exception : this.val)));
            }
            catch (Exception e) {
                logger.error("\u5f02\u6b65callBack\u56de\u8c03\u6267\u884c\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            }
        }
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable exception, SocketAddress serverAddress) {
        this.exception = exception;
        this.setDone(true);
        if (exception instanceof RemoteExecuteException) {
            RemoteExecuteException re = (RemoteExecuteException)exception;
            if (logger.isWarnEnabled()) {
                logger.warn("[cid=" + this.getContextId() + ",srv=" + serverAddress + "]\u8bf7\u6c42\u5931\u8d25\uff1aerrno=" + re.getCode() + ",errmsg=" + re.getMessage());
            }
        } else {
            logger.error("[cid=" + this.getContextId() + ",srv=" + serverAddress + "]\u8bf7\u6c42\u5f02\u5e38\uff1a" + exception.getMessage(), exception);
        }
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public boolean hasError() {
        return this.exception != null;
    }

    public void setTimeout(long timeoutInmills) {
        if (timeoutInmills < 0L) {
            throw new IllegalArgumentException("timeoutInmills negative!");
        }
        if (timeoutInmills == 0L) {
            this.timeout = Long.MAX_VALUE;
            return;
        }
        this.timeout = timeoutInmills;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public ICallback getCallback() {
        return this.callback;
    }

    public void setCallback(ICallback callback) {
        this.callback = callback;
    }

    public String getServerInfo() {
        return this.serverInfo;
    }

    public void setServerInfo(String serverInfo) {
        this.serverInfo = serverInfo;
    }

    public Type getRtnclz() {
        return this.rtnclz;
    }

    public void setRtnclz(Type rtnclz) {
        this.rtnclz = rtnclz;
    }
}

