/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.cloud.rpc.io.extension;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Type;
import net.jplugin.cloud.rpc.io.message.RpcResponse;
import net.jplugin.cloud.rpc.io.spi.AbstractMessageBodySerializer;
import net.jplugin.cloud.rpc.io.util.TypeUtil;
import net.jplugin.common.kits.AssertKit;
import net.jplugin.common.kits.JsonKit;
import net.jplugin.common.kits.StringKit;
import net.jplugin.core.kernel.api.BindExtension;
import net.jplugin.netty.io.netty.buffer.ByteBufInputStream;
import net.jplugin.netty.io.netty.buffer.ByteBufOutputStream;

@BindExtension
public class JsonBodySerializer4Response
extends AbstractMessageBodySerializer {
    public static final String FLAG = "$BODY";

    @Override
    public AbstractMessageBodySerializer.SerializerType serialType() {
        return AbstractMessageBodySerializer.SerializerType.JSON;
    }

    @Override
    public String bodyClass() {
        return RpcResponse.class.getName();
    }

    @Override
    public Object deSerialBody(ByteBufInputStream input) throws IOException {
        RpcResponse response = new RpcResponse();
        AssertKit.assertEqual((Object)FLAG, (Object)input.readUTF());
        response.setErrorCode(input.readUTF());
        response.setMessage(input.readUTF());
        response.setResultType(this.readResultType(input));
        if (!Void.TYPE.equals(response.getResultType())) {
            String temp = input.readUTF();
            response.setResult(JsonKit.json2Object4TypeEx((String)temp, (Type)response.getResultType()));
        }
        return response;
    }

    private Type readResultType(ByteBufInputStream input) {
        try {
            ObjectInputStream ois = new ObjectInputStream(input);
            return (Type)ois.readObject();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void serialBody(ByteBufOutputStream stream, Object body) throws IOException {
        AssertKit.assertEqual(body.getClass(), RpcResponse.class);
        RpcResponse req = (RpcResponse)body;
        stream.writeUTF(FLAG);
        stream.writeUTF(StringKit.null2Empty((String)req.getErrorCode()));
        stream.writeUTF(StringKit.null2Empty((String)req.getMessage()));
        this.writeReturnType(stream, req.getResultType());
        if (!Void.TYPE.equals(req.getResultType())) {
            stream.writeUTF(JsonKit.object2JsonEx((Object)req.getResult()));
        }
    }

    private void writeReturnType(ByteBufOutputStream stream, Type resultType) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(stream);
        oos.writeObject(TypeUtil.deepClone(resultType));
    }
}

