/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.cloud.rpc.io.extension;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Type;
import net.jplugin.cloud.rpc.io.message.RpcRequest;
import net.jplugin.cloud.rpc.io.spi.AbstractMessageBodySerializer;
import net.jplugin.cloud.rpc.io.util.TypeUtil;
import net.jplugin.common.kits.AssertKit;
import net.jplugin.common.kits.JsonKit;
import net.jplugin.common.kits.StringKit;
import net.jplugin.core.kernel.api.BindExtension;
import net.jplugin.netty.io.netty.buffer.ByteBufInputStream;
import net.jplugin.netty.io.netty.buffer.ByteBufOutputStream;

@BindExtension
public class JsonBodySerializer4Request
extends AbstractMessageBodySerializer {
    public static final String FLAG = "$BODY";

    @Override
    public AbstractMessageBodySerializer.SerializerType serialType() {
        return AbstractMessageBodySerializer.SerializerType.JSON;
    }

    @Override
    public String bodyClass() {
        return RpcRequest.class.getName();
    }

    @Override
    public Object deSerialBody(ByteBufInputStream input) throws IOException {
        RpcRequest request = new RpcRequest();
        AssertKit.assertEqual((Object)FLAG, (Object)input.readUTF());
        request.setUri(input.readUTF());
        request.setMethodName(input.readUTF());
        short cnt = input.readShort();
        request.setGenericTypes(this.readTypes(input));
        Type[] types = request.getGenericTypes();
        Object[] args = new Object[cnt];
        for (int i = 0; i < args.length; ++i) {
            String temp = input.readUTF();
            args[i] = JsonKit.json2Object4TypeEx((String)temp, (Type)types[i]);
        }
        request.setArguments(args);
        return request;
    }

    private Type[] readTypes(ByteBufInputStream input) {
        try {
            ObjectInputStream ois = new ObjectInputStream(input);
            return (Type[])ois.readObject();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void serialBody(ByteBufOutputStream stream, Object body) throws IOException {
        AssertKit.assertEqual(body.getClass(), RpcRequest.class);
        RpcRequest req = (RpcRequest)body;
        stream.writeUTF(FLAG);
        stream.writeUTF(StringKit.null2Empty((String)req.getUri()));
        stream.writeUTF(StringKit.null2Empty((String)req.getMethodName()));
        stream.writeShort(req.getArguments().length);
        this.writeTypes(stream, req.getGenericTypes());
        for (Object o : req.getArguments()) {
            stream.writeUTF(JsonKit.object2JsonEx((Object)o));
        }
    }

    private void writeTypes(ByteBufOutputStream stream, Type[] genericTypes) throws IOException {
        Type[] serialAbleTypes = TypeUtil.getSerialAbleTypes(genericTypes);
        ObjectOutputStream oos = new ObjectOutputStream(stream);
        oos.writeObject(serialAbleTypes);
    }
}

