/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.cloud.rpc.io.client;

import net.jplugin.cloud.rpc.common.config.AbstractConfig;
import net.jplugin.cloud.rpc.io.api.InvocationContext;
import net.jplugin.cloud.rpc.io.client.ClientChannelHandler;
import net.jplugin.cloud.rpc.io.future.CallFuture;
import net.jplugin.cloud.rpc.io.message.RpcMessage;
import net.jplugin.cloud.rpc.io.message.RpcRequest;
import net.jplugin.common.kits.client.ICallback;
import net.jplugin.common.kits.client.InvocationParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RpcInvokerHelper {
    private static final Logger logger = LoggerFactory.getLogger(RpcInvokerHelper.class);

    RpcInvokerHelper() {
    }

    public static long getRpcTimeout(InvocationParam invokeParam) {
        if (invokeParam != null && invokeParam.getServiceTimeOut() > 0) {
            return invokeParam.getServiceTimeOut();
        }
        return AbstractConfig.getDefaultTimeoutInMills();
    }

    public static Object invokeExecute(ClientChannelHandler channel, InvocationContext ctx) {
        CallFuture<?> cf = null;
        try {
            RpcMessage request = RpcMessage.create((short)3);
            request.header("serial-type", ctx.getSerializerType().name());
            RpcRequest body = new RpcRequest();
            body.setUri(ctx.getServiceName());
            body.setMethodName(ctx.getMethodName());
            body.setArguments(ctx.getArgs());
            body.setGenericTypes(ctx.getArgsType());
            request.body(body);
            ICallback callback = null;
            boolean async = false;
            InvocationParam invocationParam = ctx.getParam();
            if (invocationParam != null) {
                callback = invocationParam.getRpcCallback();
                async = invocationParam.getRpcAsync() != null && invocationParam.getRpcAsync() != false;
            }
            cf = channel.asyncSend(request, async, callback);
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528[serviceName=" + ctx.getServiceName() + ",methodName=" + ctx.getMethodName() + "]\u5f02\u5e38\uff1a" + e);
            throw e;
        }
        if (cf != null) {
            try {
                cf.setTimeout(RpcInvokerHelper.getRpcTimeout(ctx.getParam()));
                Object e = cf.getVal();
                return e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                channel.futureManager.removeFuture(cf.getContextId());
            }
        }
        return null;
    }
}

