/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.cloud.rpc.io.client;

import java.net.InetSocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import net.jplugin.cloud.rpc.common.config.AbstractConfig;
import net.jplugin.cloud.rpc.io.client.ClientChannelHandler;
import net.jplugin.cloud.rpc.io.handler.RpcClientMessageHandler;
import net.jplugin.cloud.rpc.io.handler.RpcMessageDecoder;
import net.jplugin.cloud.rpc.io.handler.RpcMessageEncoder;
import net.jplugin.cloud.rpc.io.message.RpcMessage;
import net.jplugin.cloud.rpc.io.util.ChannelAttributeUtil;
import net.jplugin.cloud.rpc.io.util.MessageUtil;
import net.jplugin.common.kits.AssertKit;
import net.jplugin.common.kits.ThreadFactoryBuilder;
import net.jplugin.core.log.api.LogFactory;
import net.jplugin.core.log.api.Logger;
import net.jplugin.netty.io.netty.bootstrap.Bootstrap;
import net.jplugin.netty.io.netty.channel.Channel;
import net.jplugin.netty.io.netty.channel.ChannelFuture;
import net.jplugin.netty.io.netty.channel.ChannelFutureListener;
import net.jplugin.netty.io.netty.channel.ChannelInitializer;
import net.jplugin.netty.io.netty.channel.ChannelOption;
import net.jplugin.netty.io.netty.channel.ChannelPipeline;
import net.jplugin.netty.io.netty.channel.nio.NioEventLoopGroup;
import net.jplugin.netty.io.netty.channel.socket.nio.NioSocketChannel;

public class NettyClient {
    protected static final Logger logger = LogFactory.getLogger(NettyClient.class);
    protected volatile boolean clientClosed = true;
    protected volatile Channel nettyChannel;
    protected Bootstrap bootstrap;
    protected NioEventLoopGroup workerGroup;
    protected int workers;
    private String remoteHostIp;
    private int remoteHostPort;
    private String remoteAddr;
    private static final AtomicInteger idIndexer = new AtomicInteger(1);
    private static final ExecutorService backExecutors = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("esf-reconnect-%d").build());
    private long lastTryConnectTime;
    private long connectRetryLimit = 10000L;

    public NettyClient(String remoteIp, int port, int workers) {
        this.remoteHostIp = remoteIp;
        this.remoteHostPort = port;
        this.remoteAddr = remoteIp + ":" + port;
        this.workers = workers;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public boolean isClientClosed() {
        return this.clientClosed;
    }

    public void closeClient() {
        this.clientClosed = true;
        try {
            if (this.nettyChannel != null && this.nettyChannel.isOpen()) {
                try {
                    this.nettyChannel.close();
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (this.workerGroup != null) {
                this.workerGroup.shutdownGracefully();
                this.workerGroup = null;
            }
            this.bootstrap = null;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public boolean isConnected() {
        return !this.clientClosed && this.nettyChannel != null && this.nettyChannel.isActive();
    }

    public ClientChannelHandler getClientChannelHandler() {
        if (!this.clientClosed && this.nettyChannel != null && this.nettyChannel.isActive()) {
            return ChannelAttributeUtil.getOrCreateClientChannelHandler(this.nettyChannel);
        }
        return null;
    }

    public void bootstrap() {
        if (this.clientClosed) {
            this.clientClosed = false;
        }
        this.workerGroup = new NioEventLoopGroup(this.workers, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("nioEventLoop-" + idIndexer.getAndIncrement() + "-nettyClient-worker-%d").build());
        this.bootstrap = new Bootstrap();
        this.bootstrap.group(this.workerGroup);
        this.bootstrap.channel(NioSocketChannel.class);
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.option(ChannelOption.TCP_NODELAY, true)).option(ChannelOption.SO_KEEPALIVE, true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, AbstractConfig.getConnectionTimeout())).option(ChannelOption.SO_SNDBUF, 0x100000)).option(ChannelOption.SO_RCVBUF, 0x100000);
        this.bootstrap.handler(new ChannelInitializer(){

            protected void initChannel(Channel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast(new RpcMessageDecoder());
                pipeline.addLast(new RpcMessageEncoder());
                pipeline.addLast(new RpcClientMessageHandler());
            }
        });
        this.doConnect();
    }

    public String getRemoteHostIp() {
        return this.remoteHostIp;
    }

    public int getRemoteHostPort() {
        return this.remoteHostPort;
    }

    private String getRemoteHost() {
        return this.remoteHostIp + ":" + this.remoteHostPort;
    }

    public void mainTainConnection() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("maintain connection for:" + this.getRemoteAddr()));
        }
        if (this.isConnected() || this.clientClosed) {
            return;
        }
        long retryTime = System.currentTimeMillis() - this.lastTryConnectTime;
        if (retryTime < this.connectRetryLimit) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("connection retry latter:" + (this.connectRetryLimit - retryTime) + "  " + this.getRemoteAddr()));
            }
            return;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("connection retry now . " + this.getRemoteAddr()));
        }
        this.doConnect();
    }

    private void doConnect() {
        this.lastTryConnectTime = System.currentTimeMillis();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("begin to connect remoteHost=" + this.getRemoteHost()));
        }
        ChannelFuture future = this.bootstrap.connect(new InetSocketAddress(this.remoteHostIp, this.remoteHostPort));
        future.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture after) throws Exception {
                if (after.isSuccess()) {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("connection success. " + NettyClient.this.getRemoteAddr()));
                    }
                    ChannelAttributeUtil.setNettyClient(after.channel(), NettyClient.this);
                    after.channel().writeAndFlush(NettyClient.this.getClientInfoMessage());
                } else if (logger.isInfoEnabled()) {
                    logger.info((Object)("connection failed. " + NettyClient.this.getRemoteAddr()));
                }
            }
        });
    }

    private RpcMessage getClientInfoMessage() {
        RpcMessage msg = MessageUtil.getClientInfoMessage();
        return msg;
    }

    public void initChannel(Channel c) {
        AssertKit.assertTrue((c != null && c.isActive() ? 1 : 0) != 0);
        this.nettyChannel = c;
        this.getClientChannelHandler();
    }
}

