/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.cloud.rpc.io.client;

import java.net.SocketAddress;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import net.jplugin.cloud.rpc.io.api.InvocationContext;
import net.jplugin.cloud.rpc.io.client.FutureManager;
import net.jplugin.cloud.rpc.io.client.RpcInvokerHelper;
import net.jplugin.cloud.rpc.io.future.CallFuture;
import net.jplugin.cloud.rpc.io.message.RpcMessage;
import net.jplugin.cloud.rpc.io.message.RpcRequest;
import net.jplugin.common.kits.AssertKit;
import net.jplugin.common.kits.CalenderKit;
import net.jplugin.common.kits.client.ICallback;
import net.jplugin.core.kernel.api.RefAnnotationSupport;
import net.jplugin.core.log.api.Logger;
import net.jplugin.core.log.api.RefLogger;
import net.jplugin.netty.io.netty.channel.Channel;
import net.jplugin.netty.io.netty.channel.ChannelFuture;
import net.jplugin.netty.io.netty.channel.ChannelFutureListener;

public class ClientChannelHandler
extends RefAnnotationSupport {
    @RefLogger
    private static Logger logger;
    private Channel channel;
    private String channelId;
    private long initTime = System.currentTimeMillis();
    FutureManager futureManager = new FutureManager();
    static String startTime;
    static AtomicLong index;

    public ClientChannelHandler(Channel aChannel) {
        if (aChannel == null || !aChannel.isActive()) {
            throw new IllegalArgumentException("netty channel is invalid");
        }
        this.channelId = aChannel.id().asLongText();
        this.channel = aChannel;
    }

    public Object invoke(InvocationContext ctx) {
        return RpcInvokerHelper.invokeExecute(this, ctx);
    }

    public CallFuture removeFuture(String reqid) {
        return this.futureManager.removeFuture(reqid);
    }

    public String channelId() {
        return this.channelId;
    }

    public SocketAddress localAddress() {
        return this.channel == null ? null : this.channel.localAddress();
    }

    public SocketAddress remoteAddress() {
        return this.channel == null ? null : this.channel.remoteAddress();
    }

    public boolean isConnected() {
        return this.channel != null && this.channel.isActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object syncSend(RpcMessage<RpcRequest> request, long timeout) throws Exception {
        CallFuture<?> cf = null;
        try {
            cf = this.asyncSend(request, false, null);
            cf.setTimeout(timeout);
            Object obj = cf.getVal();
            return obj;
        }
        finally {
            if (cf != null) {
                this.futureManager.removeFuture(cf.getContextId());
            }
        }
    }

    private ChannelFuture writeAndFlush(Object obj) {
        return this.channel.writeAndFlush(obj);
    }

    public long getInitTime() {
        return this.initTime;
    }

    public CallFuture<?> asyncSend(final RpcMessage<RpcRequest> request, boolean async, ICallback callback) {
        Objects.requireNonNull(request, "request null!");
        AssertKit.assertTrue((this.channel != null && this.channel.isActive() ? 1 : 0) != 0);
        AssertKit.assertStringNull((String)request.getHeader().get("req-id"), (String)"reqid");
        request.header("req-id", ClientChannelHandler.getNextReqId());
        final String contentextId = request.getHeader().get("req-id");
        CallFuture callFuture = new CallFuture(this.remoteAddress());
        callFuture.setContextId(contentextId);
        callFuture.setAsync(async);
        callFuture.setCallback(callback);
        this.futureManager.addFuture(contentextId, callFuture);
        this.writeAndFlush(request).addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture cf) throws Exception {
                if (!cf.isSuccess()) {
                    logger.error((Object)("Request=[" + request + "]\u5f02\u5e38\uff1a" + cf.cause().getMessage()), cf.cause());
                    CallFuture<?> cacheFuture = ClientChannelHandler.this.futureManager.removeFuture(contentextId);
                    if (cacheFuture == null) {
                        return;
                    }
                    cacheFuture.setException(cf.cause(), cf.channel().remoteAddress());
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)("\u8bf7\u6c42\u53d1\u9001\u6210\u529f\uff0ccontentextId=" + contentextId + ",currTimestamp=" + System.currentTimeMillis() + ",channel=>" + cf.channel()));
                }
            }
        });
        return callFuture;
    }

    private static String getNextReqId() {
        return startTime + "-" + index.addAndGet(1L);
    }

    public String toString() {
        return "NettyChannel[ChannelId=" + this.channelId + ",LocalAddress=" + this.localAddress() + ",RemoteAddress=" + this.remoteAddress() + ",Connected=" + this.isConnected() + ",InitTime(ms)=" + this.initTime + "]";
    }

    static {
        startTime = CalenderKit.getCurrentTimeString();
        index = new AtomicLong(1L);
    }
}

