/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.cloud.rpc.io.api;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import net.jplugin.cloud.rpc.io.client.NettyClient;
import net.jplugin.cloud.rpc.io.spi.AbstractMessageBodySerializer;
import net.jplugin.common.kits.AssertKit;
import net.jplugin.common.kits.client.ClientInvocationManager;
import net.jplugin.common.kits.client.InvocationParam;
import net.jplugin.core.log.api.LogFactory;
import net.jplugin.core.log.api.Logger;

public class InvocationContext {
    InvocationParam param;
    String serviceName;
    String methodName;
    Type[] argsType;
    Object[] args;
    AbstractMessageBodySerializer.SerializerType serializerType;
    String designateAddress;
    static Logger logger = LogFactory.getLogger(InvocationContext.class);
    long startTime;
    String remoteAddr;

    public AbstractMessageBodySerializer.SerializerType getSerializerType() {
        return this.serializerType;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public InvocationParam getParam() {
        return this.param;
    }

    public InvocationParam getOrInitParam() {
        if (this.param == null) {
            this.param = InvocationParam.create();
        }
        return this.param;
    }

    public String getDesignateAddress() {
        return this.designateAddress;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Type[] getArgsType() {
        return this.argsType;
    }

    public void setDesignateAddress(String designateAddress) {
        this.designateAddress = designateAddress;
    }

    public static InvocationContext create(String serviceName, Method method, Object[] args, AbstractMessageBodySerializer.SerializerType st) {
        InvocationContext o = new InvocationContext();
        o.param = ClientInvocationManager.INSTANCE.getAndClearParam();
        o.serviceName = serviceName;
        o.methodName = method.getName();
        o.argsType = method.getGenericParameterTypes();
        o.args = args;
        o.serializerType = st;
        return o;
    }

    public static InvocationContext create(String serviceName, String methodName, Object[] args, AbstractMessageBodySerializer.SerializerType st) {
        InvocationContext o = new InvocationContext();
        o.param = ClientInvocationManager.INSTANCE.getAndClearParam();
        o.serviceName = serviceName;
        o.methodName = methodName;
        o.argsType = InvocationContext.getTypes(args);
        o.args = args;
        o.serializerType = st;
        return o;
    }

    static Type[] getTypes(Object[] args) {
        Type[] types = new Type[args.length];
        for (int i = 0; i < types.length; ++i) {
            AssertKit.assertNotNull((Object)args[i], (String)"arg");
            types[i] = args[i].getClass();
        }
        return types;
    }

    public void doStart() {
        this.startTime = System.currentTimeMillis();
        if (logger.isInfoEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append("$$ InvokeBegin , ctx=").append(this.getContextString4Begin());
            logger.info((Object)sb.toString());
        }
    }

    public void doSuccess(Object result) {
        if (logger.isInfoEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append("$$ InvokeSuccess , dural=").append(System.currentTimeMillis() - this.startTime).append(" , ctx=").append(this.getContextString()).append(" , resultDataType=").append(this.getResultType(result));
            logger.info((Object)sb.toString());
        }
    }

    private String getResultType(Object result) {
        if (result == null) {
            return "null";
        }
        return result.getClass().getName();
    }

    private String getContextString4Begin() {
        StringBuffer sb = new StringBuffer();
        sb.append("").append(this.serviceName).append("/").append(this.methodName).append("|").append(this.serializerType.name());
        sb.append("|").append(this.getParamString(this.param));
        return sb.toString();
    }

    private String getContextString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.remoteAddr).append("|").append(this.serviceName).append("/").append(this.methodName).append("|").append(this.serializerType.name());
        sb.append("|").append(this.getParamString(this.param));
        return sb.toString();
    }

    private String getParamString(InvocationParam param) {
        StringBuffer sb = new StringBuffer("{");
        if (param == null) {
            return "";
        }
        if (param.getRpcAsync() != null) {
            sb.append("rpcAsync-").append(param.getRpcAsync()).append(",");
        }
        if (param.getServiceAddress() != null) {
            sb.append("designatNode-").append(param.getServiceAddress()).append(",");
        }
        sb.append("timeout-").append(param.getServiceTimeOut()).append(",");
        if (param.getRpcCallback() != null) {
            sb.append(" callback-").append(param.getRpcCallback().getClass().getName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public void doError(Throwable th) {
        if (logger.isInfoEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append("$$ InvokeFailed  , dural=").append(System.currentTimeMillis() - this.startTime).append(" , ctx=").append(this.getContextString()).append(" , exception=").append(this.getResultType(th.getMessage()));
            logger.info((Object)sb.toString());
        }
    }

    public void setCallerClient(NettyClient client) {
        this.remoteAddr = client.getRemoteAddr();
    }
}

