/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.cloud.rpc.common.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jplugin.core.config.api.CloudEnvironment;
import net.jplugin.core.config.api.ConfigFactory;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config4AppCenter {
    private static final Logger logger = LoggerFactory.getLogger(Config4AppCenter.class);
    private static final Map<String, String> group_conf = new HashMap<String, String>();
    private static String appCode;
    private static Integer rpcPort;
    private static boolean debug;
    private static boolean grayNode;

    private Config4AppCenter() {
    }

    private static void init() {
        appCode = CloudEnvironment.INSTANCE._composeAppCode();
        rpcPort = Integer.parseInt(CloudEnvironment.INSTANCE.getRpcPort());
    }

    public static String getEnv(String envName) {
        throw new RuntimeException("not impl yet");
    }

    public static String getAppcode() {
        return appCode;
    }

    public static Integer getStartRpcPort() {
        return rpcPort;
    }

    public static Integer getRpcPort() {
        return rpcPort;
    }

    public static String getAsign() {
        return CloudEnvironment.INSTANCE.getNacosPwd();
    }

    public static String getStringOfGroup(String item) {
        String val = group_conf.get(item);
        if (StringUtils.isEmpty((CharSequence)val)) {
            String localConfig = ConfigFactory.getStringConfig((String)("esf." + item));
            group_conf.put(item, localConfig);
            return localConfig;
        }
        return val;
    }

    public static List<String> getConfigAsList(String item) {
        String val = group_conf.get(item);
        if (StringUtils.isEmpty((CharSequence)val)) {
            String localConfig = ConfigFactory.getStringConfig((String)("esf." + item));
            group_conf.put(item, localConfig);
            val = localConfig;
        }
        if (!StringUtils.isEmpty((CharSequence)val)) {
            return Arrays.asList(val.split(","));
        }
        return new ArrayList<String>(0);
    }

    public static String getString(String item, String defaultVal) {
        String val = Config4AppCenter.getStringOfGroup(item);
        return StringUtils.isEmpty((CharSequence)val) ? defaultVal : val;
    }

    public static Integer getInteger(String item) {
        String val = Config4AppCenter.getStringOfGroup(item);
        if (!StringUtils.isEmpty((CharSequence)val)) {
            return Integer.parseInt(val);
        }
        return null;
    }

    public static Integer getInteger(String item, int defaultValue) {
        Integer val = Config4AppCenter.getInteger(item);
        return val == null ? defaultValue : val;
    }

    public static Long getLong(String item) {
        String val = Config4AppCenter.getStringOfGroup(item);
        if (!StringUtils.isEmpty((CharSequence)val)) {
            return Long.parseLong(val);
        }
        return null;
    }

    public static Long getLong(String item, long defaultValue) {
        Long val = Config4AppCenter.getLong(item);
        return val == null ? defaultValue : val;
    }

    public static Boolean getBoolean(String item) {
        String val = Config4AppCenter.getStringOfGroup(item);
        if (!StringUtils.isEmpty((CharSequence)val)) {
            return Boolean.parseBoolean(val);
        }
        return null;
    }

    public static Boolean getBoolean(String item, boolean defaultValue) {
        Boolean val = Config4AppCenter.getBoolean(item);
        return val == null ? defaultValue : val;
    }

    public static Double getDouble(String item) {
        String val = Config4AppCenter.getStringOfGroup(item);
        if (!StringUtils.isEmpty((CharSequence)val)) {
            return Double.parseDouble(val);
        }
        return null;
    }

    public static Double getDouble(String item, double defaultVal) {
        Double val = Config4AppCenter.getDouble(item);
        return val == null ? defaultVal : val;
    }

    public static Integer getDefaultWorkers() {
        return Runtime.getRuntime().availableProcessors() + 1;
    }

    public static boolean isDebug() {
        return debug;
    }

    public static boolean isGrayNode() {
        return grayNode;
    }

    static {
        try {
            Config4AppCenter.init();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

