/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.cloud.rpc.common.config;

import net.jplugin.cloud.rpc.common.config.Config4AppCenter;
import net.jplugin.cloud.rpc.common.util.ExceptionUtils;
import net.jplugin.common.kits.StringKit;
import net.jplugin.core.config.api.ConfigFactory;
import net.jplugin.core.kernel.api.ctx.ThreadLocalContextManager;
import net.jplugin.core.rclient.api.RemoteExecuteException;

public abstract class AbstractConfig {
    private static final long serialVersionUID = -2218369194338181239L;
    private static final int demo_cpu_beishu = 5;
    private static final int demo_resp_cpu_beishu = 2;
    private static final int demo_max_beishu = 2;
    private static final int demo_netty_http_worker_cpu_beishu = 2;
    private static final int demo_http_worker_cpu_beishu = 4;

    public static Integer getNettyBoss() {
        return Config4AppCenter.getInteger("netty.boss", 1);
    }

    public static Integer getNettyWorkers() {
        return Config4AppCenter.getInteger("netty.worker", Config4AppCenter.getDefaultWorkers());
    }

    public static Integer getNettyHttpBoss() {
        return Config4AppCenter.getInteger("netty.http.boss", 1);
    }

    public static Integer getNettyHttpWorkers() {
        return Config4AppCenter.getInteger("netty.http.worker", Config4AppCenter.getDefaultWorkers() * 2);
    }

    public static Integer getRpcWorkers() {
        return Config4AppCenter.getInteger("rpc.worker", AbstractConfig.getNettyWorkers() * 5);
    }

    public static int getMaxRpcWorkers() {
        return Config4AppCenter.getInteger("rpc.max.worker", AbstractConfig.getRpcWorkers() * 2);
    }

    public static Integer getRpcRespWorkers() {
        return Config4AppCenter.getInteger("rpc.resp.worker", AbstractConfig.getNettyWorkers() * 2);
    }

    public static int getMaxRpcRespWorkers() {
        return Config4AppCenter.getInteger("rpc.resp.max.worker", AbstractConfig.getRpcRespWorkers() * 2);
    }

    public static Integer getHttpWorkers() {
        return Config4AppCenter.getInteger("http.worker", AbstractConfig.getNettyHttpWorkers() * 4);
    }

    public static Integer getMaxHttpWorkers() {
        return Config4AppCenter.getInteger("http.max.worker", AbstractConfig.getHttpWorkers() * 2);
    }

    public static Integer getRpcPort() {
        return Config4AppCenter.getRpcPort();
    }

    public static String getAppcode() {
        return Config4AppCenter.getAppcode();
    }

    public static Integer getCppTryNum() {
        return Config4AppCenter.getInteger("cpp.try", 1);
    }

    public static Integer getHeartInterval() {
        return Config4AppCenter.getInteger("heart.interval", 15);
    }

    public static Integer getSerialHeartNum() {
        return Config4AppCenter.getInteger("heart.continuous.num", 6);
    }

    public static Integer getConnectionTimeout() {
        return Config4AppCenter.getInteger("connection.timeout", 3000);
    }

    public static Integer getSoTimeout() {
        return Config4AppCenter.getInteger("so.timeout", 30000);
    }

    public static String getAuthCenterUrl() {
        return Config4AppCenter.getEnv("kauth.center.url");
    }

    public static String getAuthDomainUrl() {
        return Config4AppCenter.getEnv("kauth.proxy.url");
    }

    public static Long getValidHeartTime() {
        return System.currentTimeMillis() - (long)(AbstractConfig.getHeartInterval() * AbstractConfig.getSerialHeartNum() * 1000);
    }

    public static Boolean isValidHeart(Long heartTime) {
        return System.currentTimeMillis() <= heartTime + (long)(AbstractConfig.getHeartInterval() * AbstractConfig.getSerialHeartNum() * 1000);
    }

    public static long getDefaultTimeoutInMills() {
        return Config4AppCenter.getInteger("wait.timeout", 6000).intValue();
    }

    public static Long getBlackTime() {
        return Config4AppCenter.getLong("black.timeout", 120000L);
    }

    public static boolean enableMultiTenants() {
        return "true".equalsIgnoreCase(ConfigFactory.getStringConfig((String)"mtenant.enable"));
    }

    public static String getCurrentTenantId() {
        String currentTenantId = ThreadLocalContextManager.getRequestInfo().getCurrentTenantId();
        if (StringKit.isEmpty((String)currentTenantId)) {
            throw new NullPointerException("\u8bf7\u6c42\u79df\u6236ID\u7a7a\uff0c\u8bf7\u68c0\u67e5\u79df\u6237ID\u914d\u7f6e");
        }
        return currentTenantId;
    }

    public static boolean getCppMonitorReport() {
        return Config4AppCenter.getBoolean("monitor.cpp", true);
    }

    public static boolean getCppSourceLucency() {
        return Config4AppCenter.getBoolean("lucency.source.cpp", false);
    }

    public static boolean getCppMachinekeyLucency() {
        return Config4AppCenter.getBoolean("lucency.machinekey.cpp", true);
    }

    public static boolean getCppTanancyOverride() {
        return Config4AppCenter.getBoolean("tanancy.override.cpp", false);
    }

    public static Boolean getBabyStoreMode() {
        Integer babyStoreMode = Config4AppCenter.getInteger("baby.store.mode");
        if (babyStoreMode == null) {
            return null;
        }
        if (babyStoreMode == 1) {
            return true;
        }
        if (babyStoreMode == 0) {
            return false;
        }
        return true;
    }

    public static int getStartRpcPort() {
        return Config4AppCenter.getStartRpcPort();
    }

    public static boolean monitorRemoteExcep() {
        return Config4AppCenter.getBoolean("monitor.remoteexcep", false);
    }

    private static boolean monitorClientRemoteExcep() {
        return Config4AppCenter.getBoolean("monitor.client.remoteexcep", true);
    }

    public static boolean debugMode() {
        return Config4AppCenter.isDebug();
    }

    public static boolean filterRemoteExcep(Throwable th) {
        if (th == null) {
            return true;
        }
        return !AbstractConfig.monitorRemoteExcep() && (ExceptionUtils.unwrapThrowable(th) instanceof RemoteExecuteException || ExceptionUtils.unwrapThrowable(th.getCause()) instanceof RemoteExecuteException);
    }

    public static boolean filterClientRemoteExcep(Throwable th) {
        if (th == null) {
            return true;
        }
        return !AbstractConfig.monitorClientRemoteExcep() && (ExceptionUtils.unwrapThrowable(th) instanceof RemoteExecuteException || ExceptionUtils.unwrapThrowable(th.getCause()) instanceof RemoteExecuteException);
    }

    public static boolean isGrayNode() {
        return Config4AppCenter.isGrayNode();
    }
}

