/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.cloud.rpc.client.spi;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.listener.Event;
import com.alibaba.nacos.api.naming.listener.EventListener;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.alibaba.nacos.api.naming.pojo.Instance;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import net.jplugin.cloud.rpc.client.spi.IClientSubscribeService;
import net.jplugin.cloud.rpc.client.spi.IServiceNodeChangeListener;
import net.jplugin.core.config.api.CloudEnvironment;
import net.jplugin.core.kernel.api.BindExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BindExtension
public class NacosSubscribeService
implements IClientSubscribeService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String USERNAME = "nacos";
    private static final String PASSWORD = "nacos";
    private static final String NAMESPACE = "public";
    private final ConcurrentMap<String, List<Instance>> services = new ConcurrentHashMap<String, List<Instance>>();
    private static final List<Instance> EMPTY_LIST = new ArrayList<Instance>(0);
    private IServiceNodeChangeListener listener;

    @Override
    public void initSubscribCodeList(Set<String> appCodes) {
        if (null != appCodes && !appCodes.isEmpty()) {
            try {
                Properties properties = new Properties();
                properties.put("username", "nacos");
                properties.put("password", "nacos");
                properties.put("serverAddr", CloudEnvironment.INSTANCE.getNacosUrl());
                properties.put("namespace", NAMESPACE);
                NamingService namingService = NacosFactory.createNamingService((Properties)properties);
                for (String appcode : appCodes) {
                    if (this.log.isInfoEnabled()) {
                        this.log.info("init subscribe serviceName:{}", (Object)appcode);
                    }
                    namingService.subscribe(appcode, (EventListener)new NacosEventListener());
                }
                for (int i = 0; i < 30; ++i) {
                    if (this.check(appCodes)) {
                        return;
                    }
                    Thread.sleep(100L);
                }
                throw new RuntimeException("");
            }
            catch (Exception e) {
                this.log.error("\u521d\u59cb\u5316nacos\u670d\u52a1\u8ba2\u9605\u5f02\u5e38", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    private boolean check(Set<String> appCodes) {
        for (String appcode : appCodes) {
            if (null != this.services.get(appcode)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<String> getServiceNodesList(String appCode) {
        List instances = (List)this.services.get(appCode);
        if (null != instances) {
            return instances.stream().filter(Instance::isHealthy).map(instance -> instance.getIp() + ":" + instance.getPort()).collect(Collectors.toSet());
        }
        throw new IllegalArgumentException("appcode :" + appCode + "is illegal!");
    }

    @Override
    public void addServiceNodesChangeListener(IServiceNodeChangeListener listener) {
        this.listener = listener;
    }

    class NacosEventListener
    implements EventListener {
        private final Logger log = LoggerFactory.getLogger(NacosEventListener.class);

        NacosEventListener() {
        }

        public void onEvent(Event e) {
            NamingEvent event = (NamingEvent)e;
            if (this.log.isInfoEnabled()) {
                if (null == event.getInstances() || event.getInstances().isEmpty()) {
                    this.log.info("onEvent serviceName:{}, instance is Empty.", (Object)event.getServiceName());
                } else {
                    this.log.info("onEvent serviceName:{}, instance {}.", (Object)event.getServiceName(), (Object)event.getInstances());
                }
            }
            if (null == event.getInstances() || event.getInstances().isEmpty()) {
                NacosSubscribeService.this.services.put(event.getServiceName(), EMPTY_LIST);
                if (null != NacosSubscribeService.this.listener) {
                    NacosSubscribeService.this.listener.changed(event.getServiceName(), this.conversion(EMPTY_LIST));
                }
            } else {
                NacosSubscribeService.this.services.put(event.getServiceName(), event.getInstances());
                if (null != NacosSubscribeService.this.listener) {
                    NacosSubscribeService.this.listener.changed(event.getServiceName(), this.conversion(event.getInstances()));
                }
            }
        }

        private Set<String> conversion(List<Instance> list) {
            return list.stream().filter(Instance::isHealthy).map(instance -> instance.getIp() + ":" + instance.getPort()).collect(Collectors.toSet());
        }
    }
}

