/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.cloud.rpc.client.imp;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import net.jplugin.cloud.rpc.client.api.NodeContext;
import net.jplugin.cloud.rpc.client.kits.Util;
import net.jplugin.cloud.rpc.io.api.InvocationContext;
import net.jplugin.cloud.rpc.io.client.NettyClient;
import net.jplugin.cloud.rpc.io.message.RpcMessage;
import net.jplugin.common.kits.StringKit;
import net.jplugin.common.kits.client.InvocationParam;
import net.jplugin.common.kits.tuple.Tuple2;
import net.jplugin.core.config.api.RefConfig;
import net.jplugin.core.kernel.api.RefAnnotationSupport;
import net.jplugin.core.log.api.Logger;
import net.jplugin.core.log.api.RefLogger;

public class RpcServiceClient
extends RefAnnotationSupport {
    String targetAppCode;
    private static NettyClient[] EMPTY_ARR = new NettyClient[0];
    NettyClient[] nettyClients = EMPTY_ARR;
    AtomicLong lastExecuteTime = new AtomicLong();
    private boolean closed = true;
    @RefLogger
    Logger logger;
    int globalIndex;
    @RefConfig(path="cloud-rpc.client-workers-for-channel", defaultValue="1")
    Integer rpcClientWorks;

    public RpcServiceClient(String code) {
        this.targetAppCode = code;
    }

    public List<NodeContext> _getRpcContextList() {
        return Arrays.stream(this.nettyClients).map(nc -> new NodeContext(this, nc.getRemoteAddr())).collect(Collectors.toList());
    }

    public List<String> getAddressList() {
        return Arrays.stream(this.nettyClients).map(nc -> nc.getRemoteAddr()).collect(Collectors.toList());
    }

    public NodeContext _getRpcContext(String ip) {
        for (int i = 0; i < this.nettyClients.length; ++i) {
            NettyClient nc = this.nettyClients[i];
            if (!ip.equals(nc.getRemoteHostIp())) continue;
            return new NodeContext(this, nc.getRemoteAddr());
        }
        return null;
    }

    public NodeContext _getRpcContext(String ip, int port) {
        for (int i = 0; i < this.nettyClients.length; ++i) {
            NettyClient nc = this.nettyClients[i];
            if (!ip.equals(nc.getRemoteHostIp()) || port != nc.getRemoteHostPort()) continue;
            return new NodeContext(this, nc.getRemoteAddr());
        }
        return null;
    }

    public Object invokeRpc(InvocationContext ctx) {
        try {
            ctx.doStart();
            Object result = this.invokeRpcInner(ctx);
            ctx.doSuccess(result);
            return result;
        }
        catch (Throwable th) {
            ctx.doError(th);
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            throw new RuntimeException(th);
        }
    }

    private Object invokeRpcInner(InvocationContext ctx) {
        InvocationParam invocationParam = ctx.getParam();
        this.checkStateAndOpen(invocationParam == null ? null : invocationParam.getServiceAddress());
        this.lastExecuteTime.set(System.currentTimeMillis());
        NettyClient client = this.getClient(invocationParam);
        ctx.setCallerClient(client);
        return client.getClientChannelHandler().invoke(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStateAndOpen(String serviceAddress) {
        if (this.nettyClients.length == 0) {
            throw new RuntimeException("No healthy node for " + this.targetAppCode);
        }
        if (this.closed) {
            RpcServiceClient rpcServiceClient = this;
            synchronized (rpcServiceClient) {
                if (this.closed) {
                    int i;
                    this.logger.warn((Object)("Now to reopen service client:" + this.targetAppCode));
                    this.start();
                    for (i = 0; i < 10; ++i) {
                        try {
                            Thread.sleep(200L);
                            if (serviceAddress == null) {
                                if (!this.connectedAny()) continue;
                                this.logger.warn((Object)("start ok after " + (i + 1) + " test."));
                                break;
                            }
                            if (!this.connectedSpecifal(serviceAddress)) continue;
                            this.logger.warn((Object)("start specifal ok after " + (i + 1) + " test."));
                            break;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                    if (i == 10) {
                        throw new RuntimeException("Service client not connect in limit time!");
                    }
                }
            }
        }
    }

    private synchronized NettyClient getClient(InvocationParam invocationParam) {
        NettyClient nettyClient;
        String designateAddress = null;
        if (invocationParam != null) {
            designateAddress = invocationParam.getServiceAddress();
        }
        if (StringKit.isNull(designateAddress)) {
            nettyClient = this.computeTargetClient();
            if (nettyClient == null) {
                throw new RuntimeException("can't find a proper target client");
            }
        } else {
            nettyClient = this.findTargetClient(designateAddress);
            if (nettyClient == null) {
                throw new RuntimeException("target client not found or not active:" + designateAddress);
            }
        }
        return nettyClient;
    }

    private NettyClient computeTargetClient() {
        int len = this.nettyClients.length;
        for (int cnt = 0; cnt < len; ++cnt) {
            int pos;
            if (!this.nettyClients[pos = ++this.globalIndex % len].isConnected()) continue;
            return this.nettyClients[pos];
        }
        return null;
    }

    private NettyClient findTargetClient(String designateAddress) {
        for (int i = 0; i < this.nettyClients.length; ++i) {
            if (!designateAddress.equals(this.nettyClients[i].getRemoteAddr())) continue;
            return this.nettyClients[i];
        }
        return null;
    }

    public void send(RpcMessage msg) {
        throw new RuntimeException("not impl");
    }

    public synchronized void start() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("ServiceClient begin starte:" + this.toString()));
        }
        this.closed = false;
        for (int i = 0; i < this.nettyClients.length; ++i) {
            NettyClient nc = this.nettyClients[i];
            if (nc.isClientClosed()) {
                this.logger.info((Object)("Not to bootstrap client ," + nc.getRemoteAddr()));
                nc.bootstrap();
                continue;
            }
            this.logger.warn((Object)("The client shoud be closed,but active!," + nc.getRemoteAddr()));
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("ServiceClient started:" + this.toString()));
        }
    }

    public synchronized void updateHosts(Set<String> newHosts) {
        NettyClient[] temp = new NettyClient[newHosts.size()];
        String[] newHostsArr = newHosts.toArray(new String[newHosts.size()]);
        for (int i = 0; i < newHostsArr.length; ++i) {
            String addr = newHostsArr[i];
            NettyClient findResult = this.findTargetClient(addr);
            if (findResult != null) {
                temp[i] = findResult;
                continue;
            }
            Tuple2<String, Integer> ipPort = Util.splitAddr(addr);
            temp[i] = new NettyClient((String)ipPort.first, (Integer)ipPort.second, this.rpcClientWorks);
            if (!this.closed) {
                temp[i].bootstrap();
                this.logger.info((Object)("AddHost and bootstrap. " + ipPort));
                continue;
            }
            this.logger.info((Object)("AddHost ,not bootstrap." + ipPort));
        }
        NettyClient[] oldClients = this.nettyClients;
        this.nettyClients = temp;
        for (int i = 0; i < oldClients.length; ++i) {
            if (this.contain(temp, oldClients[i])) continue;
            try {
                oldClients[i].closeClient();
                continue;
            }
            catch (Exception e) {
                this.logger.error((Object)("error to close " + oldClients[i].getRemoteAddr() + " " + this.targetAppCode), (Throwable)e);
            }
        }
    }

    private boolean contain(NettyClient[] arr, NettyClient client) {
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] != client) continue;
            return true;
        }
        return false;
    }

    public boolean connectedAny() {
        for (int i = 0; i < this.nettyClients.length; ++i) {
            if (!this.nettyClients[i].isConnected()) continue;
            return true;
        }
        return false;
    }

    public boolean connectedSpecifal(String address) {
        for (int i = 0; i < this.nettyClients.length; ++i) {
            if (!address.equals(this.nettyClients[i].getRemoteAddr()) || !this.nettyClients[i].isConnected()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(" appCode=" + this.targetAppCode).append(" closed=").append(this.closed).append(" [");
        for (int i = 0; i < this.nettyClients.length; ++i) {
            NettyClient c = this.nettyClients[i];
            sb.append(" ").append(c.getRemoteAddr()).append("- connected:").append(c.isConnected());
        }
        sb.append("]");
        return sb.toString();
    }

    public synchronized void maintainConnect(int keepMillSeconds) {
        if (keepMillSeconds > 0 && System.currentTimeMillis() - this.lastExecuteTime.get() >= (long)keepMillSeconds && !this.closed) {
            System.out.println("Connection idle time out, close it. " + this.targetAppCode);
            this.close();
        }
        for (int i = 0; i < this.nettyClients.length; ++i) {
            NettyClient temp = this.nettyClients[i];
            temp.mainTainConnection();
        }
    }

    public synchronized void close() {
        this.closed = true;
        for (int i = 0; i < this.nettyClients.length; ++i) {
            NettyClient temp = this.nettyClients[i];
            temp.closeClient();
        }
    }
}

