/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.cloud.rpc.client.imp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.jplugin.cloud.rpc.client.imp.RpcServiceClient;
import net.jplugin.cloud.rpc.client.kits.RpcUrlKit;
import net.jplugin.cloud.rpc.client.spi.IClientSubscribeService;
import net.jplugin.common.kits.StringKit;
import net.jplugin.common.kits.ThreadFactoryBuilder;
import net.jplugin.common.kits.tuple.Tuple2;
import net.jplugin.core.config.api.ConfigFactory;
import net.jplugin.core.config.api.RefConfig;
import net.jplugin.core.kernel.api.PluginEnvirement;
import net.jplugin.core.kernel.api.RefExtension;
import net.jplugin.core.log.api.Logger;
import net.jplugin.core.log.api.RefLogger;
import net.jplugin.core.rclient.proxyfac.ClientProxyDefinition;
import net.jplugin.core.service.api.BindService;

@BindService
public class RpcClientManager {
    @RefLogger
    static Logger logger;
    Map<String, RpcServiceClient> serviceClientMap = new ConcurrentHashMap<String, RpcServiceClient>();
    @RefExtension
    IClientSubscribeService clientSubscribeService;
    private ScheduledExecutorService connectMaintainer = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ESFClientConnectMaintainer-%d").build());
    private ConnectionMaintainer maintainer = new ConnectionMaintainer();
    @RefConfig(path="cloud-rpc.client-keep-seconds-for-idle", defaultValue="1800")
    private Integer keepSecondsForIdle;
    @RefConfig(path="cloud-rpc.extend-subscribe")
    private String extendSubscribe;

    public void start() {
        System.out.println(PluginEnvirement.getInstance().getConfigDir());
        System.out.println(ConfigFactory.getStringConfig((String)"cloud-rpc.client-keep-seconds-for-idle"));
        PluginEnvirement.INSTANCE.getStartLogger().log((Object)"$$$ RPC ClientManager starting!");
        Set<String> appcodeList = this.getSubscribeAppCodeList();
        appcodeList.addAll(this.getExtendSubscribs());
        if (!appcodeList.isEmpty()) {
            this.clientSubscribeService.initSubscribCodeList(Collections.unmodifiableSet(appcodeList));
            appcodeList.forEach(o -> {
                RpcServiceClient serviceClient = new RpcServiceClient((String)o);
                Set<String> hostAddrs = this.clientSubscribeService.getServiceNodesList((String)o);
                this.logServiceClient((String)o, hostAddrs);
                serviceClient.updateHosts(hostAddrs);
                this.serviceClientMap.put((String)o, serviceClient);
            });
            this.clientSubscribeService.addServiceNodesChangeListener((appcode, nodeSet) -> {
                this.logServiceClient(appcode, nodeSet);
                RpcServiceClient client = this.serviceClientMap.get(appcode);
                if (client == null) {
                    RuntimeException ex = new RuntimeException("can't find client:" + (Object)((Object)client));
                    logger.error((Object)ex);
                }
                client.updateHosts(nodeSet);
            });
            if (this.keepSecondsForIdle == 0) {
                this.serviceClientMap.values().forEach(o -> o.start());
                this.waitTillConnectedOrTimeout();
            }
            this.connectMaintainer.scheduleWithFixedDelay(this.maintainer, 5000L, 5000L, TimeUnit.MILLISECONDS);
            PluginEnvirement.INSTANCE.getStartLogger().log((Object)("$$$ RPC ClientManager started!" + appcodeList.size() + " apps subscrib."));
        } else {
            PluginEnvirement.INSTANCE.getStartLogger().log((Object)"$$$ RPC Client not start ,because no Subscribs !");
        }
    }

    private List getExtendSubscribs() {
        ArrayList<String> ret = new ArrayList<String>();
        if (!StringKit.isNull((String)this.extendSubscribe)) {
            String[] list;
            for (String s : list = StringKit.splitStr((String)this.extendSubscribe.trim(), (String)",")) {
                ret.add(s);
            }
        }
        return ret;
    }

    private void logServiceClient(String o, Set<String> hostAddrs) {
        if (logger.isInfoEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append("$$ RPC Client [").append(o).append("], serverNodes=[");
            for (String ha : hostAddrs) {
                sb.append(ha).append(",");
            }
            sb.append("] ");
            logger.info((Object)sb.toString());
        }
    }

    private Set<String> getSubscribeAppCodeList() {
        HashSet<String> appCodeList = new HashSet<String>();
        Map javaExtension = PluginEnvirement.getInstance().getExtensionMap("EP_CLIENT_PROXY", ClientProxyDefinition.class);
        if (javaExtension != null && !javaExtension.isEmpty()) {
            javaExtension.values().forEach(o -> {
                String url = o.getUrl();
                Tuple2<String, String> urlInfo = RpcUrlKit.parseEsfUrlInfo(url);
                appCodeList.add(RpcClientManager.handleDefaultServiceCode((String)urlInfo.first));
            });
        }
        return appCodeList;
    }

    private static String handleDefaultServiceCode(String appCodeServiceCode) {
        if (StringKit.isNull((String)appCodeServiceCode)) {
            throw new RuntimeException("appcode and servicecode not found");
        }
        int pos = appCodeServiceCode.indexOf(":");
        if (pos < 0) {
            return appCodeServiceCode + ":DEFAULT";
        }
        return appCodeServiceCode;
    }

    public static void main(String[] args) {
        System.out.println(RpcClientManager.handleDefaultServiceCode("abc:aaa"));
        System.out.println(RpcClientManager.handleDefaultServiceCode("abc"));
    }

    private void waitTillConnectedOrTimeout() {
        System.out.println("ESF client starting ");
        for (int i = 0; i < 30; ++i) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            int successNum = 0;
            int failedNum = 0;
            Set<String> codes = this.serviceClientMap.keySet();
            for (String code : codes) {
                RpcServiceClient client = this.serviceClientMap.get(code);
                if (client.connectedAny()) {
                    ++successNum;
                    continue;
                }
                ++failedNum;
            }
            if (failedNum != 0) continue;
            PluginEnvirement.INSTANCE.getStartLogger().log((Object)("\nESF Client start success. subscrib status:" + this.getClientStatus()));
            return;
        }
        PluginEnvirement.INSTANCE.getStartLogger().log((Object)("\nESF Client start failed. subscrib status:" + this.getClientStatus()));
    }

    private String getClientStatus() {
        StringBuffer sb = new StringBuffer();
        this.serviceClientMap.forEach((code, client) -> sb.append("\n\t").append(client.toString()));
        sb.append("\n");
        return sb.toString();
    }

    public RpcServiceClient getServiceClient(String appcode) {
        return this.serviceClientMap.get(appcode);
    }

    class ConnectionMaintainer
    implements Runnable {
        ConnectionMaintainer() {
        }

        @Override
        public void run() {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"now to maintain connection.");
                }
                RpcClientManager.this.serviceClientMap.forEach((code, client) -> client.maintainConnect(RpcClientManager.this.keepSecondsForIdle * 1000));
            }
            catch (Exception e) {
                logger.error((Object)e);
                e.printStackTrace();
            }
        }
    }
}

