/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.cloud.rpc.client;

import net.jplugin.cloud.rpc.client.annotation.BindRemoteService;
import net.jplugin.cloud.rpc.client.annotation.Protocol;
import net.jplugin.cloud.rpc.client.api.ExtensionESFHelper;
import net.jplugin.cloud.rpc.client.extension.EsfRemoteServiceAnnoHandler;
import net.jplugin.cloud.rpc.client.extension.RpcClientHandler;
import net.jplugin.cloud.rpc.client.extension.RpcJsonClientHandler;
import net.jplugin.cloud.rpc.client.imp.RpcClientManager;
import net.jplugin.core.kernel.api.AbstractPlugin;
import net.jplugin.core.kernel.api.AutoBindExtensionManager;
import net.jplugin.core.kernel.api.ExtensionKernelHelper;
import net.jplugin.core.kernel.api.PluginAnnotation;
import net.jplugin.core.kernel.api.PluginEnvirement;
import net.jplugin.core.rclient.ExtendsionClientHelper;
import net.jplugin.core.service.api.RefService;

@PluginAnnotation
public class Plugin
extends AbstractPlugin {
    public static final String EP_RPC_CLIENT_FILTER = "EP_RPC_CLIENT_FILTER";
    @RefService
    RpcClientManager clientManager;

    public Plugin() {
        ExtendsionClientHelper.addClientHandlerExtension((AbstractPlugin)this, (String)"niorest", RpcClientHandler.class);
        ExtendsionClientHelper.addClientHandlerExtension((AbstractPlugin)this, (String)"rpcjson", RpcJsonClientHandler.class);
        ExtensionKernelHelper.addAnnoAttrHandlerExtension((AbstractPlugin)this, EsfRemoteServiceAnnoHandler.class);
    }

    public int getPrivority() {
        return -97;
    }

    public void init() {
        this.clientManager.start();
    }

    static {
        try {
            AutoBindExtensionManager.INSTANCE.addBindExtensionTransformer(BindRemoteService.class, (p, clazz, anno) -> {
                BindRemoteService theAnno = (BindRemoteService)anno;
                if (theAnno.protocol() == Protocol.rpc) {
                    ExtensionESFHelper.addRPCProxyExtension(p, clazz, theAnno.url());
                    PluginEnvirement.INSTANCE.getStartLogger().log((Object)("$$$ Auto add extension for remote service proxy : protocol=" + (Object)((Object)theAnno.protocol()) + ",url=" + theAnno.url() + ",class=" + clazz.getName()));
                } else if (theAnno.protocol() == Protocol.rpc_json) {
                    ExtensionESFHelper.addRpcJsonProxyExtension(p, clazz, theAnno.url());
                    PluginEnvirement.INSTANCE.getStartLogger().log((Object)("$$$ Auto add extension for remote service proxy : protocol=" + (Object)((Object)theAnno.protocol()) + ",url=" + theAnno.url() + ",class=" + clazz.getName()));
                } else {
                    throw new RuntimeException("not support :" + (Object)((Object)theAnno.protocol()));
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

