/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.cloud.config;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.shaded.com.google.common.collect.Maps;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.jplugin.cloud.config.ConfigProcessor;
import net.jplugin.common.kits.tuple.Tuple2;
import net.jplugin.core.config.api.CloudEnvironment;
import net.jplugin.core.config.api.IConfigProvidor;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NacosGlobalConfigProvidor
implements IConfigProvidor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String GLOBAL_CONFIG = "GLOBAL-CONFIG";
    private ConfigProcessor processor = ConfigProcessor.me();
    private final ConfigService configService;
    private final ConcurrentMap<String, Properties> propertiesCache = new ConcurrentHashMap<String, Properties>();

    public static NacosGlobalConfigProvidor me() {
        return NacosGlobalConfigProvidorHolder.ME;
    }

    private NacosGlobalConfigProvidor() {
        try {
            Properties properties = new Properties();
            properties.put("username", CloudEnvironment.INSTANCE.getNacosUser());
            properties.put("password", CloudEnvironment.INSTANCE.getNacosPwd());
            properties.put("serverAddr", CloudEnvironment.INSTANCE.getNacosUrl());
            properties.put("namespace", CloudEnvironment.INSTANCE.getAppCode());
            this.configService = NacosFactory.createConfigService((Properties)properties);
            this.initConfig();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void initConfig() {
        try {
            Tuple2<Map<String, Properties>, Map<String, String>> publicConfigData = this.processor.initConifgData("", GLOBAL_CONFIG);
            this.propertiesCache.putAll((Map)publicConfigData.first);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getConfigValue(String key) {
        String group = StringUtils.substringBefore((String)key, (String)".");
        Properties properties = (Properties)this.propertiesCache.get(group);
        if (null != properties) {
            String subKey = StringUtils.substringAfter((String)key, (String)".");
            return (String)properties.get(subKey);
        }
        return null;
    }

    public boolean containsConfig(String key) {
        String group = StringUtils.substringBefore((String)key, (String)".");
        Properties properties = (Properties)this.propertiesCache.get(group);
        if (null != properties) {
            String subKey = StringUtils.substringAfter((String)key, (String)".");
            return properties.containsKey(subKey);
        }
        return false;
    }

    public Map<String, String> getStringConfigInGroup(String key) {
        String group = StringUtils.substringBefore((String)key, (String)".");
        Properties properties = (Properties)this.propertiesCache.get(group);
        if (null != properties) {
            return Maps.fromProperties((Properties)properties);
        }
        return null;
    }

    public Set<String> getGroups() {
        return new HashSet<String>(this.propertiesCache.keySet());
    }

    private static final class NacosGlobalConfigProvidorHolder {
        private static final NacosGlobalConfigProvidor ME = new NacosGlobalConfigProvidor();

        private NacosGlobalConfigProvidorHolder() {
        }
    }
}

