/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.cloud.config;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.shaded.com.google.common.collect.Maps;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.jplugin.cloud.config.ConfigChangeListener;
import net.jplugin.cloud.config.ConfigProcessor;
import net.jplugin.common.kits.tuple.Tuple2;
import net.jplugin.core.config.api.CloudEnvironment;
import net.jplugin.core.config.api.IConfigProvidor;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NacosConfigProvidor
implements IConfigProvidor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String APP_CONFIG = "APP-CONFIG";
    private final ConfigProcessor processor = ConfigProcessor.me();
    private final ConfigService configService;
    private final ConcurrentMap<String, Properties> appPropertiesCache;
    private final ConcurrentMap<String, String> appCache;
    private final ConcurrentMap<String, Properties> propertiesCache = new ConcurrentHashMap<String, Properties>();
    private final ConcurrentMap<String, String> cache = new ConcurrentHashMap<String, String>();

    public static NacosConfigProvidor me() {
        return NacosConfigProvidorHandler.ME;
    }

    private NacosConfigProvidor() {
        this.appPropertiesCache = new ConcurrentHashMap<String, Properties>();
        this.appCache = new ConcurrentHashMap<String, String>();
        try {
            Properties properties = new Properties();
            properties.put("username", CloudEnvironment.INSTANCE.getNacosUser());
            properties.put("password", CloudEnvironment.INSTANCE.getNacosPwd());
            properties.put("serverAddr", CloudEnvironment.INSTANCE.getNacosUrl());
            properties.put("namespace", CloudEnvironment.INSTANCE.getAppCode());
            this.configService = NacosFactory.createConfigService((Properties)properties);
            this.initConfig();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void initConfig() {
        try {
            Tuple2<Map<String, Properties>, Map<String, String>> myConfigData = this.processor.initConifgData(CloudEnvironment.INSTANCE.getAppCode(), CloudEnvironment.INSTANCE.getModuleCode());
            Tuple2<Map<String, Properties>, Map<String, String>> appConfigData = this.processor.initConifgData(CloudEnvironment.INSTANCE.getAppCode(), APP_CONFIG);
            this.appPropertiesCache.putAll((Map)appConfigData.first);
            this.appCache.putAll((Map)appConfigData.second);
            this.propertiesCache.putAll((Map)myConfigData.first);
            this.cache.putAll((Map)myConfigData.second);
            this.propertiesCache.keySet().forEach(k -> {
                try {
                    this.configService.addListener(CloudEnvironment.INSTANCE.getModuleCode(), k, (Listener)new ConfigChangeListener(CloudEnvironment.INSTANCE.getModuleCode(), (String)k));
                }
                catch (NacosException e) {
                    this.log.error("\u589e\u52a0\u76d1\u542c\u5668\u5f02\u5e38", (Throwable)e);
                    throw new RuntimeException(e);
                }
            });
            this.cache.keySet().forEach(k -> {
                try {
                    this.configService.addListener(CloudEnvironment.INSTANCE.getModuleCode(), k, (Listener)new ConfigChangeListener(CloudEnvironment.INSTANCE.getModuleCode(), (String)k));
                }
                catch (NacosException e) {
                    this.log.error("\u589e\u52a0\u76d1\u542c\u5668\u5f02\u5e38", (Throwable)e);
                    throw new RuntimeException(e);
                }
            });
            this.appPropertiesCache.keySet().forEach(k -> {
                try {
                    this.configService.addListener(APP_CONFIG, k, (Listener)new ConfigChangeListener(APP_CONFIG, (String)k));
                }
                catch (NacosException e) {
                    this.log.error("\u589e\u52a0\u76d1\u542c\u5668\u5f02\u5e38", (Throwable)e);
                    throw new RuntimeException(e);
                }
            });
            this.appCache.keySet().forEach(k -> {
                try {
                    this.configService.addListener(APP_CONFIG, k, (Listener)new ConfigChangeListener(APP_CONFIG, (String)k));
                }
                catch (NacosException e) {
                    this.log.error("\u589e\u52a0\u76d1\u542c\u5668\u5f02\u5e38", (Throwable)e);
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getConfigValue(String key) {
        String group = StringUtils.substringBefore((String)key, (String)".");
        Properties properties = (Properties)this.propertiesCache.get(group);
        if (null != properties) {
            String subKey = StringUtils.substringAfter((String)key, (String)".");
            return (String)properties.get(subKey);
        }
        String value = (String)this.cache.get(group);
        if (null != value) {
            return value;
        }
        Properties appProperties = (Properties)this.appPropertiesCache.get(group);
        if (null != appProperties) {
            String subKey = StringUtils.substringAfter((String)key, (String)".");
            return (String)appProperties.get(subKey);
        }
        return (String)this.appCache.get(group);
    }

    public boolean containsConfig(String key) {
        String group = StringUtils.substringBefore((String)key, (String)".");
        Properties properties = (Properties)this.propertiesCache.get(group);
        if (null != properties) {
            String subKey = StringUtils.substringAfter((String)key, (String)".");
            return properties.containsKey(subKey);
        }
        boolean containsKey = this.cache.containsKey(group);
        if (containsKey) {
            return true;
        }
        Properties appProperties = (Properties)this.appPropertiesCache.get(group);
        if (null != appProperties) {
            String subKey = StringUtils.substringAfter((String)key, (String)".");
            return appProperties.containsKey(subKey);
        }
        return this.appCache.containsKey(group);
    }

    public Map<String, String> getStringConfigInGroup(String key) {
        HashMap<String, String> result = new HashMap<String, String>();
        String group = StringUtils.substringBefore((String)key, (String)".");
        Properties properties = (Properties)this.propertiesCache.get(group);
        if (null != properties) {
            result.putAll((Map<String, String>)Maps.fromProperties((Properties)properties));
            return result;
        }
        Properties appProperties = (Properties)this.appPropertiesCache.get(group);
        if (null != appProperties) {
            result.putAll((Map<String, String>)Maps.fromProperties((Properties)appProperties));
            return result;
        }
        return null;
    }

    public Set<String> getGroups() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.appPropertiesCache.keySet());
        result.addAll(this.appCache.keySet());
        result.addAll(this.propertiesCache.keySet());
        result.addAll(this.cache.keySet());
        return result;
    }

    public void updateConfig(String dataId, String groupId, String data) {
        try {
            if (dataId.equals(APP_CONFIG)) {
                if (this.appPropertiesCache.containsKey(groupId)) {
                    Properties properties = new Properties();
                    properties.load(new StringReader(data));
                    this.appPropertiesCache.put(groupId, properties);
                } else {
                    this.appCache.put(groupId, data);
                }
            } else if (this.propertiesCache.containsKey(groupId)) {
                Properties properties = new Properties();
                properties.load(new StringReader(data));
                this.propertiesCache.put(groupId, properties);
            } else {
                this.cache.put(groupId, data);
            }
        }
        catch (Exception e) {
            this.log.error("\u66f4\u65b0\u914d\u7f6e\u5f02\u5e38\uff0cdataId\uff1a" + dataId + "\uff0c\u914d\u7f6e\u7ec4:" + groupId, (Throwable)e);
        }
    }

    private static final class NacosConfigProvidorHandler {
        private static final NacosConfigProvidor ME = new NacosConfigProvidor();

        private NacosConfigProvidorHandler() {
        }
    }
}

