/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.cloud.config;

import com.alibaba.nacos.api.config.ConfigType;
import com.alibaba.nacos.client.auth.impl.NacosClientAuthServiceImpl;
import com.alibaba.nacos.client.naming.utils.UtilAndComs;
import com.alibaba.nacos.common.http.HttpClientConfig;
import com.alibaba.nacos.common.http.HttpRestResult;
import com.alibaba.nacos.common.http.client.NacosRestTemplate;
import com.alibaba.nacos.common.http.client.request.HttpClientRequest;
import com.alibaba.nacos.common.http.client.request.JdkHttpClientRequest;
import com.alibaba.nacos.common.http.param.Header;
import com.alibaba.nacos.common.http.param.Query;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.plugin.auth.api.LoginIdentityContext;
import com.alibaba.nacos.shaded.com.google.common.collect.Lists;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.jplugin.common.kits.tuple.Tuple2;
import net.jplugin.core.config.api.CloudEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigProcessor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final NacosRestTemplate template = new NacosRestTemplate(this.log, (HttpClientRequest)new JdkHttpClientRequest(HttpClientConfig.builder().setConTimeOutMillis(3000).setReadTimeOutMillis(3000).build()));
    private static final String CONFIG_URL = "/v1/cs/configs";
    private volatile String token;

    private ConfigProcessor() {
        this.login();
    }

    public static ConfigProcessor me() {
        return ConfigProcessorHolder.ME;
    }

    private String login() {
        Properties properties = new Properties();
        properties.put("username", CloudEnvironment.INSTANCE.getNacosUser());
        properties.put("password", CloudEnvironment.INSTANCE.getNacosPwd());
        NacosClientAuthServiceImpl authService = new NacosClientAuthServiceImpl();
        authService.setServerList((List)Lists.newArrayList((Object[])new String[]{CloudEnvironment.INSTANCE.getNacosUrl()}));
        authService.setNacosRestTemplate(this.template);
        if (!authService.login(properties).booleanValue()) {
            throw new RuntimeException("\u767b\u5f55nacos\u5931\u8d25...");
        }
        LoginIdentityContext loginIdentityContext = authService.getLoginIdentityContext(null);
        this.token = loginIdentityContext.getParameter("accessToken");
        return this.token;
    }

    public Tuple2<Map<String, Properties>, Map<String, String>> initConifgData(String tenant, String dataId, String group) throws Exception {
        HashMap<String, Properties> propertiesMap = new HashMap<String, Properties>();
        HashMap<String, String> map = new HashMap<String, String>();
        String url = "http://" + CloudEnvironment.INSTANCE.getNacosUrl() + UtilAndComs.webContext + CONFIG_URL;
        url = url + "?pageNo=1";
        url = url + "&pageSize=100";
        url = url + "&search=accurate";
        url = null != dataId ? url + "&dataId=" + dataId : url + "&dataId=";
        url = null != group ? url + "&group=" + group : url + "&group=";
        url = url + "&tenant=" + tenant;
        url = url + "&accessToken=" + this.token;
        HttpRestResult restResult = this.template.get(url = url + "&username=" + CloudEnvironment.INSTANCE.getNacosUser(), Header.EMPTY, Query.EMPTY, String.class);
        if (!restResult.ok()) {
            this.log.error("login failed: {}", (Object)JacksonUtils.toJson((Object)restResult));
            throw new RuntimeException("\u83b7\u53d6\u914d\u7f6e\u63a5\u53e3\u8c03\u7528\u5f02\u5e38\uff1a" + restResult.getMessage());
        }
        JsonNode obj = JacksonUtils.toObj((String)((String)restResult.getData()));
        ArrayNode data = (ArrayNode)obj.get("pageItems");
        Iterator elements = data.elements();
        while (elements.hasNext()) {
            JsonNode node = (JsonNode)elements.next();
            String content = node.get("content").asText();
            String g = node.get("group").asText();
            String type = node.get("type").asText();
            if (ConfigType.PROPERTIES.getType().equals(type)) {
                Properties properties = new Properties();
                properties.load(new StringReader(content));
                propertiesMap.put(g, properties);
                continue;
            }
            map.put(g, content);
        }
        return Tuple2.with(propertiesMap, map);
    }

    public Tuple2<Map<String, Properties>, Map<String, String>> initConifgData(String tenant, String dataId) throws Exception {
        return this.initConifgData(tenant, dataId, null);
    }

    public Tuple2<Map<String, Properties>, Map<String, String>> initConifgData(String tenant) throws Exception {
        return this.initConifgData(tenant, null);
    }

    private static final class ConfigProcessorHolder {
        private static final ConfigProcessor ME = new ConfigProcessor();

        private ConfigProcessorHolder() {
        }
    }
}

