/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.cloud.common.api;

import java.io.File;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import net.jplugin.common.kits.FileKit;
import net.jplugin.common.kits.PropertiesKit;
import net.jplugin.common.kits.StringKit;
import net.jplugin.core.kernel.api.PluginEnvirement;
import org.w3c.dom.Document;

public class BasicConfiguration {
    String appCenterUrl;
    String esfPort;
    String appSign;
    String appCode;
    String moduleCode;

    private BasicConfiguration() {
    }

    public String getAppCenterUrl() {
        return this.appCenterUrl;
    }

    public String getAppCode() {
        return this.appCode;
    }

    public String getAppSign() {
        return this.appSign;
    }

    public String getEsfPort() {
        return this.esfPort;
    }

    public String getModuleCode() {
        return this.moduleCode;
    }

    @Deprecated
    public String getEsfPortHttp() {
        return "0";
    }

    public void _setESFPort(String ep) {
        this.esfPort = ep;
    }

    static BasicConfiguration create() {
        BasicConfiguration appConfiguration = null;
        if (BasicConfiguration.useJvmConfiguration()) {
            PluginEnvirement.INSTANCE.getStartLogger().log((Object)"Using basic configuration from JVM");
            appConfiguration = BasicConfiguration.createFromJvmParam();
        } else {
            PluginEnvirement.INSTANCE.getStartLogger().log((Object)"Using basic configuration from file");
            appConfiguration = BasicConfiguration.createFromConfigFile();
        }
        if (StringKit.isNull((String)appConfiguration.appCenterUrl)) {
            throw new RuntimeException("Basic config error:app-center-url have null value");
        }
        if (StringKit.isNull((String)appConfiguration.appCode)) {
            throw new RuntimeException("Basic config error:app-code have null value");
        }
        if (StringKit.isNull((String)appConfiguration.appSign)) {
            throw new RuntimeException("Basic config error:app-sign have null value");
        }
        if (!BasicConfiguration.checkServiceCode(appConfiguration.moduleCode)) {
            throw new RuntimeException("Service code format error:  can only contain letters");
        }
        if (StringKit.isNull((String)appConfiguration.esfPort)) {
            String tomcatPort = TomcatPortHelper.computeTomcatPort();
            if (StringKit.isNotNull((String)tomcatPort)) {
                appConfiguration.esfPort = Integer.parseInt(tomcatPort.trim()) + 100 + "";
            } else if (TomcatPortHelper.isEmbedTomcat()) {
                appConfiguration.esfPort = "-1";
            } else {
                throw new RuntimeException("Basic config error:esf-port have null value");
            }
            PluginEnvirement.INSTANCE.getStartLogger().log((Object)("Set esfPort as " + appConfiguration.esfPort));
        }
        PluginEnvirement.INSTANCE.getStartLogger().log((Object)("AppCenterUrl=" + appConfiguration.appCenterUrl + "  AppCode=" + appConfiguration.appCode + "  ESFPort=" + appConfiguration.esfPort));
        return appConfiguration;
    }

    private static boolean checkServiceCode(String serviceCode) {
        if (StringKit.isNull((String)serviceCode)) {
            return true;
        }
        for (char c : serviceCode.toCharArray()) {
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '-' || c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    private static boolean useJvmConfiguration() {
        PluginEnvirement.getInstance().getStartLogger().log((Object)"$$$ V3.0.0 not support Read BasicConfig from JVM vars");
        return false;
    }

    private static BasicConfiguration createFromConfigFile() {
        String cfgName = BasicConfiguration.getConfigPath();
        Properties prop = null;
        try {
            prop = PropertiesKit.loadProperties((String)cfgName);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't find basic-config.properties in your config dir:" + cfgName);
        }
        BasicConfiguration appConfiguration = new BasicConfiguration();
        appConfiguration.appCenterUrl = prop.getProperty("app-center-url");
        appConfiguration.appSign = prop.getProperty("app-sign");
        appConfiguration.appCode = prop.getProperty("app-code");
        appConfiguration.esfPort = prop.getProperty("esf-port");
        appConfiguration.moduleCode = prop.getProperty("module-code");
        return appConfiguration;
    }

    private static BasicConfiguration createFromJvmParam() {
        BasicConfiguration appConfiguration = new BasicConfiguration();
        Properties prop = System.getProperties();
        appConfiguration.appCenterUrl = prop.getProperty("app-center-url");
        appConfiguration.appSign = prop.getProperty("app-sign");
        appConfiguration.appCode = prop.getProperty("app-code");
        appConfiguration.esfPort = prop.getProperty("esf-port");
        appConfiguration.moduleCode = prop.getProperty("module-code");
        return appConfiguration;
    }

    public static String getConfigPath() {
        String p = BasicConfiguration.getHomeConfigPath();
        if (FileKit.existsAndIsFile((String)p)) {
            PluginEnvirement.getInstance().getStartLogger().log((Object)("Using Home basic-config:" + p));
            return p;
        }
        PluginEnvirement.getInstance().getStartLogger().log((Object)("Using Built-in basic-config:" + p));
        p = BasicConfiguration.getBuildInConfigPath();
        return p;
    }

    private static String getBuildInConfigPath() {
        return PluginEnvirement.INSTANCE.getConfigDir() + "/basic-config.properties";
    }

    private static String getHomeConfigPath() {
        if (System.getProperty("catalina.home") == null) {
            return PluginEnvirement.INSTANCE.getWorkDir() + "/basic-config.properties";
        }
        return System.getProperty("catalina.home") + "/basic-config.properties";
    }

    static class TomcatPortHelper {
        TomcatPortHelper() {
        }

        public static String computeTomcatPort() {
            String tomcatPort = System.getProperty("app.embedded.server.port");
            if (StringKit.isNotNull((String)tomcatPort)) {
                return tomcatPort;
            }
            String thome = TomcatPortHelper.getTomcatHome();
            if (StringKit.isNotNull((String)thome)) {
                tomcatPort = TomcatPortHelper.getTomcatPort(new File(thome + "/conf/server.xml"));
                PluginEnvirement.INSTANCE.getStartLogger().log((Object)("$$$ Get tomcat port from tomcat container: " + tomcatPort));
                if (StringKit.isNull((String)tomcatPort)) {
                    throw new RuntimeException("tomcat port can't be null");
                }
                return tomcatPort;
            }
            return null;
        }

        public static boolean isEmbedTomcat() {
            try {
                Class.forName("net.jplugin.extension.embed_tomcat.Plugin");
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        private static String getTomcatPort(File serverXml) {
            try {
                DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
                domFactory.setNamespaceAware(true);
                DocumentBuilder builder = domFactory.newDocumentBuilder();
                Document doc = builder.parse(serverXml);
                XPathFactory factory = XPathFactory.newInstance();
                XPath xpath = factory.newXPath();
                XPathExpression expr = xpath.compile("/Server/Service[@name='Catalina']/Connector[count(@scheme)=0]/@port[1]");
                String result = (String)expr.evaluate(doc, XPathConstants.STRING);
                if (StringKit.isNull((String)result)) {
                    throw new RuntimeException("Can't find tomcat port from file:" + serverXml.getAbsolutePath());
                }
                return result;
            }
            catch (Exception e) {
                throw new RuntimeException("can't find tomcat port from file" + serverXml, e);
            }
        }

        private static String getTomcatHome() {
            return System.getProperty("catalina.home");
        }
    }
}

