/*
 * Decompiled with CFR 0.152.
 */
package net.joshka.junit.json.params;

import jakarta.json.JsonObject;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.params.converter.ArgumentConversionException;
import org.junit.jupiter.params.converter.ArgumentConverter;

public class JsonConverter
implements ArgumentConverter {
    public Object convert(Object source, ParameterContext context) {
        if (!(source instanceof JsonObject)) {
            throw new ArgumentConversionException("Not a JsonObject");
        }
        JsonObject json = (JsonObject)source;
        String name = context.getParameter().getName();
        Class<?> type = context.getParameter().getType();
        if (type == String.class) {
            return json.getString(name);
        }
        if (type == Integer.TYPE) {
            return json.getInt(name);
        }
        if (type == Boolean.TYPE) {
            return json.getBoolean(name);
        }
        throw new ArgumentConversionException("Can't convert to type: '" + type.getName() + "'");
    }
}

