/*
 * Decompiled with CFR 0.152.
 */
package net.jolivier.s3api.http.filter;

import jakarta.ws.rs.core.MultivaluedMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class RangedOutputStream
extends OutputStream {
    private static final char[] MULTIPART_CHARS = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final String BOUNDARY_LINE_FORMAT = "--%s";
    private static final String CONTENT_TYPE_LINE_FORMAT = "Content-Type: %s";
    private static final String CONTENT_RANGE_FORMAT = "%s %d-%d/%d";
    private static final String CONTENT_RANGE_LINE_FORMAT = "Content-Range: %s %d-%d/%d";
    private static final String EMPTY_LINE = "\r\n";
    private final OutputStream outputStream;
    private final String boundary;
    private final String accept;
    private final String contentType;
    private final boolean multipart;
    private boolean flushed = false;
    private long pos = 0L;
    private final List<Range> ranges = new ArrayList<Range>();
    private final MultivaluedMap<String, Object> headers;

    public RangedOutputStream(OutputStream outputStream, long contentLength, String ranges, String contentType, MultivaluedMap<String, Object> headers) {
        this.outputStream = outputStream;
        String[] acceptRanges = ranges.split("=");
        this.accept = acceptRanges[0];
        for (String range : acceptRanges[1].split(",")) {
            if (range.startsWith("-")) {
                long lowerBound = Math.abs(Long.parseLong(range));
                this.ranges.add(new Range(contentLength - lowerBound, contentLength));
                continue;
            }
            String[] bounds = range.split("-");
            Long lowerBound = Long.valueOf(bounds[0]);
            this.ranges.add(new Range(lowerBound, bounds.length == 2 ? Long.valueOf(bounds[1]) : 0L));
        }
        this.headers = headers;
        this.contentType = contentType;
        this.multipart = this.ranges.size() > 1;
        this.boundary = this.generateBoundary();
    }

    private String generateBoundary() {
        StringBuilder buffer = new StringBuilder();
        Random rand = new Random();
        int count = rand.nextInt(11) + 30;
        for (int i = 0; i < count; ++i) {
            buffer.append(MULTIPART_CHARS[rand.nextInt(MULTIPART_CHARS.length)]);
        }
        return buffer.toString();
    }

    public boolean isMultipart() {
        return this.multipart;
    }

    public String getBoundary() {
        return this.boundary;
    }

    public String getAcceptRanges() {
        return this.accept;
    }

    @Override
    public void write(int b) throws IOException {
        for (Range range : this.ranges) {
            if (!range.contains(this.pos)) continue;
            range.write(b);
        }
        ++this.pos;
    }

    @Override
    public void flush() throws IOException {
        if (this.flushed) {
            return;
        }
        if (this.multipart) {
            this.headers.putSingle((Object)"Content-Type", (Object)String.format("multipart/byteranges; boundary=%s", this.boundary));
            for (Range range : this.ranges) {
                this.outputStream.write(String.format(BOUNDARY_LINE_FORMAT.concat(EMPTY_LINE), this.boundary).getBytes());
                this.outputStream.write(String.format(CONTENT_TYPE_LINE_FORMAT.concat(EMPTY_LINE), this.contentType).getBytes());
                this.outputStream.write(String.format(CONTENT_RANGE_LINE_FORMAT.concat(EMPTY_LINE), this.accept, range.getFrom(), range.getTo(this.pos), this.pos).getBytes());
                this.outputStream.write(EMPTY_LINE.getBytes());
                this.outputStream.write(range.getBytes());
                this.outputStream.write(EMPTY_LINE.getBytes());
            }
            this.outputStream.write(String.format(BOUNDARY_LINE_FORMAT, this.boundary + "--").getBytes());
        } else {
            Range range = this.ranges.get(0);
            this.headers.putSingle((Object)"Content-Range", (Object)String.format(CONTENT_RANGE_FORMAT, this.accept, range.getFrom(), range.getTo(this.pos), this.pos));
            this.outputStream.write(range.getBytes());
        }
        this.flushed = true;
    }

    public class Range
    extends OutputStream {
        private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        private final long from;
        private final long to;

        public Range(long from, long to) {
            this.from = from;
            this.to = to;
        }

        public boolean contains(long index) {
            if (this.to == 0L) {
                return this.from <= index;
            }
            return this.from <= index && index <= this.to;
        }

        public byte[] getBytes() {
            return this.outputStream.toByteArray();
        }

        public long getFrom() {
            return this.from;
        }

        public Long getTo(long ifZero) {
            return this.to == 0L ? ifZero : this.to;
        }

        @Override
        public void write(int b) throws IOException {
            this.outputStream.write(b);
        }
    }
}

