/*
 * Decompiled with CFR 0.152.
 */
package net.jolivier.s3api.http.filter;

import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.OutputStream;
import net.jolivier.s3api.http.filter.RangedOutputStream;

public class RangeResponseFilter
implements ContainerResponseFilter {
    private static final String ACCEPT_RANGES = "Accept-Ranges";
    private static final String BYTES_RANGE = "bytes";
    private static final String RANGE = "Range";
    private static final String IF_RANGE = "If-Range";

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        responseContext.getHeaders().add((Object)ACCEPT_RANGES, (Object)BYTES_RANGE);
        if (!requestContext.getHeaders().containsKey((Object)RANGE)) {
            return;
        }
        if (requestContext.getHeaders().containsKey((Object)IF_RANGE)) {
            String ifRangeHeader = requestContext.getHeaderString(IF_RANGE);
            if (responseContext.getHeaders().containsKey((Object)"ETag") && responseContext.getHeaderString("ETag").equals(ifRangeHeader)) {
                this.applyFilter(requestContext, responseContext);
                return;
            }
            if (responseContext.getHeaders().containsKey((Object)"Last-Modified") && responseContext.getHeaderString("Last-Modified").equals(ifRangeHeader)) {
                this.applyFilter(requestContext, responseContext);
                return;
            }
        } else {
            this.applyFilter(requestContext, responseContext);
        }
    }

    private void applyFilter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        String rangeHeader = requestContext.getHeaderString(RANGE);
        String contentType = responseContext.getMediaType().toString();
        OutputStream originOutputStream = responseContext.getEntityStream();
        RangedOutputStream rangedOutputStream = new RangedOutputStream(originOutputStream, responseContext.getLength(), rangeHeader, contentType, (MultivaluedMap<String, Object>)responseContext.getHeaders());
        responseContext.setStatus(Response.Status.PARTIAL_CONTENT.getStatusCode());
        responseContext.setEntityStream((OutputStream)rangedOutputStream);
    }
}

