/*
 * Decompiled with CFR 0.152.
 */
package net.jolivier.s3api.http;

import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import net.jolivier.s3api.exception.NoSuchBucketException;
import net.jolivier.s3api.http.ApiPoint;

@Provider
@PreMatching
public class VirtualHostMatchingFilter
implements ContainerRequestFilter {
    @Context
    private ResourceInfo resourceInfo;

    public void filter(ContainerRequestContext ctx) throws IOException {
        String base;
        String host = ctx.getHeaderString("Host");
        int index = host.lastIndexOf(base = ApiPoint.domainBase());
        if (index < 0) {
            throw NoSuchBucketException.noSuchBucket((String)host);
        }
        String bucket = host.substring(0, index);
        ctx.setProperty("bucket", (Object)bucket);
        ctx.setProperty("key", (Object)ctx.getUriInfo().getRequestUri().getPath().replaceFirst("/", ""));
    }
}

