/*
 * Decompiled with CFR 0.152.
 */
package net.jolivier.s3api.http;

import com.google.common.base.Strings;
import jakarta.inject.Singleton;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.Provider;
import java.net.URI;
import net.jolivier.s3api.auth.AwsSigV4;
import net.jolivier.s3api.auth.S3Context;
import net.jolivier.s3api.exception.InvalidAuthException;
import net.jolivier.s3api.exception.NoSuchBucketException;
import net.jolivier.s3api.exception.RequestFailedException;
import net.jolivier.s3api.http.ApiPoint;
import net.jolivier.s3api.http.RequestUtils;
import net.jolivier.s3api.model.Owner;
import net.jolivier.s3api.model.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Singleton
public class SignatureFilter
implements ContainerRequestFilter {
    public static final String CTX_KEY = "s3ctx";
    private static final Logger _logger = LoggerFactory.getLogger(SignatureFilter.class);
    public static final String ORIG_URI = "originalUri";

    public void filter(ContainerRequestContext ctx) {
        UriInfo uriInfo = ctx.getUriInfo();
        String requestId = S3Context.createRequestId();
        String authorization = ctx.getHeaderString("Authorization");
        if (!Strings.isNullOrEmpty((String)authorization)) {
            AwsSigV4 sigv4 = new AwsSigV4(authorization);
            User user = ApiPoint.auth().user(sigv4.accessKeyId());
            URI requestUri = ctx.getPropertyNames().contains(ORIG_URI) ? (URI)ctx.getProperty(ORIG_URI) : uriInfo.getRequestUri();
            String computedAuth = RequestUtils.calculateV4Sig(ctx, requestUri, sigv4.signedHeaders(), sigv4.accessKeyId(), user.secretAccessKey(), sigv4.region());
            if (!authorization.equals(computedAuth)) {
                throw InvalidAuthException.invalidAuth();
            }
            ctx.setProperty("sigv4", (Object)sigv4);
        }
        String bucket = (String)ctx.getProperty("bucket");
        boolean isPublic = false;
        if (Strings.isNullOrEmpty((String)bucket) && !Strings.isNullOrEmpty((String)ctx.getUriInfo().getPath())) {
            throw RequestFailedException.invalidRequest((String)"NoBucket", (String)"No bucket provided");
        }
        if (!Strings.isNullOrEmpty((String)bucket)) {
            if (!RequestUtils.BUCKET_REGEX.matcher(bucket).matches()) {
                throw RequestFailedException.invalidBucketName();
            }
            if (!"PUT".equals(ctx.getMethod()) && !ApiPoint.data().bucketExists(bucket)) {
                throw NoSuchBucketException.noSuchBucket((String)bucket);
            }
            isPublic = ApiPoint.data().isBucketPublic(bucket);
        }
        if (!isPublic) {
            String receivedAuth = authorization;
            if (Strings.isNullOrEmpty((String)receivedAuth)) {
                throw InvalidAuthException.noAuthorizationHeader();
            }
            AwsSigV4 sigv4 = new AwsSigV4(receivedAuth);
            User user = ApiPoint.auth().user(sigv4.accessKeyId());
            URI requestUri = ctx.getPropertyNames().contains(ORIG_URI) ? (URI)ctx.getProperty(ORIG_URI) : uriInfo.getRequestUri();
            String computedAuth = RequestUtils.calculateV4Sig(ctx, requestUri, sigv4.signedHeaders(), sigv4.accessKeyId(), user.secretAccessKey(), sigv4.region());
            if (!receivedAuth.equals(computedAuth)) {
                throw InvalidAuthException.invalidAuth();
            }
            ctx.setProperty("sigv4", (Object)sigv4);
            if (!Strings.isNullOrEmpty((String)bucket)) {
                ctx.setProperty(CTX_KEY, (Object)S3Context.bucketRestricted((String)requestId, (String)bucket, (User)user, (Owner)ApiPoint.auth().findOwner(user)));
            } else {
                ctx.setProperty(CTX_KEY, (Object)S3Context.noBucket((String)requestId, (User)user, (Owner)ApiPoint.auth().findOwner(user)));
            }
        } else {
            ctx.setProperty(CTX_KEY, (Object)S3Context.bucketPublic((String)requestId, (String)bucket, (Owner)ApiPoint.auth().findOwner(bucket)));
        }
    }
}

