/*
 * Decompiled with CFR 0.152.
 */
package net.jolivier.s3api.http;

import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import net.jolivier.s3api.BucketOptional;
import net.jolivier.s3api.auth.S3Context;
import net.jolivier.s3api.exception.InternalErrorException;
import net.jolivier.s3api.exception.InvalidAuthException;
import net.jolivier.s3api.exception.NotImplementedException;
import net.jolivier.s3api.exception.PreconditionFailedException;
import net.jolivier.s3api.exception.RequestFailedException;
import net.jolivier.s3api.http.ApiPoint;
import net.jolivier.s3api.http.ChunkedInputStream;
import net.jolivier.s3api.http.RequestUtils;
import net.jolivier.s3api.model.CopyObjectResult;
import net.jolivier.s3api.model.DeleteObjectsRequest;
import net.jolivier.s3api.model.DeleteResult;
import net.jolivier.s3api.model.GetObjectResult;
import net.jolivier.s3api.model.HeadObjectResult;
import net.jolivier.s3api.model.ListAllMyBucketsResult;
import net.jolivier.s3api.model.Owner;
import net.jolivier.s3api.model.PutObjectResult;
import org.glassfish.jersey.server.ContainerRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class S3Objects {
    private static final Logger _logger = LoggerFactory.getLogger(S3Objects.class);

    @Path(value="/{key: .+}")
    @GET
    public Response getObject(@Context S3Context ctx, @Context ContainerRequest request, @NotNull @PathParam(value="key") String key, @QueryParam(value="versionId") String versionId) {
        MultivaluedMap query = request.getUriInfo().getQueryParameters();
        if (query.containsKey((Object)"legal-hold")) {
            throw NotImplementedException.notImplemented((S3Context)ctx, (String)"Object hold operations are not implemented");
        }
        if (query.containsKey((Object)"retention")) {
            throw NotImplementedException.notImplemented((S3Context)ctx, (String)"Object retention operations are not implemented");
        }
        if (query.containsKey((Object)"object-lock")) {
            throw NotImplementedException.notImplemented((S3Context)ctx, (String)"Object lock operations are not implemented");
        }
        GetObjectResult result = ApiPoint.data().getObject(ctx, ctx.bucket(), key, Optional.ofNullable(versionId));
        Response.ResponseBuilder conditionalResponse = request.evaluatePreconditions(Date.from(result.getModified().toInstant()), new EntityTag(result.getEtag(), false));
        if (conditionalResponse != null) {
            Response res = conditionalResponse.build();
            if (res.getStatus() == Response.Status.PRECONDITION_FAILED.getStatusCode()) {
                throw PreconditionFailedException.preconditionFailed((S3Context)ctx, (String)key);
            }
            return res;
        }
        return RequestUtils.writeMetadataHeaders(Response.ok((Object)result.getData()), result.getMetadata()).type(result.getContentType()).tag(result.getEtag()).lastModified(Date.from(result.getModified().toInstant())).build();
    }

    @Path(value="/{key: .+}")
    @HEAD
    public Response headObject(@Context S3Context ctx, @NotNull @PathParam(value="key") String key, @QueryParam(value="versionId") String versionId) {
        HeadObjectResult result = ApiPoint.data().headObject(ctx, ctx.bucket(), key, Optional.ofNullable(versionId));
        return RequestUtils.writeMetadataHeaders(Response.ok(), result.getMetadata()).type(result.contentType()).tag(result.etag()).lastModified(Date.from(result.modified().toInstant())).build();
    }

    @Path(value="/{key: .+}")
    @DELETE
    public Response deleteObject(@Context S3Context ctx, @NotNull @PathParam(value="key") String key, @QueryParam(value="versionId") String versionId) {
        boolean result = ApiPoint.data().deleteObject(ctx, ctx.bucket(), key, Optional.ofNullable(versionId));
        return Response.status((int)(result ? 204 : 404)).build();
    }

    @POST
    @Produces(value={"application/xml"})
    public DeleteResult deleteObjects(@Context S3Context ctx, @Context ContainerRequest request) {
        if (!request.getUriInfo().getQueryParameters().containsKey((Object)"delete")) {
            throw RequestFailedException.invalidRequest((S3Context)ctx, (String)"delete required");
        }
        DeleteObjectsRequest req = RequestUtils.readJaxbEntity(DeleteObjectsRequest.class, request.getEntityStream());
        if (req.getObjects().size() > 1000) {
            List objects = req.getObjects();
            req.setObjects(objects.subList(0, 1000));
        }
        DeleteResult result = ApiPoint.data().deleteObjects(ctx, ctx.bucket(), req);
        return result;
    }

    @Path(value="/{key: .+}")
    @PUT
    public Response putOrCopy(@Context S3Context ctx, @NotNull @PathParam(value="key") String key, @HeaderParam(value="Content-MD5") String inputMd5, @HeaderParam(value="Content-Type") String contentType, @HeaderParam(value="x-amz-copy-source") String sourceKey, @Context ContainerRequest request) {
        Response response;
        block17: {
            MultivaluedMap query = request.getUriInfo().getQueryParameters();
            if (query.containsKey((Object)"legal-hold")) {
                throw NotImplementedException.notImplemented((S3Context)ctx, (String)"Object hold operations are not implemented");
            }
            if (query.containsKey((Object)"retention")) {
                throw NotImplementedException.notImplemented((S3Context)ctx, (String)"Object retention operations are not implemented");
            }
            if (query.containsKey((Object)"object-lock")) {
                throw NotImplementedException.notImplemented((S3Context)ctx, (String)"Object lock operations are not implemented");
            }
            if (sourceKey != null) {
                if (sourceKey.startsWith("/")) {
                    sourceKey = sourceKey.replaceFirst("/", "");
                }
                int idx = sourceKey.indexOf("/");
                String srcBucket = sourceKey.substring(0, idx);
                Owner srcOwner = ApiPoint.auth().findOwner(srcBucket);
                if (!srcOwner.getId().equals(ctx.owner().getId())) {
                    throw InvalidAuthException.incorrectOwner();
                }
                String srcKey = sourceKey.substring(idx + 1);
                boolean copyMetadata = "copy".equals(request.getHeaderString("x-amz-metadata-directive"));
                CopyObjectResult result = ApiPoint.data().copyObject(ctx, srcBucket, srcKey, ctx.bucket(), key, copyMetadata, copyMetadata ? Collections.emptyMap() : RequestUtils.metadataHeaders(request));
                return Response.ok((Object)result).build();
            }
            if (!request.getHeaders().containsKey((Object)"Content-Length")) {
                throw RequestFailedException.missingContentLength((String)key);
            }
            if (request.getLength() < 0) {
                throw RequestFailedException.invalidContentLength((String)key);
            }
            InputStream in = S3Objects.isV4ChunkedRequest(request) ? new ChunkedInputStream(request.getEntityStream()) : request.getEntityStream();
            try {
                Optional<byte[]> md5 = Optional.ofNullable(inputMd5).map(Base64.getDecoder()::decode);
                if (md5.isPresent() && md5.get().length != 16) {
                    throw RequestFailedException.invalidDigest((String)key);
                }
                PutObjectResult result = ApiPoint.data().putObject(ctx, ctx.bucket(), key, md5, request.getLength(), Optional.ofNullable(contentType), RequestUtils.metadataHeaders(request), in);
                Response.ResponseBuilder res = Response.ok().tag(result.etag());
                result.versionId().ifPresent(v -> res.header("x-amz-version-id", v));
                response = res.build();
                if (in == null) break block17;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw InternalErrorException.internalError((S3Context)ctx, (String)key, (String)e.getLocalizedMessage());
                }
            }
            in.close();
        }
        return response;
    }

    private static final boolean isV4ChunkedRequest(ContainerRequest req) {
        String h = req.getHeaderString("x-amz-content-sha256");
        return h != null && h.equals("STREAMING-AWS4-HMAC-SHA256-PAYLOAD");
    }

    @GET
    @Produces(value={"application/xml"})
    @BucketOptional
    public Response listObjectsOrListBuckets(@Context S3Context ctx, @QueryParam(value="delimiter") String delimiter, @QueryParam(value="encoding-type") String encodingType, @QueryParam(value="marker") String marker, @QueryParam(value="VersionIdMarker") String versionIdMarker, @DefaultValue(value="1000") @QueryParam(value="max-keys") int maxKeys, @QueryParam(value="prefix") String prefix, @Context UriInfo uriInfo) {
        if (maxKeys > 1000 || maxKeys < 1) {
            throw RequestFailedException.invalidRequest((S3Context)ctx, (String)"Invalid maxKeys");
        }
        if (ctx.optBucket().isEmpty()) {
            ListAllMyBucketsResult result = ApiPoint.data().listBuckets(ctx);
            return Response.ok((Object)result).build();
        }
        MultivaluedMap query = uriInfo.getQueryParameters();
        if (!query.isEmpty()) {
            if (query.containsKey((Object)"object-lock")) {
                throw NotImplementedException.notImplemented((S3Context)ctx, (String)"object lock is not implemented");
            }
            if (query.containsKey((Object)"versioning")) {
                return Response.ok((Object)ApiPoint.data().getBucketVersioning(ctx, ctx.bucket())).build();
            }
            if (query.containsKey((Object)"publicAccessBlock")) {
                return Response.ok((Object)ApiPoint.data().getPublicAccessBlock(ctx, ctx.bucket())).build();
            }
            if (query.containsKey((Object)"versions")) {
                return Response.ok((Object)ApiPoint.data().listObjectVersions(ctx, ctx.bucket(), Optional.ofNullable(delimiter), Optional.ofNullable(encodingType), Optional.ofNullable(marker), Optional.ofNullable(versionIdMarker), maxKeys, Optional.ofNullable(prefix))).build();
            }
        }
        return Response.ok((Object)ApiPoint.data().listObjects(ctx, ctx.bucket(), Optional.ofNullable(delimiter), Optional.ofNullable(encodingType), Optional.ofNullable(marker), maxKeys, Optional.ofNullable(prefix))).build();
    }
}

