/*
 * Decompiled with CFR 0.152.
 */
package net.jolivier.s3api.http;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import net.jolivier.s3api.BucketOptional;
import net.jolivier.s3api.auth.S3Context;
import net.jolivier.s3api.exception.NotImplementedException;
import net.jolivier.s3api.exception.RequestFailedException;
import net.jolivier.s3api.http.ApiPoint;
import net.jolivier.s3api.http.RequestUtils;
import net.jolivier.s3api.model.CreateBucketConfiguration;
import net.jolivier.s3api.model.PublicAccessBlockConfiguration;
import net.jolivier.s3api.model.VersioningConfiguration;
import org.glassfish.jersey.server.ContainerRequest;

@Path(value="/")
public class S3Buckets {
    @HEAD
    @BucketOptional
    public Response headBucket(@Context S3Context ctx) {
        boolean result = ApiPoint.data().headBucket(ctx, ctx.bucket());
        return result ? Response.ok().build() : Response.status((int)404).build();
    }

    @PUT
    @Consumes(value={"application/xml"})
    @BucketOptional
    public Response createBucket(@Context S3Context ctx, @Context ContainerRequest req, @Context UriInfo uriInfo) throws IOException {
        MultivaluedMap query = uriInfo.getQueryParameters();
        if (query.containsKey((Object)"versioning")) {
            VersioningConfiguration config = RequestUtils.readJaxbEntity(VersioningConfiguration.class, req.getEntityStream());
            if (!ApiPoint.data().putBucketVersioning(ctx, ctx.bucket(), config)) {
                throw RequestFailedException.invalidBucketState((S3Context)ctx);
            }
            return Response.ok().build();
        }
        if (query.containsKey((Object)"publicAccessBlock")) {
            PublicAccessBlockConfiguration config = RequestUtils.readJaxbEntity(PublicAccessBlockConfiguration.class, req.getEntityStream());
            if (!ApiPoint.data().putPublicAccessBlock(ctx, ctx.bucket(), config)) {
                throw RequestFailedException.invalidArgument((S3Context)ctx, (String)"Unable to put bucket PublicAccessBlock");
            }
            return Response.ok().build();
        }
        if (query.containsKey((Object)"lifecycle") || query.containsKey((Object)"object-lock")) {
            throw NotImplementedException.notImplemented((S3Context)ctx, (String)"Lifecycle operations are not implemented");
        }
        if (query.containsKey((Object)"logging")) {
            throw NotImplementedException.notImplemented((S3Context)ctx, (String)"Bucket logging operations are not implemented");
        }
        if (query.containsKey((Object)"policy")) {
            throw NotImplementedException.notImplemented((S3Context)ctx, (String)"Bucket policy operations are not implemented");
        }
        if (query.containsKey((Object)"encryption")) {
            throw NotImplementedException.notImplemented((S3Context)ctx, (String)"Bucket encryption operations are not implemented");
        }
        String location = "us-east-1";
        if (req.hasEntity() && req.getLength() > 0) {
            CreateBucketConfiguration config = RequestUtils.readJaxbEntity(CreateBucketConfiguration.class, req.getEntityStream());
            location = config.getLocation();
        }
        if (!ApiPoint.data().createBucket(ctx, ctx.bucket(), location)) {
            throw RequestFailedException.invalidArgument((S3Context)ctx, (String)"Unable to create bucket");
        }
        return Response.ok().build();
    }

    @DELETE
    public Response deleteBucket(@Context S3Context ctx, @Context UriInfo uriInfo) {
        if (uriInfo.getQueryParameters().containsKey((Object)"publicAccessBlock")) {
            if (!ApiPoint.data().deletePublicAccessBlock(ctx, ctx.bucket())) {
                throw RequestFailedException.invalidArgument((S3Context)ctx, (String)"Unable to delete bucket PublicAccessBlock");
            }
            return Response.noContent().build();
        }
        if (!ApiPoint.data().deleteBucket(ctx, ctx.bucket())) {
            throw RequestFailedException.invalidArgument((S3Context)ctx, (String)"Unable to delete bucket");
        }
        return Response.noContent().build();
    }
}

