/*
 * Decompiled with CFR 0.152.
 */
package net.jolivier.s3api.http;

import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Response;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.jolivier.s3api.exception.InvalidAuthException;
import org.glassfish.jersey.server.ContainerRequest;
import uk.co.lucasweb.aws.v4.signer.HttpRequest;
import uk.co.lucasweb.aws.v4.signer.Signer;
import uk.co.lucasweb.aws.v4.signer.SigningException;
import uk.co.lucasweb.aws.v4.signer.credentials.AwsCredentials;

public enum RequestUtils {

    public static final Pattern BUCKET_REGEX = Pattern.compile("(?=^.{3,63}$)(?!^(\\d+\\.)+\\d+$)(^(([a-z0-9]|[a-z0-9][a-z0-9\\-]*[a-z0-9])\\.)*([a-z0-9]|[a-z0-9][a-z0-9\\-]*[a-z0-9])$)");

    public static <T> T readJaxbEntity(Class<T> cls, InputStream input) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{cls});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            return (T)jaxbUnmarshaller.unmarshal((Reader)new InputStreamReader(input));
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T readJaxbEntity(Class<T> cls, String content) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{cls});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            return (T)jaxbUnmarshaller.unmarshal((Reader)new StringReader(content));
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public static String writeJaxbEntity(Object xml) {
        try {
            JAXBContext jaxb = JAXBContext.newInstance((Class[])new Class[]{xml.getClass()});
            Marshaller marshaller = jaxb.createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)true);
            StringWriter writer = new StringWriter();
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            marshaller.marshal(xml, (Writer)writer);
            return writer.toString();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public static final String calculateV4Sig(ContainerRequestContext request, URI requestUri, String signedHeaders, String accessKey, String secretKey, String region) {
        try {
            Signer.Builder signer = Signer.builder();
            signer.awsCredentials(new AwsCredentials(accessKey, secretKey)).region(region);
            Map<String, String> map = request.getHeaders().entrySet().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).toLowerCase(), e -> ((String)((List)e.getValue()).get(0)).trim()));
            for (String name : signedHeaders.split(";")) {
                signer.header(name.trim(), map.get(name));
            }
            String signature = signer.buildS3(new HttpRequest(request.getMethod(), requestUri), request.getHeaderString("x-amz-content-sha256")).getSignature();
            return signature;
        }
        catch (SigningException e2) {
            throw InvalidAuthException.malformedSignature();
        }
    }

    public static final Map<String, String> metadataHeaders(ContainerRequest req) {
        HashMap<String, String> map = new HashMap<String, String>();
        req.getHeaders().keySet().stream().filter(s -> s.startsWith("x-amz-meta-")).forEach(key -> map.put((String)key, req.getHeaderString(key)));
        return map;
    }

    public static final Response.ResponseBuilder writeMetadataHeaders(Response.ResponseBuilder res, Map<String, String> headers) {
        headers.entrySet().forEach(e -> res.header((String)e.getKey(), e.getValue()));
        return res;
    }
}

