/*
 * Decompiled with CFR 0.152.
 */
package net.jolivier.s3api.http;

import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.PathSegment;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;

@Provider
@PreMatching
public class PathMatchingFilter
implements ContainerRequestFilter {
    @Context
    private ResourceInfo resourceInfo;

    public void filter(ContainerRequestContext ctx) throws IOException {
        UriInfo uriInfo = ctx.getUriInfo();
        List segments = uriInfo.getPathSegments();
        String bucket = segments.isEmpty() ? null : ((PathSegment)segments.get(0)).getPath();
        URI requestUri = uriInfo.getRequestUri();
        String key = segments.size() > 1 ? String.join((CharSequence)"/", segments.subList(1, segments.size()).stream().map(PathSegment::getPath).collect(Collectors.toList())) : "/";
        UriBuilder builder = UriBuilder.fromUri((URI)requestUri).replacePath(key);
        URI baseUri = uriInfo.getBaseUri();
        ctx.setProperty("bucket", (Object)bucket);
        ctx.setProperty("key", (Object)key);
        ctx.setProperty("originalUri", (Object)requestUri);
        ctx.setRequestUri(baseUri, builder.build(new Object[0]));
    }
}

