/*
 * Decompiled with CFR 0.152.
 */
package net.jolivier.s3api.http;

import com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public class ChunkedInputStream
extends InputStream {
    private static final byte[] CRLF = "\r\n".getBytes(StandardCharsets.UTF_8);
    private static final byte[] DELIMITER = ";".getBytes(StandardCharsets.UTF_8);
    private final InputStream _source;
    private final ByteBuffer _byteBuf = ByteBuffer.allocate(262144);
    private int _remainingInChunk = 0;

    public ChunkedInputStream(InputStream source) {
        this._source = source;
    }

    @Override
    public void close() throws IOException {
        this._source.close();
    }

    private boolean endsWith(ByteBuffer buffer, byte[] endSequence) {
        int pos = buffer.position();
        if (pos >= endSequence.length) {
            for (int i = 0; i < endSequence.length; ++i) {
                if (buffer.get(pos - endSequence.length + i) == endSequence[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private byte[] readUntil(byte[] endSequence) throws IOException {
        this._byteBuf.clear();
        while (!this.endsWith(this._byteBuf.asReadOnlyBuffer(), endSequence)) {
            int c = this._source.read();
            if (c < 0) {
                return null;
            }
            byte unsigned = (byte)(c & 0xFF);
            this._byteBuf.put(unsigned);
        }
        byte[] result = new byte[this._byteBuf.position() - endSequence.length];
        this._byteBuf.rewind();
        this._byteBuf.get(result);
        return result;
    }

    private static final int parseOrThrow(byte[] in) {
        String trimmed = new String(in, StandardCharsets.UTF_8).trim();
        Integer parsed = Ints.tryParse((String)trimmed, (int)16);
        if (parsed == null) {
            throw new IllegalArgumentException("Invalid integer: " + trimmed);
        }
        return parsed;
    }

    @Override
    public int read() throws IOException {
        if (this._remainingInChunk == 0) {
            byte[] hexLengthBytes = this.readUntil(DELIMITER);
            if (hexLengthBytes == null) {
                return -1;
            }
            this._remainingInChunk = ChunkedInputStream.parseOrThrow(hexLengthBytes);
            if (this._remainingInChunk == 0) {
                return -1;
            }
            this.readUntil(CRLF);
        }
        --this._remainingInChunk;
        return this._source.read();
    }
}

