/*
 * Decompiled with CFR 0.152.
 */
package net.jolivier.s3api.memory;

import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.jolivier.s3api.S3AuthStore;
import net.jolivier.s3api.S3DataStore;
import net.jolivier.s3api.auth.S3Context;
import net.jolivier.s3api.exception.ConflictException;
import net.jolivier.s3api.exception.InternalErrorException;
import net.jolivier.s3api.exception.InvalidAuthException;
import net.jolivier.s3api.exception.NoSuchBucketException;
import net.jolivier.s3api.exception.RequestFailedException;
import net.jolivier.s3api.memory.IBucket;
import net.jolivier.s3api.memory.MemoryBucket;
import net.jolivier.s3api.model.Bucket;
import net.jolivier.s3api.model.CopyObjectResult;
import net.jolivier.s3api.model.DeleteObjectsRequest;
import net.jolivier.s3api.model.DeleteResult;
import net.jolivier.s3api.model.GetObjectResult;
import net.jolivier.s3api.model.HeadObjectResult;
import net.jolivier.s3api.model.ListAllMyBucketsResult;
import net.jolivier.s3api.model.ListBucketResult;
import net.jolivier.s3api.model.ListBucketResultV2;
import net.jolivier.s3api.model.ListVersionsResult;
import net.jolivier.s3api.model.Owner;
import net.jolivier.s3api.model.PublicAccessBlockConfiguration;
import net.jolivier.s3api.model.PutObjectResult;
import net.jolivier.s3api.model.User;
import net.jolivier.s3api.model.VersioningConfiguration;

public enum S3MemoryImpl implements S3DataStore,
S3AuthStore
{
    INSTANCE;

    private static final Map<String, User> USERS;
    private static final Map<String, Owner> OWNERS;
    private static final Map<String, String> USER_OWNER_MAPPING;
    private static final User USER;
    private static final Owner OWNER;
    private static final Map<String, IBucket> BUCKETS;

    public static final void configure(boolean defaultAccounts) {
        if (defaultAccounts) {
            for (int i = 1; i < 10; ++i) {
                User u1 = new User("accesskey" + i, "secretkey" + i);
                USERS.put(u1.accessKeyId(), u1);
                USER_OWNER_MAPPING.put(u1.accessKeyId(), OWNER.getId());
            }
            USERS.put(USER.accessKeyId(), USER);
            OWNERS.put(OWNER.getId(), OWNER);
            USER_OWNER_MAPPING.put(USER.accessKeyId(), OWNER.getId());
        }
    }

    private static final IBucket bucket(S3Context ctx, String name) {
        IBucket bucket = BUCKETS.get(name);
        if (bucket == null) {
            throw NoSuchBucketException.noSuchBucket((S3Context)ctx);
        }
        return bucket;
    }

    public boolean bucketExists(String bucket) {
        return BUCKETS.containsKey(bucket);
    }

    public VersioningConfiguration getBucketVersioning(S3Context ctx, String bucket) {
        return S3MemoryImpl.bucket(ctx, bucket).getBucketVersioning(ctx);
    }

    public boolean putBucketVersioning(S3Context ctx, String bucket, VersioningConfiguration config) {
        return S3MemoryImpl.bucket(ctx, bucket).putBucketVersioning(ctx, config);
    }

    public User user(String accessKeyId) {
        User user = USERS.get(accessKeyId);
        if (user != null) {
            return user;
        }
        throw InvalidAuthException.noSuchAccessKey();
    }

    public Owner findOwner(String bucket) {
        IBucket ob = BUCKETS.get(bucket);
        if (ob != null) {
            return ob.owner();
        }
        throw NoSuchBucketException.noSuchBucket((String)bucket);
    }

    public void deleteUser(String accessKeyId) {
        USERS.remove(accessKeyId);
    }

    public User addUser(Owner owner, String accessKeyId, String secretKey) {
        User user = new User(accessKeyId, secretKey);
        USERS.put(accessKeyId, user);
        USER_OWNER_MAPPING.put(accessKeyId, owner.getId());
        return user;
    }

    public void deleteOwner(String id) {
        OWNERS.remove(id);
        USER_OWNER_MAPPING.remove(id);
    }

    public Owner addOwner(String displayName) {
        byte[] idBytes = new byte[15];
        S3Context.RANDOM.nextBytes(idBytes);
        String id = BaseEncoding.base32().encode(idBytes);
        Owner owner = new Owner(displayName, id);
        OWNERS.put(id, owner);
        return owner;
    }

    public Owner findOwner(User user) {
        Owner owner;
        String ownerId = USER_OWNER_MAPPING.get(user.accessKeyId());
        if (ownerId != null && (owner = OWNERS.get(ownerId)) != null) {
            return owner;
        }
        throw RequestFailedException.invalidRequest((String)"Unknown", (String)"No owner for the provided user");
    }

    public boolean headBucket(S3Context ctx, String bucket) {
        return BUCKETS.containsKey(bucket);
    }

    public boolean createBucket(S3Context ctx, String bucket, String location) {
        return BUCKETS.putIfAbsent(bucket, MemoryBucket.create(ctx.owner(), bucket, location)) == null;
    }

    public boolean deleteBucket(S3Context ctx, String bucket) {
        IBucket iBucket = BUCKETS.get(bucket);
        if (!iBucket.isEmpty()) {
            throw ConflictException.bucketNotEmpty((S3Context)ctx);
        }
        return BUCKETS.remove(bucket) != null;
    }

    public boolean isBucketPublic(String bucket) {
        return false;
    }

    public ListAllMyBucketsResult listBuckets(S3Context ctx) {
        List buckets = BUCKETS.values().stream().filter(ob -> ob.owner().getId().equals(ctx.owner().getId())).map(b -> new Bucket(b.name(), b.created())).collect(Collectors.toList());
        return new ListAllMyBucketsResult(buckets, ctx.owner());
    }

    public Optional<PublicAccessBlockConfiguration> internalPublicAccessBlock(String bucket) {
        IBucket iBucket = BUCKETS.get(bucket);
        if (iBucket != null) {
            return iBucket.internalPublicAccessBlock();
        }
        return Optional.empty();
    }

    public PublicAccessBlockConfiguration getPublicAccessBlock(S3Context ctx, String bucket) {
        return S3MemoryImpl.bucket(ctx, bucket).getPublicAccessBlock(ctx);
    }

    public boolean putPublicAccessBlock(S3Context ctx, String bucket, PublicAccessBlockConfiguration config) {
        return S3MemoryImpl.bucket(ctx, bucket).putPublicAccessBlock(ctx, config);
    }

    public boolean deletePublicAccessBlock(S3Context ctx, String bucket) {
        return S3MemoryImpl.bucket(ctx, bucket).deletePublicAccessBlock(ctx);
    }

    public GetObjectResult getObject(S3Context ctx, String bucket, String key, Optional<String> versionId) {
        return S3MemoryImpl.bucket(ctx, bucket).getObject(ctx, key, versionId);
    }

    public HeadObjectResult headObject(S3Context ctx, String bucket, String key, Optional<String> versionId) {
        return S3MemoryImpl.bucket(ctx, bucket).headObject(ctx, key, versionId);
    }

    public boolean deleteObject(S3Context ctx, String bucket, String key, Optional<String> versionId) {
        return S3MemoryImpl.bucket(ctx, bucket).deleteObject(ctx, key, versionId);
    }

    public DeleteResult deleteObjects(S3Context ctx, String bucket, DeleteObjectsRequest request) {
        return S3MemoryImpl.bucket(ctx, bucket).deleteObjects(ctx, request);
    }

    public PutObjectResult putObject(S3Context ctx, String bucket, String key, Optional<byte[]> inputMd5, int expectedLength, Optional<String> contentType, Map<String, String> metadata, InputStream data) {
        return S3MemoryImpl.bucket(ctx, bucket).putObject(ctx, key, inputMd5, expectedLength, contentType, metadata, data);
    }

    public CopyObjectResult copyObject(S3Context ctx, String srcName, String srcKey, String dstName, String dstKey, boolean copyMetadata, Map<String, String> newMetadata) {
        if (!BUCKETS.containsKey(srcName)) {
            throw NoSuchBucketException.noSuchBucket((S3Context)ctx);
        }
        if (!BUCKETS.containsKey(dstName)) {
            throw NoSuchBucketException.noSuchBucket((S3Context)ctx);
        }
        if (srcName.equals(dstName) && srcKey.equals(dstKey)) {
            throw RequestFailedException.invalidArgument((S3Context)ctx, (String)dstKey);
        }
        IBucket srcBucket = S3MemoryImpl.bucket(ctx, srcName);
        IBucket dstBucket = S3MemoryImpl.bucket(ctx, dstName);
        if (!ctx.owner().getId().equals(srcBucket.owner().getId())) {
            throw InvalidAuthException.incorrectOwner();
        }
        if (!ctx.owner().getId().equals(dstBucket.owner().getId())) {
            throw InvalidAuthException.incorrectOwner();
        }
        GetObjectResult getObject = srcBucket.getObject(ctx, srcKey, Optional.empty());
        try (InputStream stream = (InputStream)getObject.getData().get();){
            dstBucket.putObject(ctx, dstKey, Optional.empty(), getObject.length(), Optional.of(getObject.getContentType()), copyMetadata ? getObject.getMetadata() : newMetadata, stream);
        }
        catch (IOException e) {
            throw InternalErrorException.internalError((S3Context)ctx, (String)srcKey, (String)e.getLocalizedMessage());
        }
        return new CopyObjectResult(getObject.getEtag(), getObject.getModified());
    }

    public ListBucketResult listObjects(S3Context ctx, String bucket, Optional<String> delimiter, Optional<String> encodingType, Optional<String> marker, int maxKeys, Optional<String> prefix) {
        return S3MemoryImpl.bucket(ctx, bucket).listObjects(ctx, delimiter, encodingType, marker, maxKeys, prefix);
    }

    public ListVersionsResult listObjectVersions(S3Context ctx, String bucket, Optional<String> delimiter, Optional<String> encodingType, Optional<String> marker, Optional<String> versionIdMarker, int maxKeys, Optional<String> prefix) {
        return S3MemoryImpl.bucket(ctx, bucket).listObjectVersions(ctx, delimiter, encodingType, marker, versionIdMarker, maxKeys, prefix);
    }

    public ListBucketResultV2 listObjectsV2(S3Context ctx, String bucket, Optional<String> continuationToken, Optional<String> delimiter, Optional<String> encodingType, boolean fetchOwner, int maxKeys, Optional<String> prefix, Optional<String> startAfter) {
        return S3MemoryImpl.bucket(ctx, bucket).listObjectsV2(ctx, continuationToken, delimiter, encodingType, fetchOwner, maxKeys, prefix, startAfter);
    }

    static {
        USERS = new ConcurrentHashMap<String, User>();
        OWNERS = new ConcurrentHashMap<String, Owner>();
        USER_OWNER_MAPPING = new ConcurrentHashMap<String, String>();
        USER = new User("DEFAULT", "DEFAULT");
        OWNER = new Owner("DEFAULT", "DEFAULT");
        BUCKETS = new ConcurrentHashMap<String, IBucket>();
    }
}

