/*
 * Decompiled with CFR 0.152.
 */
package net.jolivier.s3api.memory;

import com.google.common.base.Strings;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.jolivier.s3api.auth.S3Context;
import net.jolivier.s3api.exception.InternalErrorException;
import net.jolivier.s3api.exception.NoSuchKeyException;
import net.jolivier.s3api.exception.RequestFailedException;
import net.jolivier.s3api.memory.IBucket;
import net.jolivier.s3api.model.DeleteError;
import net.jolivier.s3api.model.DeleteObjectsRequest;
import net.jolivier.s3api.model.DeleteResult;
import net.jolivier.s3api.model.Deleted;
import net.jolivier.s3api.model.GetObjectResult;
import net.jolivier.s3api.model.HeadObjectResult;
import net.jolivier.s3api.model.ListBucketResult;
import net.jolivier.s3api.model.ListObject;
import net.jolivier.s3api.model.ListVersionsResult;
import net.jolivier.s3api.model.ObjectIdentifier;
import net.jolivier.s3api.model.ObjectVersion;
import net.jolivier.s3api.model.Owner;
import net.jolivier.s3api.model.PublicAccessBlockConfiguration;
import net.jolivier.s3api.model.PutObjectResult;
import net.jolivier.s3api.model.VersioningConfiguration;

public class MemoryBucket
implements IBucket {
    private final ZonedDateTime _created = ZonedDateTime.now();
    private final Owner _owner;
    private final String _name;
    private final String _location;
    private PublicAccessBlockConfiguration _accessPolicy = PublicAccessBlockConfiguration.ALL_RESTRICTED;
    private VersioningConfiguration _versioning = VersioningConfiguration.disabled();
    private final Map<String, List<StoredObject>> _objects = new ConcurrentHashMap<String, List<StoredObject>>();

    public static final IBucket create(Owner owner, String name, String location) {
        return new MemoryBucket(Objects.requireNonNull(owner, "owner"), Objects.requireNonNull(name, "name"), Objects.requireNonNull(location, "location"), VersioningConfiguration.disabled());
    }

    public static final IBucket create(Owner owner, String name, String location, VersioningConfiguration config) {
        return new MemoryBucket(Objects.requireNonNull(owner, "owner"), Objects.requireNonNull(name, "name"), Objects.requireNonNull(location, "location"), Objects.requireNonNull(config, "versioning"));
    }

    private MemoryBucket(Owner owner, String name, String location, VersioningConfiguration config) {
        this._owner = owner;
        this._name = name;
        this._location = location;
        this._versioning = config;
    }

    @Override
    public Owner owner() {
        return this._owner;
    }

    @Override
    public String name() {
        return this._name;
    }

    @Override
    public String location() {
        return this._location;
    }

    @Override
    public ZonedDateTime created() {
        return this._created;
    }

    @Override
    public boolean isEmpty() {
        return this._objects.isEmpty();
    }

    @Override
    public VersioningConfiguration getBucketVersioning(S3Context ctx) {
        return this._versioning.copy();
    }

    @Override
    public boolean putBucketVersioning(S3Context ctx, VersioningConfiguration config) {
        if (this._versioning.isDisabled()) {
            throw RequestFailedException.invalidBucketState((S3Context)ctx);
        }
        this._versioning = config;
        return true;
    }

    @Override
    public Optional<PublicAccessBlockConfiguration> internalPublicAccessBlock() {
        return Optional.of(this._accessPolicy);
    }

    @Override
    public PublicAccessBlockConfiguration getPublicAccessBlock(S3Context ctx) {
        return this._accessPolicy;
    }

    @Override
    public boolean putPublicAccessBlock(S3Context ctx, PublicAccessBlockConfiguration config) {
        this._accessPolicy = config;
        return true;
    }

    @Override
    public boolean deletePublicAccessBlock(S3Context ctx) {
        this._accessPolicy = PublicAccessBlockConfiguration.ALL_RESTRICTED;
        return false;
    }

    @Override
    public GetObjectResult getObject(S3Context ctx, String key, Optional<String> versionId) {
        List<StoredObject> stored = this._objects.get(key);
        if (stored != null && !stored.isEmpty()) {
            StoredObject o = stored.get(stored.size() - 1);
            if (versionId.isPresent()) {
                o = stored.stream().filter(x -> x._versionId.isPresent() && x._versionId.get().equals(versionId.get())).findFirst().orElse(o);
                if (o._deleted) {
                    throw new NoSuchKeyException(ctx, key, true);
                }
            }
            return new GetObjectResult(o.contentType(), o.etag(), o.modified(), o.getMetadata(), (long)o.data().length, (InputStream)new ByteArrayInputStream(o.data()));
        }
        throw new NoSuchKeyException(ctx, key, false);
    }

    @Override
    public HeadObjectResult headObject(S3Context ctx, String key, Optional<String> versionId) {
        List<StoredObject> stored = this._objects.get(key);
        if (stored != null) {
            StoredObject o = stored.get(stored.size() - 1);
            if (versionId.isPresent()) {
                o = stored.stream().filter(x -> x._versionId.isPresent() && x._versionId.get().equals(versionId.get())).findFirst().orElse(o);
                if (o._deleted) {
                    throw new NoSuchKeyException(ctx, key, true);
                }
            }
            return new HeadObjectResult(o.contentType(), o.etag(), o.modified(), o.getMetadata());
        }
        throw new NoSuchKeyException(ctx, key, false);
    }

    @Override
    public boolean deleteObject(S3Context ctx, String key, Optional<String> versionId) {
        block4: {
            List<StoredObject> list;
            block6: {
                block5: {
                    list = this._objects.get(key);
                    if (list == null) break block4;
                    if (versionId.isPresent()) {
                        return list.stream().filter(so -> so._versionId.isPresent() && so._versionId.get().equals(versionId.get())).findFirst().map(list::remove).orElse(Boolean.FALSE);
                    }
                    if (this._versioning.isDisabled()) break block5;
                    if (!this._versioning.isSuspended()) break block6;
                }
                return list.stream().filter(so -> so._versionId.isEmpty()).findFirst().map(list::remove).orElse(Boolean.FALSE);
            }
            list.add(new StoredObject(this._versioning.isEnabled() ? Optional.of(S3Context.createVersionId()) : Optional.empty(), true, null, null, null, ZonedDateTime.now(), Collections.emptyMap()));
            return true;
        }
        return false;
    }

    @Override
    public DeleteResult deleteObjects(S3Context ctx, DeleteObjectsRequest request) {
        LinkedList<Deleted> deleted = new LinkedList<Deleted>();
        LinkedList<DeleteError> errors = new LinkedList<DeleteError>();
        for (ObjectIdentifier oi : request.getObjects()) {
            boolean result = this.deleteObject(ctx, oi.getKey(), Strings.isNullOrEmpty((String)oi.getVersionId()) ? Optional.empty() : Optional.of(oi.getVersionId()));
            if (result) {
                deleted.add(new Deleted(oi.getKey()));
                continue;
            }
            errors.add(new DeleteError("NoSuchKey", oi.getKey(), "The specified key does not exist", null));
        }
        return new DeleteResult(deleted, errors);
    }

    @Override
    public PutObjectResult putObject(S3Context ctx, String key, Optional<byte[]> inputMd5, long expectedLength, Optional<String> contentType, Map<String, String> metadata, InputStream data) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            data.transferTo(baos);
            byte[] bytes = baos.toByteArray();
            if ((long)bytes.length != expectedLength) {
                // empty if block
            }
            Optional<String> versionId = Optional.empty();
            if (this._versioning.isEnabled()) {
                versionId = Optional.of(S3Context.createVersionId());
            }
            byte[] calculatedMd5 = Hashing.md5().hashBytes(bytes).asBytes();
            if (inputMd5.isPresent() && !Arrays.equals(calculatedMd5, inputMd5.get())) {
                throw RequestFailedException.badDigest((String)key);
            }
            String etag = BaseEncoding.base16().encode(calculatedMd5);
            StoredObject meta = new StoredObject(versionId, false, bytes, contentType.orElse("application/octet-stream"), etag, ZonedDateTime.now(), metadata);
            this._objects.computeIfAbsent(key, k -> new ArrayList()).add(meta);
            return new PutObjectResult(meta.etag(), Optional.empty());
        }
        catch (IOException e) {
            throw InternalErrorException.internalError((S3Context)ctx, (String)key, (String)e.getLocalizedMessage());
        }
    }

    @Override
    public ListBucketResult listObjects(S3Context ctx, Optional<String> delimiter, Optional<String> encodingType, Optional<String> marker, int maxKeys, Optional<String> prefix) {
        int endIndex;
        ArrayList<String> keys = new ArrayList<String>(prefix.isPresent() ? (Collection)this._objects.keySet().stream().filter(k -> k.startsWith((String)prefix.get())).collect(Collectors.toList()) : this._objects.keySet());
        keys.sort(Comparator.naturalOrder());
        int startIndex = 0;
        if (marker.isPresent()) {
            int idx = keys.indexOf(marker.get());
            if (idx >= 0) {
                startIndex = idx + 1;
            } else {
                return new ListBucketResult(false, (String)marker.orElse(null), null, this._name, (String)prefix.orElse(null), (String)delimiter.orElse(null), maxKeys, (String)encodingType.orElse(null), new ArrayList(), Collections.emptyList());
            }
        }
        if (startIndex == (endIndex = Math.min(startIndex + maxKeys, keys.size()))) {
            throw RequestFailedException.invalidArgument((S3Context)ctx, (String)("Invalid key marker " + marker.orElse("NA")));
        }
        boolean truncated = false;
        ArrayList<ListObject> list = new ArrayList<ListObject>(keys.size());
        HashSet commonPrefixes = new HashSet();
        for (int i = startIndex; list.size() < maxKeys && i < endIndex; ++i) {
            String key = (String)keys.get(i);
            List<StoredObject> versions = this._objects.get(key);
            if (versions.isEmpty()) continue;
            StoredObject metadata = versions.get(versions.size() - 1);
            list.add(new ListObject(metadata.etag(), key, metadata.modified(), this._owner, (long)metadata.data().length));
        }
        String nextMarker = null;
        if (endIndex < keys.size()) {
            nextMarker = (String)keys.get(endIndex);
            truncated = true;
        }
        ListBucketResult result = new ListBucketResult(truncated, (String)marker.orElse(null), nextMarker, this._name, (String)prefix.orElse(null), (String)delimiter.orElse(null), maxKeys, (String)encodingType.orElse(null), new ArrayList(commonPrefixes), list);
        return result;
    }

    @Override
    public ListVersionsResult listObjectVersions(S3Context ctx, Optional<String> delimiter, Optional<String> encodingType, Optional<String> marker, Optional<String> versionIdMarker, int maxKeys, Optional<String> prefix) {
        int idx;
        ArrayList<String> keys = new ArrayList<String>(prefix.isPresent() ? (Collection)this._objects.keySet().stream().filter(k -> k.startsWith((String)prefix.get())).collect(Collectors.toList()) : this._objects.keySet());
        keys.sort(Comparator.naturalOrder());
        int startIndex = 0;
        if (marker.isPresent() && (idx = keys.indexOf(marker.get())) >= 0) {
            startIndex = idx;
        }
        int endIndex = Math.min(maxKeys, keys.size());
        Optional<Object> nextVersionIdMarker = Optional.empty();
        int count = 0;
        ArrayList<ObjectVersion> list = new ArrayList<ObjectVersion>(keys.size());
        block0: for (int i = startIndex; i < endIndex; ++i) {
            String key = (String)keys.get(i);
            List<StoredObject> versions = this._objects.get(key);
            for (int j = 0; j < versions.size(); ++j) {
                StoredObject version = versions.get(j);
                boolean latest = j == versions.size() - 1;
                list.add(new ObjectVersion(this._owner, key, this._name, latest, version.modified(), version.etag(), Long.valueOf(version.data().length), "STANDARD"));
                if (++count < maxKeys) continue;
                if (!latest) {
                    nextVersionIdMarker = versions.get((int)(j + 1))._versionId;
                }
                i = endIndex;
                continue block0;
            }
        }
        boolean truncated = list.size() >= maxKeys;
        String nextMarker = null;
        if (truncated) {
            nextMarker = (String)keys.get(endIndex);
        }
        return new ListVersionsResult(truncated, (String)marker.orElse(null), nextMarker, this._name, (String)prefix.orElse(null), (String)delimiter.orElse(null), (String)encodingType.orElse(null), (String)nextVersionIdMarker.orElse(null), maxKeys, (List)prefix.map(Collections::singletonList).orElse(null), list);
    }

    private static final class StoredObject {
        private final Optional<String> _versionId;
        private boolean _deleted;
        private final byte[] _data;
        private final String _contentType;
        private final String _etag;
        private final ZonedDateTime _modified;
        private final Map<String, String> _metadata;

        public StoredObject(Optional<String> versionId, boolean deleted, byte[] data, String contentType, String etag, ZonedDateTime modified, Map<String, String> metadata) {
            this._versionId = versionId;
            this._deleted = deleted;
            this._data = data;
            this._contentType = contentType;
            this._etag = etag;
            this._modified = modified;
            this._metadata = metadata;
        }

        public byte[] data() {
            return this._data;
        }

        public String contentType() {
            return this._contentType;
        }

        public String etag() {
            return this._etag;
        }

        public ZonedDateTime modified() {
            return this._modified;
        }

        public Map<String, String> getMetadata() {
            return this._metadata;
        }
    }
}

