/*
 * Decompiled with CFR 0.152.
 */
package net.joelinn.quartz.jobstore;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.joelinn.quartz.jobstore.AbstractRedisStorage;
import net.joelinn.quartz.jobstore.RedisJobStoreSchema;
import net.joelinn.quartz.jobstore.RedisTriggerState;
import org.quartz.Calendar;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobPersistenceException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.impl.matchers.StringMatcher;
import org.quartz.spi.OperableTrigger;
import org.quartz.spi.SchedulerSignaler;
import org.quartz.spi.TriggerFiredBundle;
import org.quartz.spi.TriggerFiredResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisCluster;

public class RedisClusterStorage
extends AbstractRedisStorage<JedisCluster> {
    private static final Logger logger = LoggerFactory.getLogger(RedisClusterStorage.class);

    public RedisClusterStorage(RedisJobStoreSchema redisSchema, ObjectMapper mapper, SchedulerSignaler signaler, String schedulerInstanceId, int lockTimeout) {
        super(redisSchema, mapper, signaler, schedulerInstanceId, lockTimeout);
    }

    @Override
    public void storeJob(JobDetail jobDetail, boolean replaceExisting, JedisCluster jedis) throws ObjectAlreadyExistsException {
        String jobHashKey = this.redisSchema.jobHashKey(jobDetail.getKey());
        String jobDataMapHashKey = this.redisSchema.jobDataMapHashKey(jobDetail.getKey());
        String jobGroupSetKey = this.redisSchema.jobGroupSetKey(jobDetail.getKey());
        if (!replaceExisting && jedis.exists(jobHashKey).booleanValue()) {
            throw new ObjectAlreadyExistsException(jobDetail);
        }
        jedis.hmset(jobHashKey, (Map)this.mapper.convertValue((Object)jobDetail, (TypeReference)new TypeReference<HashMap<String, String>>(){}));
        if (jobDetail.getJobDataMap() != null && !jobDetail.getJobDataMap().isEmpty()) {
            jedis.hmset(jobDataMapHashKey, this.getStringDataMap(jobDetail.getJobDataMap()));
        }
        jedis.sadd(this.redisSchema.jobsSet(), new String[]{jobHashKey});
        jedis.sadd(this.redisSchema.jobGroupsSet(), new String[]{jobGroupSetKey});
        jedis.sadd(jobGroupSetKey, new String[]{jobHashKey});
    }

    @Override
    public boolean removeJob(JobKey jobKey, JedisCluster jedis) throws JobPersistenceException {
        String jobHashKey = this.redisSchema.jobHashKey(jobKey);
        String jobDataMapHashKey = this.redisSchema.jobDataMapHashKey(jobKey);
        String jobGroupSetKey = this.redisSchema.jobGroupSetKey(jobKey);
        String jobTriggerSetKey = this.redisSchema.jobTriggersSetKey(jobKey);
        Long delJobHashKeyResponse = jedis.del(jobHashKey);
        jedis.del(jobDataMapHashKey);
        jedis.srem(this.redisSchema.jobsSet(), new String[]{jobHashKey});
        jedis.srem(jobGroupSetKey, new String[]{jobHashKey});
        Set jobTriggerSetResponse = jedis.smembers(jobTriggerSetKey);
        jedis.del(jobTriggerSetKey);
        Long jobGroupSetSizeResponse = jedis.scard(jobGroupSetKey);
        if (jobGroupSetSizeResponse == 0L) {
            jedis.srem(this.redisSchema.jobGroupsSet(), new String[]{jobGroupSetKey});
        }
        for (String triggerHashKey : jobTriggerSetResponse) {
            TriggerKey triggerKey = this.redisSchema.triggerKey(triggerHashKey);
            String triggerGroupSetKey = this.redisSchema.triggerGroupSetKey(triggerKey);
            this.unsetTriggerState(triggerHashKey, jedis);
            jedis.srem(this.redisSchema.triggersSet(), new String[]{triggerHashKey});
            jedis.srem(this.redisSchema.triggerGroupsSet(), new String[]{triggerGroupSetKey});
            jedis.srem(triggerGroupSetKey, new String[]{triggerHashKey});
            jedis.del(triggerHashKey);
        }
        return delJobHashKeyResponse == 1L;
    }

    @Override
    public void storeTrigger(OperableTrigger trigger, boolean replaceExisting, JedisCluster jedis) throws JobPersistenceException {
        String triggerHashKey = this.redisSchema.triggerHashKey(trigger.getKey());
        String triggerGroupSetKey = this.redisSchema.triggerGroupSetKey(trigger.getKey());
        String jobTriggerSetKey = this.redisSchema.jobTriggersSetKey(trigger.getJobKey());
        if (!(trigger instanceof SimpleTrigger) && !(trigger instanceof CronTrigger)) {
            throw new UnsupportedOperationException("Only SimpleTrigger and CronTrigger are supported.");
        }
        boolean exists = jedis.exists(triggerHashKey);
        if (exists && !replaceExisting) {
            throw new ObjectAlreadyExistsException((Trigger)trigger);
        }
        Map triggerMap = (Map)this.mapper.convertValue((Object)trigger, (TypeReference)new TypeReference<HashMap<String, String>>(){});
        triggerMap.put("trigger_class", trigger.getClass().getName());
        jedis.hmset(triggerHashKey, triggerMap);
        jedis.sadd(this.redisSchema.triggersSet(), new String[]{triggerHashKey});
        jedis.sadd(this.redisSchema.triggerGroupsSet(), new String[]{triggerGroupSetKey});
        jedis.sadd(triggerGroupSetKey, new String[]{triggerHashKey});
        jedis.sadd(jobTriggerSetKey, new String[]{triggerHashKey});
        if (trigger.getCalendarName() != null && !trigger.getCalendarName().isEmpty()) {
            String calendarTriggersSetKey = this.redisSchema.calendarTriggersSetKey(trigger.getCalendarName());
            jedis.sadd(calendarTriggersSetKey, new String[]{triggerHashKey});
        }
        if (trigger.getJobDataMap() != null && !trigger.getJobDataMap().isEmpty()) {
            String triggerDataMapHashKey = this.redisSchema.triggerDataMapHashKey(trigger.getKey());
            jedis.hmset(triggerDataMapHashKey, this.getStringDataMap(trigger.getJobDataMap()));
        }
        if (exists) {
            this.unsetTriggerState(triggerHashKey, jedis);
        }
        Boolean triggerPausedResponse = jedis.sismember(this.redisSchema.pausedTriggerGroupsSet(), triggerGroupSetKey);
        Boolean jobPausedResponse = jedis.sismember(this.redisSchema.pausedJobGroupsSet(), this.redisSchema.jobGroupSetKey(trigger.getJobKey()));
        if (triggerPausedResponse.booleanValue() || jobPausedResponse.booleanValue()) {
            long nextFireTime = trigger.getNextFireTime() != null ? trigger.getNextFireTime().getTime() : -1L;
            String jobHashKey = this.redisSchema.jobHashKey(trigger.getJobKey());
            if (jedis.sismember(this.redisSchema.blockedJobsSet(), jobHashKey).booleanValue()) {
                this.setTriggerState(RedisTriggerState.PAUSED_BLOCKED, nextFireTime, triggerHashKey, jedis);
            } else {
                this.setTriggerState(RedisTriggerState.PAUSED, nextFireTime, triggerHashKey, jedis);
            }
        } else if (trigger.getNextFireTime() != null) {
            this.setTriggerState(RedisTriggerState.WAITING, trigger.getNextFireTime().getTime(), triggerHashKey, jedis);
        }
    }

    @Override
    protected boolean removeTrigger(TriggerKey triggerKey, boolean removeNonDurableJob, JedisCluster jedis) throws JobPersistenceException, ClassNotFoundException {
        String triggerHashKey = this.redisSchema.triggerHashKey(triggerKey);
        String triggerGroupSetKey = this.redisSchema.triggerGroupSetKey(triggerKey);
        if (!jedis.exists(triggerHashKey).booleanValue()) {
            return false;
        }
        OperableTrigger trigger = this.retrieveTrigger(triggerKey, jedis);
        String jobHashKey = this.redisSchema.jobHashKey(trigger.getJobKey());
        String jobTriggerSetKey = this.redisSchema.jobTriggersSetKey(trigger.getJobKey());
        jedis.srem(this.redisSchema.triggersSet(), new String[]{triggerHashKey});
        jedis.srem(triggerGroupSetKey, new String[]{triggerHashKey});
        jedis.srem(jobTriggerSetKey, new String[]{triggerHashKey});
        if (jedis.scard(triggerGroupSetKey) == 0L) {
            jedis.srem(this.redisSchema.triggerGroupsSet(), new String[]{triggerGroupSetKey});
        }
        if (removeNonDurableJob) {
            JobDetail job;
            Long jobTriggerSetKeySizeResponse = jedis.scard(jobTriggerSetKey);
            Boolean jobExistsResponse = jedis.exists(jobHashKey);
            if (jobTriggerSetKeySizeResponse == 0L && jobExistsResponse.booleanValue() && !(job = this.retrieveJob(trigger.getJobKey(), jedis)).isDurable()) {
                this.removeJob(job.getKey(), jedis);
                this.signaler.notifySchedulerListenersJobDeleted(job.getKey());
            }
        }
        if (this.isNullOrEmpty(trigger.getCalendarName())) {
            jedis.srem(this.redisSchema.calendarTriggersSetKey(trigger.getCalendarName()), new String[]{triggerHashKey});
        }
        this.unsetTriggerState(triggerHashKey, jedis);
        jedis.del(triggerHashKey);
        return true;
    }

    @Override
    public boolean unsetTriggerState(String triggerHashKey, JedisCluster jedis) throws JobPersistenceException {
        boolean removed = false;
        ArrayList<Long> responses = new ArrayList<Long>(RedisTriggerState.values().length);
        for (RedisTriggerState state : RedisTriggerState.values()) {
            responses.add(jedis.zrem(this.redisSchema.triggerStateKey(state), new String[]{triggerHashKey}));
        }
        for (Long response : responses) {
            removed = response == 1L;
            if (!removed) continue;
            jedis.del(this.redisSchema.triggerLockKey(this.redisSchema.triggerKey(triggerHashKey)));
            break;
        }
        return removed;
    }

    @Override
    public void storeCalendar(String name, Calendar calendar, boolean replaceExisting, boolean updateTriggers, JedisCluster jedis) throws JobPersistenceException {
        String calendarHashKey = this.redisSchema.calendarHashKey(name);
        if (!replaceExisting && jedis.exists(calendarHashKey).booleanValue()) {
            throw new ObjectAlreadyExistsException(String.format("Calendar with key %s already exists.", calendarHashKey));
        }
        HashMap<String, String> calendarMap = new HashMap<String, String>();
        calendarMap.put("calendar_class", calendar.getClass().getName());
        try {
            calendarMap.put("calendar_json", this.mapper.writeValueAsString((Object)calendar));
        }
        catch (JsonProcessingException e) {
            throw new JobPersistenceException("Unable to serialize calendar.", (Throwable)e);
        }
        jedis.hmset(calendarHashKey, calendarMap);
        jedis.sadd(this.redisSchema.calendarsSet(), new String[]{calendarHashKey});
        if (updateTriggers) {
            String calendarTriggersSetKey = this.redisSchema.calendarTriggersSetKey(name);
            Set triggerHashKeys = jedis.smembers(calendarTriggersSetKey);
            for (String triggerHashKey : triggerHashKeys) {
                OperableTrigger trigger = this.retrieveTrigger(this.redisSchema.triggerKey(triggerHashKey), jedis);
                long removed = jedis.zrem(this.redisSchema.triggerStateKey(RedisTriggerState.WAITING), new String[]{triggerHashKey});
                trigger.updateWithNewCalendar(calendar, (long)this.misfireThreshold);
                if (removed != 1L) continue;
                this.setTriggerState(RedisTriggerState.WAITING, trigger.getNextFireTime().getTime(), triggerHashKey, jedis);
            }
        }
    }

    @Override
    public boolean removeCalendar(String calendarName, JedisCluster jedis) throws JobPersistenceException {
        String calendarTriggersSetKey = this.redisSchema.calendarTriggersSetKey(calendarName);
        if (jedis.scard(calendarTriggersSetKey) > 0L) {
            throw new JobPersistenceException(String.format("There are triggers pointing to calendar %s, so it cannot be removed.", calendarName));
        }
        String calendarHashKey = this.redisSchema.calendarHashKey(calendarName);
        Long deleteResponse = jedis.del(calendarHashKey);
        jedis.srem(this.redisSchema.calendarsSet(), new String[]{calendarHashKey});
        return deleteResponse == 1L;
    }

    @Override
    public Set<JobKey> getJobKeys(GroupMatcher<JobKey> matcher, JedisCluster jedis) {
        HashSet<JobKey> jobKeys;
        block5: {
            block4: {
                jobKeys = new HashSet<JobKey>();
                if (matcher.getCompareWithOperator() != StringMatcher.StringOperatorName.EQUALS) break block4;
                String jobGroupSetKey = this.redisSchema.jobGroupSetKey(new JobKey("", matcher.getCompareToValue()));
                Set jobs = jedis.smembers(jobGroupSetKey);
                if (jobs == null) break block5;
                for (String job : jobs) {
                    jobKeys.add(this.redisSchema.jobKey(job));
                }
                break block5;
            }
            ArrayList<Set> jobGroups = new ArrayList<Set>();
            for (String jobGroupSetKey : jedis.smembers(this.redisSchema.jobGroupsSet())) {
                if (!matcher.getCompareWithOperator().evaluate(this.redisSchema.jobGroup(jobGroupSetKey), matcher.getCompareToValue())) continue;
                jobGroups.add(jedis.smembers(jobGroupSetKey));
            }
            for (Set jobGroup : jobGroups) {
                if (jobGroup == null) continue;
                for (String job : jobGroup) {
                    jobKeys.add(this.redisSchema.jobKey(job));
                }
            }
        }
        return jobKeys;
    }

    @Override
    public Set<TriggerKey> getTriggerKeys(GroupMatcher<TriggerKey> matcher, JedisCluster jedis) {
        HashSet<TriggerKey> triggerKeys;
        block5: {
            block4: {
                triggerKeys = new HashSet<TriggerKey>();
                if (matcher.getCompareWithOperator() != StringMatcher.StringOperatorName.EQUALS) break block4;
                String triggerGroupSetKey = this.redisSchema.triggerGroupSetKey(new TriggerKey("", matcher.getCompareToValue()));
                Set triggers = jedis.smembers(triggerGroupSetKey);
                if (triggers == null) break block5;
                for (String trigger : triggers) {
                    triggerKeys.add(this.redisSchema.triggerKey(trigger));
                }
                break block5;
            }
            ArrayList<Set> triggerGroups = new ArrayList<Set>();
            for (String triggerGroupSetKey : jedis.smembers(this.redisSchema.triggerGroupsSet())) {
                if (!matcher.getCompareWithOperator().evaluate(this.redisSchema.triggerGroup(triggerGroupSetKey), matcher.getCompareToValue())) continue;
                triggerGroups.add(jedis.smembers(triggerGroupSetKey));
            }
            for (Set triggerGroup : triggerGroups) {
                if (triggerGroup == null) continue;
                for (String trigger : triggerGroup) {
                    triggerKeys.add(this.redisSchema.triggerKey(trigger));
                }
            }
        }
        return triggerKeys;
    }

    @Override
    public Trigger.TriggerState getTriggerState(TriggerKey triggerKey, JedisCluster jedis) {
        String triggerHashKey = this.redisSchema.triggerHashKey(triggerKey);
        HashMap<RedisTriggerState, Double> scores = new HashMap<RedisTriggerState, Double>(RedisTriggerState.values().length);
        for (RedisTriggerState redisTriggerState : RedisTriggerState.values()) {
            scores.put(redisTriggerState, jedis.zscore(this.redisSchema.triggerStateKey(redisTriggerState), triggerHashKey));
        }
        for (Map.Entry entry : scores.entrySet()) {
            if (entry.getValue() == null) continue;
            return ((RedisTriggerState)((Object)entry.getKey())).getTriggerState();
        }
        return Trigger.TriggerState.NONE;
    }

    @Override
    public void pauseTrigger(TriggerKey triggerKey, JedisCluster jedis) throws JobPersistenceException {
        long nextFireTime;
        String triggerHashKey = this.redisSchema.triggerHashKey(triggerKey);
        Boolean exists = jedis.exists(triggerHashKey);
        Double completedScore = jedis.zscore(this.redisSchema.triggerStateKey(RedisTriggerState.COMPLETED), triggerHashKey);
        String nextFireTimeResponse = jedis.hget(triggerHashKey, "nextFireTime");
        Double blockedScore = jedis.zscore(this.redisSchema.triggerStateKey(RedisTriggerState.BLOCKED), triggerHashKey);
        if (!exists.booleanValue()) {
            return;
        }
        if (completedScore != null) {
            return;
        }
        long l = nextFireTime = nextFireTimeResponse == null || nextFireTimeResponse.isEmpty() ? -1L : Long.parseLong(nextFireTimeResponse);
        if (blockedScore != null) {
            this.setTriggerState(RedisTriggerState.PAUSED_BLOCKED, nextFireTime, triggerHashKey, jedis);
        } else {
            this.setTriggerState(RedisTriggerState.PAUSED, nextFireTime, triggerHashKey, jedis);
        }
    }

    @Override
    public Collection<String> pauseTriggers(GroupMatcher<TriggerKey> matcher, JedisCluster jedis) throws JobPersistenceException {
        HashSet<String> pausedTriggerGroups = new HashSet<String>();
        if (matcher.getCompareWithOperator() == StringMatcher.StringOperatorName.EQUALS) {
            String triggerGroupSetKey = this.redisSchema.triggerGroupSetKey(new TriggerKey("", matcher.getCompareToValue()));
            long addResult = jedis.sadd(this.redisSchema.pausedTriggerGroupsSet(), new String[]{triggerGroupSetKey});
            if (addResult > 0L) {
                for (String trigger : jedis.smembers(triggerGroupSetKey)) {
                    this.pauseTrigger(this.redisSchema.triggerKey(trigger), jedis);
                }
                pausedTriggerGroups.add(this.redisSchema.triggerGroup(triggerGroupSetKey));
            }
        } else {
            HashMap<String, Set> triggerGroups = new HashMap<String, Set>();
            for (String string : jedis.smembers(this.redisSchema.triggerGroupsSet())) {
                if (!matcher.getCompareWithOperator().evaluate(this.redisSchema.triggerGroup(string), matcher.getCompareToValue())) continue;
                triggerGroups.put(string, jedis.smembers(string));
            }
            for (Map.Entry entry : triggerGroups.entrySet()) {
                if (jedis.sadd(this.redisSchema.pausedJobGroupsSet(), new String[]{(String)entry.getKey()}) <= 0L) continue;
                pausedTriggerGroups.add(this.redisSchema.triggerGroup((String)entry.getKey()));
                for (String triggerHashKey : (Set)entry.getValue()) {
                    this.pauseTrigger(this.redisSchema.triggerKey(triggerHashKey), jedis);
                }
            }
        }
        return pausedTriggerGroups;
    }

    @Override
    public Collection<String> pauseJobs(GroupMatcher<JobKey> groupMatcher, JedisCluster jedis) throws JobPersistenceException {
        HashSet<String> pausedJobGroups;
        block5: {
            block4: {
                pausedJobGroups = new HashSet<String>();
                if (groupMatcher.getCompareWithOperator() != StringMatcher.StringOperatorName.EQUALS) break block4;
                String jobGroupSetKey = this.redisSchema.jobGroupSetKey(new JobKey("", groupMatcher.getCompareToValue()));
                if (jedis.sadd(this.redisSchema.pausedJobGroupsSet(), new String[]{jobGroupSetKey}) <= 0L) break block5;
                pausedJobGroups.add(this.redisSchema.jobGroup(jobGroupSetKey));
                for (String string : jedis.smembers(jobGroupSetKey)) {
                    this.pauseJob(this.redisSchema.jobKey(string), jedis);
                }
                break block5;
            }
            HashMap<String, Set> jobGroups = new HashMap<String, Set>();
            for (String string : jedis.smembers(this.redisSchema.jobGroupsSet())) {
                if (!groupMatcher.getCompareWithOperator().evaluate(this.redisSchema.jobGroup(string), groupMatcher.getCompareToValue())) continue;
                jobGroups.put(string, jedis.smembers(string));
            }
            for (Map.Entry entry : jobGroups.entrySet()) {
                if (jedis.sadd(this.redisSchema.pausedJobGroupsSet(), new String[]{(String)entry.getKey()}) <= 0L) continue;
                pausedJobGroups.add(this.redisSchema.jobGroup((String)entry.getKey()));
                for (String jobHashKey : (Set)entry.getValue()) {
                    this.pauseJob(this.redisSchema.jobKey(jobHashKey), jedis);
                }
            }
        }
        return pausedJobGroups;
    }

    @Override
    public void resumeTrigger(TriggerKey triggerKey, JedisCluster jedis) throws JobPersistenceException {
        String triggerHashKey = this.redisSchema.triggerHashKey(triggerKey);
        Boolean exists = jedis.sismember(this.redisSchema.triggersSet(), triggerHashKey);
        Double isPaused = jedis.zscore(this.redisSchema.triggerStateKey(RedisTriggerState.PAUSED), triggerHashKey);
        Double isPausedBlocked = jedis.zscore(this.redisSchema.triggerStateKey(RedisTriggerState.PAUSED_BLOCKED), triggerHashKey);
        if (!exists.booleanValue()) {
            return;
        }
        if (isPaused == null && isPausedBlocked == null) {
            return;
        }
        OperableTrigger trigger = this.retrieveTrigger(triggerKey, jedis);
        String jobHashKey = this.redisSchema.jobHashKey(trigger.getJobKey());
        Date nextFireTime = trigger.getNextFireTime();
        if (nextFireTime != null) {
            if (jedis.sismember(this.redisSchema.blockedJobsSet(), jobHashKey).booleanValue()) {
                this.setTriggerState(RedisTriggerState.BLOCKED, nextFireTime.getTime(), triggerHashKey, jedis);
            } else {
                this.setTriggerState(RedisTriggerState.WAITING, nextFireTime.getTime(), triggerHashKey, jedis);
            }
        }
        this.applyMisfire(trigger, jedis);
    }

    @Override
    public Collection<String> resumeTriggers(GroupMatcher<TriggerKey> matcher, JedisCluster jedis) throws JobPersistenceException {
        HashSet<String> resumedTriggerGroups = new HashSet<String>();
        if (matcher.getCompareWithOperator() == StringMatcher.StringOperatorName.EQUALS) {
            String triggerGroupSetKey = this.redisSchema.triggerGroupSetKey(new TriggerKey("", matcher.getCompareToValue()));
            jedis.srem(this.redisSchema.pausedJobGroupsSet(), new String[]{triggerGroupSetKey});
            Set triggerHashKeysResponse = jedis.smembers(triggerGroupSetKey);
            for (String triggerHashKey : triggerHashKeysResponse) {
                OperableTrigger trigger = this.retrieveTrigger(this.redisSchema.triggerKey(triggerHashKey), jedis);
                this.resumeTrigger(trigger.getKey(), jedis);
                resumedTriggerGroups.add(trigger.getKey().getGroup());
            }
        } else {
            for (String triggerGroupSetKey : jedis.smembers(this.redisSchema.triggerGroupsSet())) {
                if (!matcher.getCompareWithOperator().evaluate(this.redisSchema.triggerGroup(triggerGroupSetKey), matcher.getCompareToValue())) continue;
                resumedTriggerGroups.addAll(this.resumeTriggers((GroupMatcher<TriggerKey>)GroupMatcher.triggerGroupEquals((String)this.redisSchema.triggerGroup(triggerGroupSetKey)), jedis));
            }
        }
        return resumedTriggerGroups;
    }

    @Override
    public Collection<String> resumeJobs(GroupMatcher<JobKey> matcher, JedisCluster jedis) throws JobPersistenceException {
        HashSet<String> resumedJobGroups = new HashSet<String>();
        if (matcher.getCompareWithOperator() == StringMatcher.StringOperatorName.EQUALS) {
            String jobGroupSetKey = this.redisSchema.jobGroupSetKey(new JobKey("", matcher.getCompareToValue()));
            Long unpauseResponse = jedis.srem(this.redisSchema.pausedJobGroupsSet(), new String[]{jobGroupSetKey});
            Set jobsResponse = jedis.smembers(jobGroupSetKey);
            if (unpauseResponse > 0L) {
                resumedJobGroups.add(this.redisSchema.jobGroup(jobGroupSetKey));
            }
            for (String job : jobsResponse) {
                this.resumeJob(this.redisSchema.jobKey(job), jedis);
            }
        } else {
            for (String jobGroupSetKey : jedis.smembers(this.redisSchema.jobGroupsSet())) {
                if (!matcher.getCompareWithOperator().evaluate(this.redisSchema.jobGroup(jobGroupSetKey), matcher.getCompareToValue())) continue;
                resumedJobGroups.addAll(this.resumeJobs((GroupMatcher<JobKey>)GroupMatcher.jobGroupEquals((String)this.redisSchema.jobGroup(jobGroupSetKey)), jedis));
            }
        }
        return resumedJobGroups;
    }

    @Override
    public List<TriggerFiredResult> triggersFired(List<OperableTrigger> triggers, JedisCluster jedis) throws JobPersistenceException, ClassNotFoundException {
        ArrayList<TriggerFiredResult> results = new ArrayList<TriggerFiredResult>();
        for (OperableTrigger trigger : triggers) {
            String triggerHashKey = this.redisSchema.triggerHashKey(trigger.getKey());
            logger.debug(String.format("Trigger %s fired.", triggerHashKey));
            Boolean triggerExistsResponse = jedis.exists(triggerHashKey);
            Double triggerAcquiredResponse = jedis.zscore(this.redisSchema.triggerStateKey(RedisTriggerState.ACQUIRED), triggerHashKey);
            if (!triggerExistsResponse.booleanValue() || triggerAcquiredResponse == null) {
                if (!triggerExistsResponse.booleanValue()) {
                    logger.debug(String.format("Trigger %s does not exist.", triggerHashKey));
                    continue;
                }
                logger.debug(String.format("Trigger %s was not acquired.", triggerHashKey));
                continue;
            }
            Calendar calendar = null;
            String calendarName = trigger.getCalendarName();
            if (calendarName != null && (calendar = this.retrieveCalendar(calendarName, jedis)) == null) continue;
            Date previousFireTime = trigger.getPreviousFireTime();
            trigger.triggered(calendar);
            JobDetail job = this.retrieveJob(trigger.getJobKey(), jedis);
            TriggerFiredBundle triggerFiredBundle = new TriggerFiredBundle(job, trigger, calendar, false, new Date(), previousFireTime, previousFireTime, trigger.getNextFireTime());
            if (this.isJobConcurrentExecutionDisallowed(job.getJobClass())) {
                String jobHashKey = this.redisSchema.jobHashKey(trigger.getJobKey());
                String jobTriggerSetKey = this.redisSchema.jobTriggersSetKey(job.getKey());
                for (String nonConcurrentTriggerHashKey : jedis.smembers(jobTriggerSetKey)) {
                    Double score = jedis.zscore(this.redisSchema.triggerStateKey(RedisTriggerState.WAITING), nonConcurrentTriggerHashKey);
                    if (score != null) {
                        this.setTriggerState(RedisTriggerState.BLOCKED, score, nonConcurrentTriggerHashKey, jedis);
                        continue;
                    }
                    score = jedis.zscore(this.redisSchema.triggerStateKey(RedisTriggerState.PAUSED), nonConcurrentTriggerHashKey);
                    if (score == null) continue;
                    this.setTriggerState(RedisTriggerState.PAUSED_BLOCKED, score, nonConcurrentTriggerHashKey, jedis);
                }
                jedis.set(this.redisSchema.jobBlockedKey(job.getKey()), this.schedulerInstanceId);
                jedis.sadd(this.redisSchema.blockedJobsSet(), new String[]{jobHashKey});
            }
            if (trigger.getNextFireTime() != null) {
                long nextFireTime = trigger.getNextFireTime().getTime();
                jedis.hset(triggerHashKey, "nextFireTime", Long.toString(nextFireTime));
                logger.debug(String.format("Releasing trigger %s with next fire time %s. Setting state to WAITING.", triggerHashKey, nextFireTime));
                this.setTriggerState(RedisTriggerState.WAITING, nextFireTime, triggerHashKey, jedis);
            } else {
                jedis.hset(triggerHashKey, "nextFireTime", "");
                this.unsetTriggerState(triggerHashKey, jedis);
            }
            results.add(new TriggerFiredResult(triggerFiredBundle));
        }
        return results;
    }

    @Override
    public void triggeredJobComplete(OperableTrigger trigger, JobDetail jobDetail, Trigger.CompletedExecutionInstruction triggerInstCode, JedisCluster jedis) throws JobPersistenceException, ClassNotFoundException {
        String jobTriggersSetKey;
        String jobHashKey = this.redisSchema.jobHashKey(jobDetail.getKey());
        String jobDataMapHashKey = this.redisSchema.jobDataMapHashKey(jobDetail.getKey());
        String triggerHashKey = this.redisSchema.triggerHashKey(trigger.getKey());
        logger.debug(String.format("Job %s completed.", jobHashKey));
        if (jedis.exists(jobHashKey).booleanValue()) {
            if (this.isPersistJobDataAfterExecution(jobDetail.getJobClass())) {
                JobDataMap jobDataMap = jobDetail.getJobDataMap();
                jedis.del(jobDataMapHashKey);
                if (jobDataMap != null && !jobDataMap.isEmpty()) {
                    jedis.hmset(jobDataMapHashKey, this.getStringDataMap(jobDataMap));
                }
            }
            if (this.isJobConcurrentExecutionDisallowed(jobDetail.getJobClass())) {
                jedis.srem(this.redisSchema.blockedJobsSet(), new String[]{jobHashKey});
                jedis.del(this.redisSchema.jobBlockedKey(jobDetail.getKey()));
                jobTriggersSetKey = this.redisSchema.jobTriggersSetKey(jobDetail.getKey());
                for (String nonConcurrentTriggerHashKey : jedis.smembers(jobTriggersSetKey)) {
                    Double score = jedis.zscore(this.redisSchema.triggerStateKey(RedisTriggerState.BLOCKED), nonConcurrentTriggerHashKey);
                    if (score != null) {
                        this.setTriggerState(RedisTriggerState.WAITING, score, nonConcurrentTriggerHashKey, jedis);
                        continue;
                    }
                    score = jedis.zscore(this.redisSchema.triggerStateKey(RedisTriggerState.PAUSED_BLOCKED), nonConcurrentTriggerHashKey);
                    if (score == null) continue;
                    this.setTriggerState(RedisTriggerState.PAUSED, score, nonConcurrentTriggerHashKey, jedis);
                }
                this.signaler.signalSchedulingChange(0L);
            }
        } else {
            jedis.srem(this.redisSchema.blockedJobsSet(), new String[]{jobHashKey});
        }
        if (jedis.exists(triggerHashKey).booleanValue()) {
            if (triggerInstCode == Trigger.CompletedExecutionInstruction.DELETE_TRIGGER) {
                if (trigger.getNextFireTime() == null) {
                    if (this.isNullOrEmpty(jedis.hget(triggerHashKey, "nextFireTime"))) {
                        this.removeTrigger(trigger.getKey(), jedis);
                    }
                } else {
                    this.removeTrigger(trigger.getKey(), jedis);
                    this.signaler.signalSchedulingChange(0L);
                }
            } else if (triggerInstCode == Trigger.CompletedExecutionInstruction.SET_TRIGGER_COMPLETE) {
                this.setTriggerState(RedisTriggerState.COMPLETED, System.currentTimeMillis(), triggerHashKey, jedis);
                this.signaler.signalSchedulingChange(0L);
            } else if (triggerInstCode == Trigger.CompletedExecutionInstruction.SET_TRIGGER_ERROR) {
                logger.debug(String.format("Trigger %s set to ERROR state.", triggerHashKey));
                double score = trigger.getNextFireTime() != null ? (double)trigger.getNextFireTime().getTime() : 0.0;
                this.setTriggerState(RedisTriggerState.ERROR, score, triggerHashKey, jedis);
                this.signaler.signalSchedulingChange(0L);
            } else if (triggerInstCode == Trigger.CompletedExecutionInstruction.SET_ALL_JOB_TRIGGERS_ERROR) {
                jobTriggersSetKey = this.redisSchema.jobTriggersSetKey(jobDetail.getKey());
                for (String errorTriggerHashKey : jedis.smembers(jobTriggersSetKey)) {
                    String nextFireTime = jedis.hget(errorTriggerHashKey, "nextFireTime");
                    double score = this.isNullOrEmpty(nextFireTime) ? 0.0 : Double.parseDouble(nextFireTime);
                    this.setTriggerState(RedisTriggerState.ERROR, score, errorTriggerHashKey, jedis);
                }
                this.signaler.signalSchedulingChange(0L);
            } else if (triggerInstCode == Trigger.CompletedExecutionInstruction.SET_ALL_JOB_TRIGGERS_COMPLETE) {
                String jobTriggerSetKey = this.redisSchema.jobTriggersSetKey(jobDetail.getKey());
                for (String completedTriggerHashKey : jedis.smembers(jobTriggerSetKey)) {
                    this.setTriggerState(RedisTriggerState.COMPLETED, System.currentTimeMillis(), completedTriggerHashKey, jedis);
                }
                this.signaler.signalSchedulingChange(0L);
            }
        }
    }
}

