/*
 * Decompiled with CFR 0.152.
 */
package net.joelinn.quartz.jobstore;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.joelinn.quartz.jobstore.RedisJobStoreSchema;
import net.joelinn.quartz.jobstore.RedisTriggerState;
import org.quartz.Calendar;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobPersistenceException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.PersistJobDataAfterExecution;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.JobDetailImpl;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.spi.OperableTrigger;
import org.quartz.spi.SchedulerSignaler;
import org.quartz.spi.TriggerFiredResult;
import org.quartz.utils.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisCommands;
import redis.clients.jedis.Tuple;

public abstract class AbstractRedisStorage<T extends JedisCommands> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRedisStorage.class);
    protected static final String TRIGGER_CLASS = "trigger_class";
    protected static final String CALENDAR_CLASS = "calendar_class";
    protected static final String CALENDAR_JSON = "calendar_json";
    protected static final String TRIGGER_NEXT_FIRE_TIME = "nextFireTime";
    protected final RedisJobStoreSchema redisSchema;
    protected final ObjectMapper mapper;
    protected final SchedulerSignaler signaler;
    protected final String schedulerInstanceId;
    protected final int lockTimeout;
    protected final int TRIGGER_LOCK_TIMEOUT = 600000;
    protected int misfireThreshold = 60000;
    protected UUID lockValue;

    public AbstractRedisStorage(RedisJobStoreSchema redisSchema, ObjectMapper mapper, SchedulerSignaler signaler, String schedulerInstanceId, int lockTimeout) {
        this.signaler = signaler;
        this.schedulerInstanceId = schedulerInstanceId;
        this.redisSchema = redisSchema;
        this.mapper = mapper;
        this.lockTimeout = lockTimeout;
    }

    public AbstractRedisStorage setMisfireThreshold(int misfireThreshold) {
        this.misfireThreshold = misfireThreshold;
        return this;
    }

    public boolean lock(T jedis) {
        boolean lockAcquired;
        UUID lockId = UUID.randomUUID();
        String setResponse = jedis.set(this.redisSchema.lockKey(), lockId.toString(), "NX", "PX", (long)this.lockTimeout);
        boolean bl = lockAcquired = !this.isNullOrEmpty(setResponse) && setResponse.equals("OK");
        if (lockAcquired) {
            this.lockValue = lockId;
        }
        return lockAcquired;
    }

    public void waitForLock(T jedis) {
        while (!this.lock(jedis)) {
            try {
                logger.debug("Waiting for Redis lock.");
                Thread.sleep(this.randomInt(75, 125));
            }
            catch (InterruptedException e) {
                logger.error("Interrupted while waiting for lock.", (Throwable)e);
            }
        }
    }

    public boolean unlock(T jedis) {
        String currentLock = jedis.get(this.redisSchema.lockKey());
        if (!this.isNullOrEmpty(currentLock) && UUID.fromString(currentLock).equals(this.lockValue)) {
            jedis.del(this.redisSchema.lockKey());
            return true;
        }
        return false;
    }

    protected int randomInt(int min, int max) {
        return new Random().nextInt(max - min + 1) + min;
    }

    public void clearAllSchedulingData(T jedis) throws JobPersistenceException, ClassNotFoundException {
        for (String jobHashKey : jedis.smembers(this.redisSchema.jobsSet())) {
            this.removeJob(this.redisSchema.jobKey(jobHashKey), jedis);
        }
        for (String triggerHashKey : jedis.smembers(this.redisSchema.triggersSet())) {
            this.removeTrigger(this.redisSchema.triggerKey(triggerHashKey), jedis);
        }
        for (String calendarHashKey : jedis.smembers(this.redisSchema.calendarsSet())) {
            this.removeCalendar(this.redisSchema.calendarName(calendarHashKey), jedis);
        }
    }

    public abstract void storeJob(JobDetail var1, boolean var2, T var3) throws ObjectAlreadyExistsException;

    protected Map<String, String> getStringDataMap(JobDataMap jobDataMap) {
        HashMap<String, String> stringMap = new HashMap<String, String>();
        for (Map.Entry entry : jobDataMap.entrySet()) {
            if (entry.getValue() == null) continue;
            stringMap.put((String)entry.getKey(), entry.getValue().toString());
        }
        return stringMap;
    }

    public JobDetail retrieveJob(JobKey jobKey, T jedis) throws JobPersistenceException, ClassNotFoundException {
        String jobHashKey = this.redisSchema.jobHashKey(jobKey);
        String jobDataMapHashKey = this.redisSchema.jobDataMapHashKey(jobKey);
        Map jobDetailMap = jedis.hgetAll(jobHashKey);
        if (jobDetailMap == null || jobDetailMap.size() == 0) {
            return null;
        }
        JobDetailImpl jobDetail = (JobDetailImpl)this.mapper.convertValue((Object)jobDetailMap, JobDetailImpl.class);
        jobDetail.setKey(jobKey);
        Map jobData = jedis.hgetAll(jobDataMapHashKey);
        if (jobData != null && !jobData.isEmpty()) {
            JobDataMap jobDataMap = new JobDataMap();
            jobDataMap.putAll(jobData);
            jobDetail.setJobDataMap(jobDataMap);
        }
        return jobDetail;
    }

    public abstract boolean removeJob(JobKey var1, T var2) throws JobPersistenceException;

    public abstract void storeTrigger(OperableTrigger var1, boolean var2, T var3) throws JobPersistenceException;

    public boolean removeTrigger(TriggerKey triggerKey, T jedis) throws JobPersistenceException, ClassNotFoundException {
        return this.removeTrigger(triggerKey, true, jedis);
    }

    protected abstract boolean removeTrigger(TriggerKey var1, boolean var2, T var3) throws JobPersistenceException, ClassNotFoundException;

    public boolean replaceTrigger(TriggerKey triggerKey, OperableTrigger newTrigger, T jedis) throws JobPersistenceException, ClassNotFoundException {
        boolean found;
        OperableTrigger oldTrigger = this.retrieveTrigger(triggerKey, jedis);
        boolean bl = found = oldTrigger != null;
        if (found) {
            if (!oldTrigger.getJobKey().equals((Object)newTrigger.getJobKey())) {
                throw new JobPersistenceException("New trigger is not related to the same job as the old trigger.");
            }
            this.removeTrigger(triggerKey, false, jedis);
            this.storeTrigger(newTrigger, false, jedis);
        }
        return found;
    }

    public OperableTrigger retrieveTrigger(TriggerKey triggerKey, T jedis) throws JobPersistenceException {
        Class<?> triggerClass;
        String triggerHashKey = this.redisSchema.triggerHashKey(triggerKey);
        Map triggerMap = jedis.hgetAll(triggerHashKey);
        if (triggerMap == null || triggerMap.isEmpty()) {
            logger.debug(String.format("No trigger exists for key %s", triggerHashKey));
            return null;
        }
        try {
            triggerClass = Class.forName((String)triggerMap.get(TRIGGER_CLASS));
        }
        catch (ClassNotFoundException e) {
            throw new JobPersistenceException(String.format("Could not find class %s for trigger.", triggerMap.get(TRIGGER_CLASS)), (Throwable)e);
        }
        triggerMap.remove(TRIGGER_CLASS);
        OperableTrigger operableTrigger = (OperableTrigger)this.mapper.convertValue((Object)triggerMap, triggerClass);
        Map jobData = jedis.hgetAll(this.redisSchema.triggerDataMapHashKey(triggerKey));
        if (jobData != null && !jobData.isEmpty()) {
            JobDataMap jobDataMap = new JobDataMap();
            jobDataMap.putAll(jobData);
            operableTrigger.setJobDataMap(jobDataMap);
        }
        return operableTrigger;
    }

    public List<OperableTrigger> getTriggersForJob(JobKey jobKey, T jedis) throws JobPersistenceException {
        String jobTriggerSetKey = this.redisSchema.jobTriggersSetKey(jobKey);
        Set triggerHashKeys = jedis.smembers(jobTriggerSetKey);
        ArrayList<OperableTrigger> triggers = new ArrayList<OperableTrigger>();
        for (String triggerHashKey : triggerHashKeys) {
            triggers.add(this.retrieveTrigger(this.redisSchema.triggerKey(triggerHashKey), jedis));
        }
        return triggers;
    }

    public abstract boolean unsetTriggerState(String var1, T var2) throws JobPersistenceException;

    public boolean setTriggerState(RedisTriggerState state, double score, String triggerHashKey, T jedis) throws JobPersistenceException {
        boolean success = false;
        if (state != null) {
            this.unsetTriggerState(triggerHashKey, jedis);
            success = jedis.zadd(this.redisSchema.triggerStateKey(state), score, triggerHashKey) == 1L;
        }
        return success;
    }

    public boolean checkExists(JobKey jobKey, T jedis) {
        return jedis.exists(this.redisSchema.jobHashKey(jobKey));
    }

    public boolean checkExists(TriggerKey triggerKey, T jedis) {
        return jedis.exists(this.redisSchema.triggerHashKey(triggerKey));
    }

    public abstract void storeCalendar(String var1, Calendar var2, boolean var3, boolean var4, T var5) throws JobPersistenceException;

    public abstract boolean removeCalendar(String var1, T var2) throws JobPersistenceException;

    public Calendar retrieveCalendar(String name, T jedis) throws JobPersistenceException {
        Calendar calendar;
        String calendarHashKey = this.redisSchema.calendarHashKey(name);
        try {
            Map calendarMap = jedis.hgetAll(calendarHashKey);
            if (calendarMap == null || calendarMap.isEmpty()) {
                return null;
            }
            Class<?> calendarClass = Class.forName((String)calendarMap.get(CALENDAR_CLASS));
            calendar = (Calendar)this.mapper.readValue((String)calendarMap.get(CALENDAR_JSON), calendarClass);
        }
        catch (ClassNotFoundException e) {
            logger.error("Class not found for calendar " + name);
            throw new JobPersistenceException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Unable to deserialize calendar json for calendar " + name);
            throw new JobPersistenceException(e.getMessage(), (Throwable)e);
        }
        return calendar;
    }

    public int getNumberOfJobs(T jedis) {
        return jedis.scard(this.redisSchema.jobsSet()).intValue();
    }

    public int getNumberOfTriggers(T jedis) {
        return jedis.scard(this.redisSchema.triggersSet()).intValue();
    }

    public int getNumberOfCalendars(T jedis) {
        return jedis.scard(this.redisSchema.calendarsSet()).intValue();
    }

    public abstract Set<JobKey> getJobKeys(GroupMatcher<JobKey> var1, T var2);

    public abstract Set<TriggerKey> getTriggerKeys(GroupMatcher<TriggerKey> var1, T var2);

    public List<String> getJobGroupNames(T jedis) {
        Set groupsSet = jedis.smembers(this.redisSchema.jobGroupsSet());
        ArrayList<String> groups = new ArrayList<String>(groupsSet.size());
        for (String group : groupsSet) {
            groups.add(this.redisSchema.jobGroup(group));
        }
        return groups;
    }

    public List<String> getTriggerGroupNames(T jedis) {
        Set groupsSet = jedis.smembers(this.redisSchema.triggerGroupsSet());
        ArrayList<String> groups = new ArrayList<String>(groupsSet.size());
        for (String group : groupsSet) {
            groups.add(this.redisSchema.triggerGroup(group));
        }
        return groups;
    }

    public List<String> getCalendarNames(T jedis) {
        Set calendarsSet = jedis.smembers(this.redisSchema.calendarsSet());
        ArrayList<String> calendars = new ArrayList<String>(calendarsSet.size());
        for (String group : calendarsSet) {
            calendars.add(this.redisSchema.calendarName(group));
        }
        return calendars;
    }

    public abstract Trigger.TriggerState getTriggerState(TriggerKey var1, T var2);

    public abstract void pauseTrigger(TriggerKey var1, T var2) throws JobPersistenceException;

    public abstract Collection<String> pauseTriggers(GroupMatcher<TriggerKey> var1, T var2) throws JobPersistenceException;

    public void pauseJob(JobKey jobKey, T jedis) throws JobPersistenceException {
        for (OperableTrigger trigger : this.getTriggersForJob(jobKey, jedis)) {
            this.pauseTrigger(trigger.getKey(), jedis);
        }
    }

    public abstract Collection<String> pauseJobs(GroupMatcher<JobKey> var1, T var2) throws JobPersistenceException;

    public abstract void resumeTrigger(TriggerKey var1, T var2) throws JobPersistenceException;

    protected boolean applyMisfire(OperableTrigger trigger, T jedis) throws JobPersistenceException {
        Date nextFireTime;
        long misfireTime = System.currentTimeMillis();
        if (this.misfireThreshold > 0) {
            misfireTime -= (long)this.misfireThreshold;
        }
        if ((nextFireTime = trigger.getNextFireTime()) == null || nextFireTime.getTime() > misfireTime || trigger.getMisfireInstruction() == -1) {
            return false;
        }
        Calendar calendar = null;
        if (trigger.getCalendarName() != null) {
            calendar = this.retrieveCalendar(trigger.getCalendarName(), jedis);
        }
        this.signaler.notifyTriggerListenersMisfired((Trigger)((OperableTrigger)trigger.clone()));
        trigger.updateAfterMisfire(calendar);
        this.storeTrigger(trigger, true, jedis);
        if (trigger.getNextFireTime() == null) {
            this.setTriggerState(RedisTriggerState.COMPLETED, System.currentTimeMillis(), this.redisSchema.triggerHashKey(trigger.getKey()), jedis);
            this.signaler.notifySchedulerListenersFinalized((Trigger)trigger);
        } else if (nextFireTime.equals(trigger.getNextFireTime())) {
            return false;
        }
        return true;
    }

    public abstract Collection<String> resumeTriggers(GroupMatcher<TriggerKey> var1, T var2) throws JobPersistenceException;

    public Set<String> getPausedTriggerGroups(T jedis) {
        Set triggerGroupSetKeys = jedis.smembers(this.redisSchema.pausedTriggerGroupsSet());
        HashSet<String> names = new HashSet<String>(triggerGroupSetKeys.size());
        for (String triggerGroupSetKey : triggerGroupSetKeys) {
            names.add(this.redisSchema.triggerGroup(triggerGroupSetKey));
        }
        return names;
    }

    public void resumeJob(JobKey jobKey, T jedis) throws JobPersistenceException {
        for (OperableTrigger trigger : this.getTriggersForJob(jobKey, jedis)) {
            this.resumeTrigger(trigger.getKey(), jedis);
        }
    }

    public abstract Collection<String> resumeJobs(GroupMatcher<JobKey> var1, T var2) throws JobPersistenceException;

    public void pauseAll(T jedis) throws JobPersistenceException {
        for (String triggerGroupSet : jedis.smembers(this.redisSchema.triggerGroupsSet())) {
            this.pauseTriggers((GroupMatcher<TriggerKey>)GroupMatcher.triggerGroupEquals((String)this.redisSchema.triggerGroup(triggerGroupSet)), jedis);
        }
    }

    public void resumeAll(T jedis) throws JobPersistenceException {
        for (String triggerGroupSet : jedis.smembers(this.redisSchema.triggerGroupsSet())) {
            this.resumeTriggers((GroupMatcher<TriggerKey>)GroupMatcher.triggerGroupEquals((String)this.redisSchema.triggerGroup(triggerGroupSet)), jedis);
        }
    }

    protected void releaseOrphanedTriggers(RedisTriggerState currentState, RedisTriggerState newState, T jedis) throws JobPersistenceException {
        for (Tuple triggerTuple : jedis.zrangeWithScores(this.redisSchema.triggerStateKey(currentState), 0L, -1L)) {
            String lockId = jedis.get(this.redisSchema.triggerLockKey(this.redisSchema.triggerKey(triggerTuple.getElement())));
            if (!this.isNullOrEmpty(lockId)) continue;
            logger.debug(String.format("Changing state of orphaned trigger %s from %s to %s.", new Object[]{triggerTuple.getElement(), currentState, newState}));
            this.setTriggerState(newState, triggerTuple.getScore(), triggerTuple.getElement(), jedis);
        }
    }

    protected void releaseTriggersCron(T jedis) throws JobPersistenceException {
        if (System.currentTimeMillis() - this.getLastTriggersReleaseTime(jedis) > 600000L) {
            this.releaseOrphanedTriggers(RedisTriggerState.ACQUIRED, RedisTriggerState.WAITING, jedis);
            this.releaseOrphanedTriggers(RedisTriggerState.BLOCKED, RedisTriggerState.WAITING, jedis);
            this.releaseOrphanedTriggers(RedisTriggerState.PAUSED_BLOCKED, RedisTriggerState.PAUSED, jedis);
            this.settLastTriggerReleaseTime(System.currentTimeMillis(), jedis);
        }
    }

    protected long getLastTriggersReleaseTime(T jedis) {
        String lastReleaseTime = jedis.get(this.redisSchema.lastTriggerReleaseTime());
        if (lastReleaseTime == null) {
            return 0L;
        }
        return Long.parseLong(lastReleaseTime);
    }

    protected void settLastTriggerReleaseTime(long time, T jedis) {
        jedis.set(this.redisSchema.lastTriggerReleaseTime(), Long.toString(time));
    }

    protected boolean isJobConcurrentExecutionDisallowed(Class<? extends Job> jobClass) {
        return ClassUtils.isAnnotationPresent(jobClass, DisallowConcurrentExecution.class);
    }

    protected boolean lockTrigger(TriggerKey triggerKey, T jedis) {
        return jedis.set(this.redisSchema.triggerLockKey(triggerKey), this.schedulerInstanceId, "NX", "PX", 600000L).equals("OK");
    }

    public List<OperableTrigger> acquireNextTriggers(long noLaterThan, int maxCount, long timeWindow, T jedis) throws JobPersistenceException, ClassNotFoundException {
        boolean retry;
        this.releaseTriggersCron(jedis);
        ArrayList<OperableTrigger> acquiredTriggers = new ArrayList<OperableTrigger>();
        block0: do {
            retry = false;
            HashSet<String> acquiredJobHashKeysForNoConcurrentExec = new HashSet<String>();
            for (Tuple triggerTuple : jedis.zrangeByScoreWithScores(this.redisSchema.triggerStateKey(RedisTriggerState.WAITING), 0.0, (double)(noLaterThan + timeWindow), 0, maxCount)) {
                OperableTrigger trigger = this.retrieveTrigger(this.redisSchema.triggerKey(triggerTuple.getElement()), jedis);
                if (this.applyMisfire(trigger, jedis)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("misfired trigger: " + triggerTuple.getElement());
                    }
                    retry = true;
                    continue block0;
                }
                if (trigger.getNextFireTime() == null) {
                    this.unsetTriggerState(triggerTuple.getElement(), jedis);
                    continue;
                }
                String jobHashKey = this.redisSchema.jobHashKey(trigger.getJobKey());
                JobDetail job = this.retrieveJob(trigger.getJobKey(), jedis);
                if (job != null && this.isJobConcurrentExecutionDisallowed(job.getJobClass())) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Attempting to acquire job " + job.getKey() + " with concurrent execution disallowed.");
                    }
                    if (acquiredJobHashKeysForNoConcurrentExec.contains(jobHashKey)) {
                        if (!logger.isTraceEnabled()) continue;
                        logger.trace("Job " + job.getKey() + " with concurrent execution disallowed already acquired.");
                        continue;
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace("Job " + job.getKey() + " with concurrent execution disallowed not yet acquired. Acquiring.");
                    }
                    acquiredJobHashKeysForNoConcurrentExec.add(jobHashKey);
                }
                this.lockTrigger(trigger.getKey(), jedis);
                this.setTriggerState(RedisTriggerState.ACQUIRED, triggerTuple.getScore(), triggerTuple.getElement(), jedis);
                acquiredTriggers.add(trigger);
                logger.debug(String.format("Trigger %s acquired", triggerTuple.getElement()));
            }
        } while (retry);
        return acquiredTriggers;
    }

    public void releaseAcquiredTrigger(OperableTrigger trigger, T jedis) throws JobPersistenceException {
        String triggerHashKey = this.redisSchema.triggerHashKey(trigger.getKey());
        if (jedis.zscore(this.redisSchema.triggerStateKey(RedisTriggerState.ACQUIRED), triggerHashKey) != null) {
            if (trigger.getNextFireTime() != null) {
                this.setTriggerState(RedisTriggerState.WAITING, trigger.getNextFireTime().getTime(), triggerHashKey, jedis);
            } else {
                this.unsetTriggerState(triggerHashKey, jedis);
            }
        }
    }

    public abstract List<TriggerFiredResult> triggersFired(List<OperableTrigger> var1, T var2) throws JobPersistenceException, ClassNotFoundException;

    protected boolean isPersistJobDataAfterExecution(Class<? extends Job> jobClass) {
        return ClassUtils.isAnnotationPresent(jobClass, PersistJobDataAfterExecution.class);
    }

    public abstract void triggeredJobComplete(OperableTrigger var1, JobDetail var2, Trigger.CompletedExecutionInstruction var3, T var4) throws JobPersistenceException, ClassNotFoundException;

    protected boolean isNullOrEmpty(String string) {
        return string == null || string.length() == 0;
    }
}

