/*
 * Decompiled with CFR 0.152.
 */
package net.joelinn.quartz.jobstore;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.joelinn.quartz.jobstore.AbstractRedisStorage;
import net.joelinn.quartz.jobstore.RedisJobStoreSchema;
import net.joelinn.quartz.jobstore.RedisTriggerState;
import org.quartz.Calendar;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobPersistenceException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.impl.matchers.StringMatcher;
import org.quartz.spi.OperableTrigger;
import org.quartz.spi.SchedulerSignaler;
import org.quartz.spi.TriggerFiredBundle;
import org.quartz.spi.TriggerFiredResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;

public class RedisStorage
extends AbstractRedisStorage<Jedis> {
    private static final Logger logger = LoggerFactory.getLogger(RedisStorage.class);

    public RedisStorage(RedisJobStoreSchema redisSchema, ObjectMapper mapper, SchedulerSignaler signaler, String schedulerInstanceId, int lockTimeout) {
        super(redisSchema, mapper, signaler, schedulerInstanceId, lockTimeout);
    }

    @Override
    public boolean removeJob(JobKey jobKey, Jedis jedis) throws JobPersistenceException {
        String jobHashKey = this.redisSchema.jobHashKey(jobKey);
        String jobDataMapHashKey = this.redisSchema.jobDataMapHashKey(jobKey);
        String jobGroupSetKey = this.redisSchema.jobGroupSetKey(jobKey);
        String jobTriggerSetKey = this.redisSchema.jobTriggersSetKey(jobKey);
        Pipeline pipe = jedis.pipelined();
        Response<Long> delJobHashKeyResponse = pipe.del(jobHashKey);
        pipe.del(jobDataMapHashKey);
        pipe.srem(this.redisSchema.jobsSet(), jobHashKey);
        pipe.srem(jobGroupSetKey, jobHashKey);
        Response<Set<String>> jobTriggerSetResponse = pipe.smembers(jobTriggerSetKey);
        pipe.del(jobTriggerSetKey);
        Response<Long> jobGroupSetSizeResponse = pipe.scard(jobGroupSetKey);
        pipe.sync();
        if (jobGroupSetSizeResponse.get() == 0L) {
            jedis.srem(this.redisSchema.jobGroupsSet(), jobGroupSetKey);
        }
        pipe = jedis.pipelined();
        for (String triggerHashKey : jobTriggerSetResponse.get()) {
            TriggerKey triggerKey = this.redisSchema.triggerKey(triggerHashKey);
            String triggerGroupSetKey = this.redisSchema.triggerGroupSetKey(triggerKey);
            this.unsetTriggerState(triggerHashKey, jedis);
            pipe.srem(this.redisSchema.triggersSet(), triggerHashKey);
            pipe.srem(this.redisSchema.triggerGroupsSet(), triggerGroupSetKey);
            pipe.srem(triggerGroupSetKey, triggerHashKey);
            pipe.del(triggerHashKey);
        }
        pipe.sync();
        return delJobHashKeyResponse.get() == 1L;
    }

    @Override
    protected boolean removeTrigger(TriggerKey triggerKey, boolean removeNonDurableJob, Jedis jedis) throws JobPersistenceException, ClassNotFoundException {
        String triggerHashKey = this.redisSchema.triggerHashKey(triggerKey);
        String triggerGroupSetKey = this.redisSchema.triggerGroupSetKey(triggerKey);
        if (!jedis.exists(triggerHashKey).booleanValue()) {
            return false;
        }
        OperableTrigger trigger = this.retrieveTrigger(triggerKey, jedis);
        String jobHashKey = this.redisSchema.jobHashKey(trigger.getJobKey());
        String jobTriggerSetKey = this.redisSchema.jobTriggersSetKey(trigger.getJobKey());
        Pipeline pipe = jedis.pipelined();
        pipe.srem(this.redisSchema.triggersSet(), triggerHashKey);
        pipe.srem(triggerGroupSetKey, triggerHashKey);
        pipe.srem(jobTriggerSetKey, triggerHashKey);
        pipe.sync();
        if (jedis.scard(triggerGroupSetKey) == 0L) {
            jedis.srem(this.redisSchema.triggerGroupsSet(), triggerGroupSetKey);
        }
        if (removeNonDurableJob) {
            JobDetail job;
            pipe = jedis.pipelined();
            Response<Long> jobTriggerSetKeySizeResponse = pipe.scard(jobTriggerSetKey);
            Response<Boolean> jobExistsResponse = pipe.exists(jobHashKey);
            pipe.sync();
            if (jobTriggerSetKeySizeResponse.get() == 0L && jobExistsResponse.get().booleanValue() && !(job = this.retrieveJob(trigger.getJobKey(), jedis)).isDurable()) {
                this.removeJob(job.getKey(), jedis);
                this.signaler.notifySchedulerListenersJobDeleted(job.getKey());
            }
        }
        if (this.isNullOrEmpty(trigger.getCalendarName())) {
            jedis.srem(this.redisSchema.calendarTriggersSetKey(trigger.getCalendarName()), triggerHashKey);
        }
        this.unsetTriggerState(triggerHashKey, jedis);
        jedis.del(triggerHashKey);
        jedis.del(this.redisSchema.triggerDataMapHashKey(triggerKey));
        return true;
    }

    @Override
    public void storeJob(JobDetail jobDetail, boolean replaceExisting, Jedis jedis) throws ObjectAlreadyExistsException {
        String jobHashKey = this.redisSchema.jobHashKey(jobDetail.getKey());
        String jobDataMapHashKey = this.redisSchema.jobDataMapHashKey(jobDetail.getKey());
        String jobGroupSetKey = this.redisSchema.jobGroupSetKey(jobDetail.getKey());
        if (!replaceExisting && jedis.exists(jobHashKey).booleanValue()) {
            throw new ObjectAlreadyExistsException(jobDetail);
        }
        Pipeline pipe = jedis.pipelined();
        pipe.hmset(jobHashKey, (Map)this.mapper.convertValue((Object)jobDetail, new TypeReference<HashMap<String, String>>(){}));
        if (jobDetail.getJobDataMap() != null && !jobDetail.getJobDataMap().isEmpty()) {
            pipe.hmset(jobDataMapHashKey, this.getStringDataMap(jobDetail.getJobDataMap()));
        }
        pipe.sadd(this.redisSchema.jobsSet(), jobHashKey);
        pipe.sadd(this.redisSchema.jobGroupsSet(), jobGroupSetKey);
        pipe.sadd(jobGroupSetKey, jobHashKey);
        pipe.sync();
    }

    @Override
    public void storeTrigger(OperableTrigger trigger, boolean replaceExisting, Jedis jedis) throws JobPersistenceException {
        long nextFireTime;
        String triggerHashKey = this.redisSchema.triggerHashKey(trigger.getKey());
        String triggerGroupSetKey = this.redisSchema.triggerGroupSetKey(trigger.getKey());
        String jobTriggerSetKey = this.redisSchema.jobTriggersSetKey(trigger.getJobKey());
        if (!(trigger instanceof SimpleTrigger) && !(trigger instanceof CronTrigger)) {
            throw new UnsupportedOperationException("Only SimpleTrigger and CronTrigger are supported.");
        }
        boolean exists = jedis.exists(triggerHashKey);
        if (exists && !replaceExisting) {
            throw new ObjectAlreadyExistsException(trigger);
        }
        Map triggerMap = (Map)this.mapper.convertValue((Object)trigger, new TypeReference<HashMap<String, String>>(){});
        triggerMap.put("trigger_class", trigger.getClass().getName());
        Pipeline pipe = jedis.pipelined();
        pipe.hmset(triggerHashKey, triggerMap);
        pipe.sadd(this.redisSchema.triggersSet(), triggerHashKey);
        pipe.sadd(this.redisSchema.triggerGroupsSet(), triggerGroupSetKey);
        pipe.sadd(triggerGroupSetKey, triggerHashKey);
        pipe.sadd(jobTriggerSetKey, triggerHashKey);
        if (trigger.getCalendarName() != null && !trigger.getCalendarName().isEmpty()) {
            String calendarTriggersSetKey = this.redisSchema.calendarTriggersSetKey(trigger.getCalendarName());
            pipe.sadd(calendarTriggersSetKey, triggerHashKey);
        }
        if (trigger.getJobDataMap() != null && !trigger.getJobDataMap().isEmpty()) {
            String triggerDataMapHashKey = this.redisSchema.triggerDataMapHashKey(trigger.getKey());
            pipe.hmset(triggerDataMapHashKey, this.getStringDataMap(trigger.getJobDataMap()));
        }
        pipe.sync();
        if (exists) {
            this.unsetTriggerState(triggerHashKey, jedis);
        }
        pipe = jedis.pipelined();
        Response<Boolean> triggerPausedResponse = pipe.sismember(this.redisSchema.pausedTriggerGroupsSet(), triggerGroupSetKey);
        Response<Boolean> jobPausedResponse = pipe.sismember(this.redisSchema.pausedJobGroupsSet(), this.redisSchema.jobGroupSetKey(trigger.getJobKey()));
        pipe.sync();
        String jobHashKey = this.redisSchema.jobHashKey(trigger.getJobKey());
        long l = nextFireTime = trigger.getNextFireTime() != null ? trigger.getNextFireTime().getTime() : -1L;
        if (triggerPausedResponse.get().booleanValue() || jobPausedResponse.get().booleanValue()) {
            if (jedis.sismember(this.redisSchema.blockedJobsSet(), jobHashKey).booleanValue()) {
                this.setTriggerState(RedisTriggerState.PAUSED_BLOCKED, nextFireTime, triggerHashKey, jedis);
            } else {
                this.setTriggerState(RedisTriggerState.PAUSED, nextFireTime, triggerHashKey, jedis);
            }
        } else if (trigger.getNextFireTime() != null) {
            if (jedis.sismember(this.redisSchema.blockedJobsSet(), jobHashKey).booleanValue()) {
                this.setTriggerState(RedisTriggerState.BLOCKED, nextFireTime, triggerHashKey, jedis);
            } else {
                this.setTriggerState(RedisTriggerState.WAITING, trigger.getNextFireTime().getTime(), triggerHashKey, jedis);
            }
        }
    }

    @Override
    public boolean unsetTriggerState(String triggerHashKey, Jedis jedis) throws JobPersistenceException {
        boolean removed = false;
        Pipeline pipe = jedis.pipelined();
        ArrayList<Response<Long>> responses = new ArrayList<Response<Long>>(RedisTriggerState.values().length);
        for (RedisTriggerState state : RedisTriggerState.values()) {
            responses.add(pipe.zrem(this.redisSchema.triggerStateKey(state), triggerHashKey));
        }
        pipe.sync();
        for (Response response : responses) {
            removed = (Long)response.get() == 1L;
            if (!removed) continue;
            jedis.del(this.redisSchema.triggerLockKey(this.redisSchema.triggerKey(triggerHashKey)));
            break;
        }
        return removed;
    }

    @Override
    public void storeCalendar(String name, Calendar calendar, boolean replaceExisting, boolean updateTriggers, Jedis jedis) throws JobPersistenceException {
        String calendarHashKey = this.redisSchema.calendarHashKey(name);
        if (!replaceExisting && jedis.exists(calendarHashKey).booleanValue()) {
            throw new ObjectAlreadyExistsException(String.format("Calendar with key %s already exists.", calendarHashKey));
        }
        HashMap<String, String> calendarMap = new HashMap<String, String>();
        calendarMap.put("calendar_class", calendar.getClass().getName());
        try {
            calendarMap.put("calendar_json", this.mapper.writeValueAsString(calendar));
        }
        catch (JsonProcessingException e) {
            throw new JobPersistenceException("Unable to serialize calendar.", e);
        }
        Pipeline pipe = jedis.pipelined();
        pipe.hmset(calendarHashKey, calendarMap);
        pipe.sadd(this.redisSchema.calendarsSet(), calendarHashKey);
        pipe.sync();
        if (updateTriggers) {
            String calendarTriggersSetKey = this.redisSchema.calendarTriggersSetKey(name);
            Set<String> triggerHashKeys = jedis.smembers(calendarTriggersSetKey);
            for (String triggerHashKey : triggerHashKeys) {
                OperableTrigger trigger = this.retrieveTrigger(this.redisSchema.triggerKey(triggerHashKey), jedis);
                long removed = jedis.zrem(this.redisSchema.triggerStateKey(RedisTriggerState.WAITING), triggerHashKey);
                trigger.updateWithNewCalendar(calendar, this.misfireThreshold);
                if (removed != 1L) continue;
                this.setTriggerState(RedisTriggerState.WAITING, trigger.getNextFireTime().getTime(), triggerHashKey, jedis);
            }
        }
    }

    @Override
    public boolean removeCalendar(String calendarName, Jedis jedis) throws JobPersistenceException {
        String calendarTriggersSetKey = this.redisSchema.calendarTriggersSetKey(calendarName);
        if (jedis.scard(calendarTriggersSetKey) > 0L) {
            throw new JobPersistenceException(String.format("There are triggers pointing to calendar %s, so it cannot be removed.", calendarName));
        }
        String calendarHashKey = this.redisSchema.calendarHashKey(calendarName);
        Pipeline pipe = jedis.pipelined();
        Response<Long> deleteResponse = pipe.del(calendarHashKey);
        pipe.srem(this.redisSchema.calendarsSet(), calendarHashKey);
        pipe.sync();
        return deleteResponse.get() == 1L;
    }

    @Override
    public Set<JobKey> getJobKeys(GroupMatcher<JobKey> matcher, Jedis jedis) {
        HashSet<JobKey> jobKeys;
        block5: {
            block4: {
                jobKeys = new HashSet<JobKey>();
                if (matcher.getCompareWithOperator() != StringMatcher.StringOperatorName.EQUALS) break block4;
                String jobGroupSetKey = this.redisSchema.jobGroupSetKey(new JobKey("", matcher.getCompareToValue()));
                Set<String> jobs = jedis.smembers(jobGroupSetKey);
                if (jobs == null) break block5;
                for (String string : jobs) {
                    jobKeys.add(this.redisSchema.jobKey(string));
                }
                break block5;
            }
            ArrayList<Response<Set<String>>> jobGroups = new ArrayList<Response<Set<String>>>();
            Pipeline pipe = jedis.pipelined();
            for (String string : jedis.smembers(this.redisSchema.jobGroupsSet())) {
                if (!matcher.getCompareWithOperator().evaluate(this.redisSchema.jobGroup(string), matcher.getCompareToValue())) continue;
                jobGroups.add(pipe.smembers(string));
            }
            pipe.sync();
            for (Response response : jobGroups) {
                if (response.get() == null) continue;
                for (String job : (Set)response.get()) {
                    jobKeys.add(this.redisSchema.jobKey(job));
                }
            }
        }
        return jobKeys;
    }

    @Override
    public Set<TriggerKey> getTriggerKeys(GroupMatcher<TriggerKey> matcher, Jedis jedis) {
        HashSet<TriggerKey> triggerKeys;
        block5: {
            block4: {
                triggerKeys = new HashSet<TriggerKey>();
                if (matcher.getCompareWithOperator() != StringMatcher.StringOperatorName.EQUALS) break block4;
                String triggerGroupSetKey = this.redisSchema.triggerGroupSetKey(new TriggerKey("", matcher.getCompareToValue()));
                Set<String> triggers = jedis.smembers(triggerGroupSetKey);
                if (triggers == null) break block5;
                for (String string : triggers) {
                    triggerKeys.add(this.redisSchema.triggerKey(string));
                }
                break block5;
            }
            ArrayList<Response<Set<String>>> triggerGroups = new ArrayList<Response<Set<String>>>();
            Pipeline pipe = jedis.pipelined();
            for (String string : jedis.smembers(this.redisSchema.triggerGroupsSet())) {
                if (!matcher.getCompareWithOperator().evaluate(this.redisSchema.triggerGroup(string), matcher.getCompareToValue())) continue;
                triggerGroups.add(pipe.smembers(string));
            }
            pipe.sync();
            for (Response response : triggerGroups) {
                if (response.get() == null) continue;
                for (String trigger : (Set)response.get()) {
                    triggerKeys.add(this.redisSchema.triggerKey(trigger));
                }
            }
        }
        return triggerKeys;
    }

    @Override
    public Trigger.TriggerState getTriggerState(TriggerKey triggerKey, Jedis jedis) {
        String triggerHashKey = this.redisSchema.triggerHashKey(triggerKey);
        Pipeline pipe = jedis.pipelined();
        HashMap<RedisTriggerState, Response<Double>> scores = new HashMap<RedisTriggerState, Response<Double>>(RedisTriggerState.values().length);
        for (RedisTriggerState redisTriggerState : RedisTriggerState.values()) {
            scores.put(redisTriggerState, pipe.zscore(this.redisSchema.triggerStateKey(redisTriggerState), triggerHashKey));
        }
        pipe.sync();
        for (Map.Entry entry : scores.entrySet()) {
            if (((Response)entry.getValue()).get() == null) continue;
            return ((RedisTriggerState)((Object)entry.getKey())).getTriggerState();
        }
        return Trigger.TriggerState.NONE;
    }

    @Override
    public void pauseTrigger(TriggerKey triggerKey, Jedis jedis) throws JobPersistenceException {
        long nextFireTime;
        String triggerHashKey = this.redisSchema.triggerHashKey(triggerKey);
        Pipeline pipe = jedis.pipelined();
        Response<Boolean> exists = pipe.exists(triggerHashKey);
        Response<Double> completedScore = pipe.zscore(this.redisSchema.triggerStateKey(RedisTriggerState.COMPLETED), triggerHashKey);
        Response<String> nextFireTimeResponse = pipe.hget(triggerHashKey, "nextFireTime");
        Response<Double> blockedScore = pipe.zscore(this.redisSchema.triggerStateKey(RedisTriggerState.BLOCKED), triggerHashKey);
        pipe.sync();
        if (!exists.get().booleanValue()) {
            return;
        }
        if (completedScore.get() != null) {
            return;
        }
        long l = nextFireTime = nextFireTimeResponse.get() == null || nextFireTimeResponse.get().isEmpty() ? -1L : Long.parseLong(nextFireTimeResponse.get());
        if (blockedScore.get() != null) {
            this.setTriggerState(RedisTriggerState.PAUSED_BLOCKED, nextFireTime, triggerHashKey, jedis);
        } else {
            this.setTriggerState(RedisTriggerState.PAUSED, nextFireTime, triggerHashKey, jedis);
        }
    }

    @Override
    public Collection<String> pauseTriggers(GroupMatcher<TriggerKey> matcher, Jedis jedis) throws JobPersistenceException {
        HashSet<String> pausedTriggerGroups = new HashSet<String>();
        if (matcher.getCompareWithOperator() == StringMatcher.StringOperatorName.EQUALS) {
            String triggerGroupSetKey = this.redisSchema.triggerGroupSetKey(new TriggerKey("", matcher.getCompareToValue()));
            long addResult = jedis.sadd(this.redisSchema.pausedTriggerGroupsSet(), triggerGroupSetKey);
            if (addResult > 0L) {
                for (String trigger : jedis.smembers(triggerGroupSetKey)) {
                    this.pauseTrigger(this.redisSchema.triggerKey(trigger), jedis);
                }
                pausedTriggerGroups.add(this.redisSchema.triggerGroup(triggerGroupSetKey));
            }
        } else {
            HashMap<String, Response<Set<String>>> triggerGroups = new HashMap<String, Response<Set<String>>>();
            Pipeline pipe = jedis.pipelined();
            for (String string : jedis.smembers(this.redisSchema.triggerGroupsSet())) {
                if (!matcher.getCompareWithOperator().evaluate(this.redisSchema.triggerGroup(string), matcher.getCompareToValue())) continue;
                triggerGroups.put(string, pipe.smembers(string));
            }
            pipe.sync();
            for (Map.Entry entry : triggerGroups.entrySet()) {
                if (jedis.sadd(this.redisSchema.pausedJobGroupsSet(), (String)entry.getKey()) <= 0L) continue;
                pausedTriggerGroups.add(this.redisSchema.triggerGroup((String)entry.getKey()));
                for (String triggerHashKey : (Set)((Response)entry.getValue()).get()) {
                    this.pauseTrigger(this.redisSchema.triggerKey(triggerHashKey), jedis);
                }
            }
        }
        return pausedTriggerGroups;
    }

    @Override
    public Collection<String> pauseJobs(GroupMatcher<JobKey> groupMatcher, Jedis jedis) throws JobPersistenceException {
        HashSet<String> pausedJobGroups;
        block5: {
            block4: {
                pausedJobGroups = new HashSet<String>();
                if (groupMatcher.getCompareWithOperator() != StringMatcher.StringOperatorName.EQUALS) break block4;
                String jobGroupSetKey = this.redisSchema.jobGroupSetKey(new JobKey("", groupMatcher.getCompareToValue()));
                if (jedis.sadd(this.redisSchema.pausedJobGroupsSet(), jobGroupSetKey) <= 0L) break block5;
                pausedJobGroups.add(this.redisSchema.jobGroup(jobGroupSetKey));
                for (String job : jedis.smembers(jobGroupSetKey)) {
                    this.pauseJob(this.redisSchema.jobKey(job), jedis);
                }
                break block5;
            }
            HashMap<String, Response<Set<String>>> jobGroups = new HashMap<String, Response<Set<String>>>();
            Pipeline pipe = jedis.pipelined();
            for (String string : jedis.smembers(this.redisSchema.jobGroupsSet())) {
                if (!groupMatcher.getCompareWithOperator().evaluate(this.redisSchema.jobGroup(string), groupMatcher.getCompareToValue())) continue;
                jobGroups.put(string, pipe.smembers(string));
            }
            pipe.sync();
            for (Map.Entry entry : jobGroups.entrySet()) {
                if (jedis.sadd(this.redisSchema.pausedJobGroupsSet(), (String)entry.getKey()) <= 0L) continue;
                pausedJobGroups.add(this.redisSchema.jobGroup((String)entry.getKey()));
                for (String jobHashKey : (Set)((Response)entry.getValue()).get()) {
                    this.pauseJob(this.redisSchema.jobKey(jobHashKey), jedis);
                }
            }
        }
        return pausedJobGroups;
    }

    @Override
    public void resumeTrigger(TriggerKey triggerKey, Jedis jedis) throws JobPersistenceException {
        String triggerHashKey = this.redisSchema.triggerHashKey(triggerKey);
        Pipeline pipe = jedis.pipelined();
        Response<Boolean> exists = pipe.sismember(this.redisSchema.triggersSet(), triggerHashKey);
        Response<Double> isPaused = pipe.zscore(this.redisSchema.triggerStateKey(RedisTriggerState.PAUSED), triggerHashKey);
        Response<Double> isPausedBlocked = pipe.zscore(this.redisSchema.triggerStateKey(RedisTriggerState.PAUSED_BLOCKED), triggerHashKey);
        pipe.sync();
        if (!exists.get().booleanValue()) {
            return;
        }
        if (isPaused.get() == null && isPausedBlocked.get() == null) {
            return;
        }
        OperableTrigger trigger = this.retrieveTrigger(triggerKey, jedis);
        String jobHashKey = this.redisSchema.jobHashKey(trigger.getJobKey());
        Date nextFireTime = trigger.getNextFireTime();
        if (nextFireTime != null) {
            if (jedis.sismember(this.redisSchema.blockedJobsSet(), jobHashKey).booleanValue()) {
                this.setTriggerState(RedisTriggerState.BLOCKED, nextFireTime.getTime(), triggerHashKey, jedis);
            } else {
                this.setTriggerState(RedisTriggerState.WAITING, nextFireTime.getTime(), triggerHashKey, jedis);
            }
        }
        this.applyMisfire(trigger, jedis);
    }

    @Override
    public Collection<String> resumeTriggers(GroupMatcher<TriggerKey> matcher, Jedis jedis) throws JobPersistenceException {
        HashSet<String> resumedTriggerGroups = new HashSet<String>();
        if (matcher.getCompareWithOperator() == StringMatcher.StringOperatorName.EQUALS) {
            String triggerGroupSetKey = this.redisSchema.triggerGroupSetKey(new TriggerKey("", matcher.getCompareToValue()));
            Pipeline pipe = jedis.pipelined();
            pipe.srem(this.redisSchema.pausedJobGroupsSet(), triggerGroupSetKey);
            Response<Set<String>> triggerHashKeysResponse = pipe.smembers(triggerGroupSetKey);
            pipe.sync();
            for (String triggerHashKey : triggerHashKeysResponse.get()) {
                OperableTrigger trigger = this.retrieveTrigger(this.redisSchema.triggerKey(triggerHashKey), jedis);
                this.resumeTrigger(trigger.getKey(), jedis);
                resumedTriggerGroups.add(trigger.getKey().getGroup());
            }
        } else {
            for (String triggerGroupSetKey : jedis.smembers(this.redisSchema.triggerGroupsSet())) {
                if (!matcher.getCompareWithOperator().evaluate(this.redisSchema.triggerGroup(triggerGroupSetKey), matcher.getCompareToValue())) continue;
                resumedTriggerGroups.addAll(this.resumeTriggers(GroupMatcher.triggerGroupEquals(this.redisSchema.triggerGroup(triggerGroupSetKey)), jedis));
            }
        }
        return resumedTriggerGroups;
    }

    @Override
    public Collection<String> resumeJobs(GroupMatcher<JobKey> matcher, Jedis jedis) throws JobPersistenceException {
        HashSet<String> resumedJobGroups = new HashSet<String>();
        if (matcher.getCompareWithOperator() == StringMatcher.StringOperatorName.EQUALS) {
            String jobGroupSetKey = this.redisSchema.jobGroupSetKey(new JobKey("", matcher.getCompareToValue()));
            Pipeline pipe = jedis.pipelined();
            Response<Long> unpauseResponse = pipe.srem(this.redisSchema.pausedJobGroupsSet(), jobGroupSetKey);
            Response<Set<String>> jobsResponse = pipe.smembers(jobGroupSetKey);
            pipe.sync();
            if (unpauseResponse.get() > 0L) {
                resumedJobGroups.add(this.redisSchema.jobGroup(jobGroupSetKey));
            }
            for (String job : jobsResponse.get()) {
                this.resumeJob(this.redisSchema.jobKey(job), jedis);
            }
        } else {
            for (String jobGroupSetKey : jedis.smembers(this.redisSchema.jobGroupsSet())) {
                if (!matcher.getCompareWithOperator().evaluate(this.redisSchema.jobGroup(jobGroupSetKey), matcher.getCompareToValue())) continue;
                resumedJobGroups.addAll(this.resumeJobs(GroupMatcher.jobGroupEquals(this.redisSchema.jobGroup(jobGroupSetKey)), jedis));
            }
        }
        return resumedJobGroups;
    }

    @Override
    public List<TriggerFiredResult> triggersFired(List<OperableTrigger> triggers, Jedis jedis) throws JobPersistenceException, ClassNotFoundException {
        ArrayList<TriggerFiredResult> results = new ArrayList<TriggerFiredResult>();
        for (OperableTrigger trigger : triggers) {
            String triggerHashKey = this.redisSchema.triggerHashKey(trigger.getKey());
            logger.debug(String.format("Trigger %s fired.", triggerHashKey));
            Pipeline pipe = jedis.pipelined();
            Response<Boolean> triggerExistsResponse = pipe.exists(triggerHashKey);
            Response<Double> triggerAcquiredResponse = pipe.zscore(this.redisSchema.triggerStateKey(RedisTriggerState.ACQUIRED), triggerHashKey);
            pipe.sync();
            if (!triggerExistsResponse.get().booleanValue() || triggerAcquiredResponse.get() == null) {
                if (!triggerExistsResponse.get().booleanValue()) {
                    logger.debug(String.format("Trigger %s does not exist.", triggerHashKey));
                    continue;
                }
                logger.debug(String.format("Trigger %s was not acquired.", triggerHashKey));
                continue;
            }
            Calendar calendar = null;
            String calendarName = trigger.getCalendarName();
            if (calendarName != null && (calendar = this.retrieveCalendar(calendarName, jedis)) == null) continue;
            Date previousFireTime = trigger.getPreviousFireTime();
            trigger.triggered(calendar);
            long nextFireTime = trigger.getNextFireTime().getTime();
            jedis.hset(triggerHashKey, "nextFireTime", Long.toString(nextFireTime));
            this.setTriggerState(RedisTriggerState.WAITING, nextFireTime, triggerHashKey, jedis);
            JobDetail job = this.retrieveJob(trigger.getJobKey(), jedis);
            TriggerFiredBundle triggerFiredBundle = new TriggerFiredBundle(job, trigger, calendar, false, new Date(), previousFireTime, previousFireTime, trigger.getNextFireTime());
            if (this.isJobConcurrentExecutionDisallowed(job.getJobClass())) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Firing trigger " + trigger.getKey() + " for job " + job.getKey() + " for which concurrent execution is disallowed. Adding job to blocked jobs set.");
                }
                String jobHashKey = this.redisSchema.jobHashKey(trigger.getJobKey());
                String jobTriggerSetKey = this.redisSchema.jobTriggersSetKey(job.getKey());
                for (String nonConcurrentTriggerHashKey : jedis.smembers(jobTriggerSetKey)) {
                    Double score = jedis.zscore(this.redisSchema.triggerStateKey(RedisTriggerState.WAITING), nonConcurrentTriggerHashKey);
                    if (score != null) {
                        if (logger.isTraceEnabled()) {
                            logger.trace("Setting state of trigger " + trigger.getKey() + " for non-concurrent job " + job.getKey() + " to BLOCKED.");
                        }
                        this.setTriggerState(RedisTriggerState.BLOCKED, score, nonConcurrentTriggerHashKey, jedis);
                        continue;
                    }
                    score = jedis.zscore(this.redisSchema.triggerStateKey(RedisTriggerState.PAUSED), nonConcurrentTriggerHashKey);
                    if (score == null) continue;
                    if (logger.isTraceEnabled()) {
                        logger.trace("Setting state of trigger " + trigger.getKey() + " for non-concurrent job " + job.getKey() + " to PAUSED_BLOCKED.");
                    }
                    this.setTriggerState(RedisTriggerState.PAUSED_BLOCKED, score, nonConcurrentTriggerHashKey, jedis);
                }
                pipe = jedis.pipelined();
                pipe.set(this.redisSchema.jobBlockedKey(job.getKey()), this.schedulerInstanceId);
                pipe.sadd(this.redisSchema.blockedJobsSet(), jobHashKey);
                pipe.sync();
            } else if (trigger.getNextFireTime() != null) {
                jedis.hset(triggerHashKey, "nextFireTime", Long.toString(nextFireTime));
                logger.debug(String.format("Releasing trigger %s with next fire time %s. Setting state to WAITING.", triggerHashKey, nextFireTime));
                this.setTriggerState(RedisTriggerState.WAITING, nextFireTime, triggerHashKey, jedis);
            } else {
                jedis.hset(triggerHashKey, "nextFireTime", "");
                this.unsetTriggerState(triggerHashKey, jedis);
            }
            results.add(new TriggerFiredResult(triggerFiredBundle));
        }
        return results;
    }

    @Override
    public void triggeredJobComplete(OperableTrigger trigger, JobDetail jobDetail, Trigger.CompletedExecutionInstruction triggerInstCode, Jedis jedis) throws JobPersistenceException, ClassNotFoundException {
        String jobHashKey = this.redisSchema.jobHashKey(jobDetail.getKey());
        String jobDataMapHashKey = this.redisSchema.jobDataMapHashKey(jobDetail.getKey());
        String triggerHashKey = this.redisSchema.triggerHashKey(trigger.getKey());
        logger.debug(String.format("Job %s completed.", jobHashKey));
        if (jedis.exists(jobHashKey).booleanValue()) {
            Pipeline pipe;
            if (this.isPersistJobDataAfterExecution(jobDetail.getJobClass())) {
                JobDataMap jobDataMap = jobDetail.getJobDataMap();
                pipe = jedis.pipelined();
                pipe.del(jobDataMapHashKey);
                if (jobDataMap != null && !jobDataMap.isEmpty()) {
                    pipe.hmset(jobDataMapHashKey, this.getStringDataMap(jobDataMap));
                }
                pipe.sync();
            }
            if (this.isJobConcurrentExecutionDisallowed(jobDetail.getJobClass())) {
                pipe = jedis.pipelined();
                pipe.srem(this.redisSchema.blockedJobsSet(), jobHashKey);
                pipe.del(this.redisSchema.jobBlockedKey(jobDetail.getKey()));
                pipe.sync();
                String jobTriggersSetKey = this.redisSchema.jobTriggersSetKey(jobDetail.getKey());
                for (String nonConcurrentTriggerHashKey : jedis.smembers(jobTriggersSetKey)) {
                    Double score = jedis.zscore(this.redisSchema.triggerStateKey(RedisTriggerState.BLOCKED), nonConcurrentTriggerHashKey);
                    if (score != null) {
                        this.setTriggerState(RedisTriggerState.WAITING, score, nonConcurrentTriggerHashKey, jedis);
                        continue;
                    }
                    score = jedis.zscore(this.redisSchema.triggerStateKey(RedisTriggerState.PAUSED_BLOCKED), nonConcurrentTriggerHashKey);
                    if (score == null) continue;
                    this.setTriggerState(RedisTriggerState.PAUSED, score, nonConcurrentTriggerHashKey, jedis);
                }
                this.signaler.signalSchedulingChange(0L);
            }
        } else {
            jedis.srem(this.redisSchema.blockedJobsSet(), jobHashKey);
        }
        if (jedis.exists(triggerHashKey).booleanValue()) {
            if (triggerInstCode == Trigger.CompletedExecutionInstruction.DELETE_TRIGGER) {
                if (trigger.getNextFireTime() == null) {
                    if (this.isNullOrEmpty(jedis.hget(triggerHashKey, "nextFireTime"))) {
                        this.removeTrigger(trigger.getKey(), jedis);
                    }
                } else {
                    this.removeTrigger(trigger.getKey(), jedis);
                    this.signaler.signalSchedulingChange(0L);
                }
            } else if (triggerInstCode == Trigger.CompletedExecutionInstruction.SET_TRIGGER_COMPLETE) {
                this.setTriggerState(RedisTriggerState.COMPLETED, System.currentTimeMillis(), triggerHashKey, jedis);
                this.signaler.signalSchedulingChange(0L);
            } else if (triggerInstCode == Trigger.CompletedExecutionInstruction.SET_TRIGGER_ERROR) {
                logger.debug(String.format("Trigger %s set to ERROR state.", triggerHashKey));
                double score = trigger.getNextFireTime() != null ? (double)trigger.getNextFireTime().getTime() : 0.0;
                this.setTriggerState(RedisTriggerState.ERROR, score, triggerHashKey, jedis);
                this.signaler.signalSchedulingChange(0L);
            } else if (triggerInstCode == Trigger.CompletedExecutionInstruction.SET_ALL_JOB_TRIGGERS_ERROR) {
                String jobTriggersSetKey = this.redisSchema.jobTriggersSetKey(jobDetail.getKey());
                for (String errorTriggerHashKey : jedis.smembers(jobTriggersSetKey)) {
                    String nextFireTime = jedis.hget(errorTriggerHashKey, "nextFireTime");
                    double score = this.isNullOrEmpty(nextFireTime) ? 0.0 : Double.parseDouble(nextFireTime);
                    this.setTriggerState(RedisTriggerState.ERROR, score, errorTriggerHashKey, jedis);
                }
                this.signaler.signalSchedulingChange(0L);
            } else if (triggerInstCode == Trigger.CompletedExecutionInstruction.SET_ALL_JOB_TRIGGERS_COMPLETE) {
                String jobTriggerSetKey = this.redisSchema.jobTriggersSetKey(jobDetail.getKey());
                for (String completedTriggerHashKey : jedis.smembers(jobTriggerSetKey)) {
                    this.setTriggerState(RedisTriggerState.COMPLETED, System.currentTimeMillis(), completedTriggerHashKey, jedis);
                }
                this.signaler.signalSchedulingChange(0L);
            }
        }
    }
}

