/*
 * Decompiled with CFR 0.152.
 */
package net.joelinn.quartz.jobstore;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.joelinn.quartz.jobstore.AbstractRedisStorage;
import net.joelinn.quartz.jobstore.RedisClusterStorage;
import net.joelinn.quartz.jobstore.RedisJobStoreSchema;
import net.joelinn.quartz.jobstore.RedisStorage;
import net.joelinn.quartz.jobstore.mixin.CronTriggerMixin;
import net.joelinn.quartz.jobstore.mixin.HolidayCalendarMixin;
import net.joelinn.quartz.jobstore.mixin.JobDetailMixin;
import net.joelinn.quartz.jobstore.mixin.TriggerMixin;
import org.quartz.Calendar;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobPersistenceException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.SchedulerConfigException;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.calendar.HolidayCalendar;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.JobStore;
import org.quartz.spi.OperableTrigger;
import org.quartz.spi.SchedulerSignaler;
import org.quartz.spi.TriggerFiredResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisCommands;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.util.Pool;

public class RedisJobStore
implements JobStore {
    private static final Logger logger = LoggerFactory.getLogger(RedisJobStore.class);
    private Pool<Jedis> jedisPool;
    private JedisCluster jedisCluster;
    protected int lockTimeout = 30000;
    protected String host;
    protected int port = 6379;
    protected String password;
    protected short database = 0;
    protected String masterGroupName;
    protected String keyPrefix = "";
    protected String keyDelimiter = ":";
    private boolean redisCluster;
    private boolean redisSentinel;
    private int misfireThreshold = 60000;
    protected String instanceId;
    protected AbstractRedisStorage storage;

    public RedisJobStore setJedisPool(Pool<Jedis> jedisPool) {
        this.jedisPool = jedisPool;
        return this;
    }

    public RedisJobStore setJedisCluster(JedisCluster jedisCluster) {
        this.jedisCluster = jedisCluster;
        return this;
    }

    public void setMisfireThreshold(int misfireThreshold) {
        this.misfireThreshold = misfireThreshold;
    }

    @Override
    public void initialize(ClassLoadHelper loadHelper, SchedulerSignaler signaler) throws SchedulerConfigException {
        RedisJobStoreSchema redisSchema = new RedisJobStoreSchema(this.keyPrefix, this.keyDelimiter);
        ObjectMapper mapper = new ObjectMapper().addMixIn(CronTrigger.class, CronTriggerMixin.class).addMixIn(SimpleTrigger.class, TriggerMixin.class).addMixIn(JobDetail.class, JobDetailMixin.class).addMixIn(HolidayCalendar.class, HolidayCalendarMixin.class).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        if (this.redisCluster && this.jedisCluster == null) {
            Set<HostAndPort> nodes = this.buildNodesSetFromHost();
            this.jedisCluster = new JedisCluster(nodes);
            this.storage = new RedisClusterStorage(redisSchema, mapper, signaler, this.instanceId, this.lockTimeout);
        } else if (this.jedisPool == null) {
            JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
            jedisPoolConfig.setTestOnBorrow(true);
            if (this.redisSentinel) {
                Set<HostAndPort> nodes = this.buildNodesSetFromHost();
                HashSet<String> nodesAsStrings = new HashSet<String>();
                for (HostAndPort node : nodes) {
                    nodesAsStrings.add(node.toString());
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Instantiating JedisSentinelPool using master " + this.masterGroupName + " and hosts " + this.host);
                }
                this.jedisPool = new JedisSentinelPool(this.masterGroupName, nodesAsStrings, jedisPoolConfig, 2000, this.password, this.database);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("Instantiating JedisPool using host " + this.host + " and port " + this.port);
                }
                this.jedisPool = new JedisPool(jedisPoolConfig, this.host, this.port, 2000, this.password, this.database);
            }
            this.storage = new RedisStorage(redisSchema, mapper, signaler, this.instanceId, this.lockTimeout);
        }
        this.storage.setMisfireThreshold(this.misfireThreshold);
    }

    @Override
    public void schedulerStarted() throws SchedulerException {
    }

    @Override
    public void schedulerPaused() {
    }

    @Override
    public void schedulerResumed() {
    }

    @Override
    public void shutdown() {
        if (this.jedisPool != null) {
            this.jedisPool.destroy();
        }
    }

    @Override
    public boolean supportsPersistence() {
        return true;
    }

    @Override
    public long getEstimatedTimeToReleaseAndAcquireTrigger() {
        return 100L;
    }

    @Override
    public boolean isClustered() {
        return true;
    }

    @Override
    public void storeJobAndTrigger(final JobDetail newJob, final OperableTrigger newTrigger) throws ObjectAlreadyExistsException, JobPersistenceException {
        try {
            this.doWithLock(new LockCallbackWithoutResult(){

                @Override
                public Void doWithLock(JedisCommands jedis) throws JobPersistenceException {
                    RedisJobStore.this.storage.storeJob(newJob, false, jedis);
                    RedisJobStore.this.storage.storeTrigger(newTrigger, false, jedis);
                    return null;
                }
            });
        }
        catch (ObjectAlreadyExistsException e) {
            logger.info("Job and / or trigger already exist in storage.", e);
            throw e;
        }
        catch (Exception e) {
            logger.error("Could not store job.", e);
            throw new JobPersistenceException(e.getMessage(), e);
        }
    }

    @Override
    public void storeJob(final JobDetail newJob, final boolean replaceExisting) throws ObjectAlreadyExistsException, JobPersistenceException {
        try {
            this.doWithLock(new LockCallbackWithoutResult(){

                @Override
                public Void doWithLock(JedisCommands jedis) throws JobPersistenceException {
                    RedisJobStore.this.storage.storeJob(newJob, replaceExisting, jedis);
                    return null;
                }
            });
        }
        catch (ObjectAlreadyExistsException e) {
            logger.info("Job hash already exists");
            throw e;
        }
        catch (Exception e) {
            logger.error("Could not store job.", e);
            throw new JobPersistenceException(e.getMessage(), e);
        }
    }

    @Override
    public void storeJobsAndTriggers(final Map<JobDetail, Set<? extends Trigger>> triggersAndJobs, final boolean replace) throws ObjectAlreadyExistsException, JobPersistenceException {
        this.doWithLock(new LockCallbackWithoutResult(){

            @Override
            public Void doWithLock(JedisCommands jedis) throws JobPersistenceException {
                for (Map.Entry entry : triggersAndJobs.entrySet()) {
                    RedisJobStore.this.storage.storeJob((JobDetail)entry.getKey(), replace, jedis);
                    for (Trigger trigger : (Set)entry.getValue()) {
                        RedisJobStore.this.storage.storeTrigger((OperableTrigger)trigger, replace, jedis);
                    }
                }
                return null;
            }
        }, "Could not store jobs and triggers.");
    }

    @Override
    public boolean removeJob(final JobKey jobKey) throws JobPersistenceException {
        return this.doWithLock(new LockCallback<Boolean>(){

            @Override
            public Boolean doWithLock(JedisCommands jedis) throws JobPersistenceException {
                return RedisJobStore.this.storage.removeJob(jobKey, jedis);
            }
        }, "Could not remove job.");
    }

    @Override
    public boolean removeJobs(final List<JobKey> jobKeys) throws JobPersistenceException {
        return this.doWithLock(new LockCallback<Boolean>(){

            @Override
            public Boolean doWithLock(JedisCommands jedis) throws JobPersistenceException {
                boolean removed = jobKeys.size() > 0;
                for (JobKey jobKey : jobKeys) {
                    removed = RedisJobStore.this.storage.removeJob(jobKey, jedis) && removed;
                }
                return removed;
            }
        }, "Could not remove jobs.");
    }

    @Override
    public JobDetail retrieveJob(final JobKey jobKey) throws JobPersistenceException {
        return this.doWithLock(new LockCallback<JobDetail>(){

            @Override
            public JobDetail doWithLock(JedisCommands jedis) throws JobPersistenceException {
                try {
                    return RedisJobStore.this.storage.retrieveJob(jobKey, jedis);
                }
                catch (ClassNotFoundException e) {
                    throw new JobPersistenceException("Error retrieving job: " + e.getMessage(), e);
                }
            }
        }, "Could not retrieve job.");
    }

    @Override
    public void storeTrigger(final OperableTrigger newTrigger, final boolean replaceExisting) throws ObjectAlreadyExistsException, JobPersistenceException {
        this.doWithLock(new LockCallbackWithoutResult(){

            @Override
            public Void doWithLock(JedisCommands jedis) throws JobPersistenceException {
                RedisJobStore.this.storage.storeTrigger(newTrigger, replaceExisting, jedis);
                return null;
            }
        }, "Could not store trigger.");
    }

    @Override
    public boolean removeTrigger(final TriggerKey triggerKey) throws JobPersistenceException {
        return this.doWithLock(new LockCallback<Boolean>(){

            @Override
            public Boolean doWithLock(JedisCommands jedis) throws JobPersistenceException {
                try {
                    return RedisJobStore.this.storage.removeTrigger(triggerKey, jedis);
                }
                catch (ClassNotFoundException e) {
                    throw new JobPersistenceException("Error removing trigger: " + e.getMessage(), e);
                }
            }
        }, "Could not remove trigger.");
    }

    @Override
    public boolean removeTriggers(final List<TriggerKey> triggerKeys) throws JobPersistenceException {
        return this.doWithLock(new LockCallback<Boolean>(){

            @Override
            public Boolean doWithLock(JedisCommands jedis) throws JobPersistenceException {
                boolean removed = triggerKeys.size() > 0;
                for (TriggerKey triggerKey : triggerKeys) {
                    try {
                        removed = RedisJobStore.this.storage.removeTrigger(triggerKey, jedis) && removed;
                    }
                    catch (ClassNotFoundException e) {
                        throw new JobPersistenceException(e.getMessage(), e);
                    }
                }
                return removed;
            }
        }, "Could not remove trigger.");
    }

    @Override
    public boolean replaceTrigger(final TriggerKey triggerKey, final OperableTrigger newTrigger) throws JobPersistenceException {
        return this.doWithLock(new LockCallback<Boolean>(){

            @Override
            public Boolean doWithLock(JedisCommands jedis) throws JobPersistenceException {
                try {
                    return RedisJobStore.this.storage.replaceTrigger(triggerKey, newTrigger, jedis);
                }
                catch (ClassNotFoundException e) {
                    throw new JobPersistenceException(e.getMessage(), e);
                }
            }
        }, "Could not remove trigger.");
    }

    @Override
    public OperableTrigger retrieveTrigger(final TriggerKey triggerKey) throws JobPersistenceException {
        return this.doWithLock(new LockCallback<OperableTrigger>(){

            @Override
            public OperableTrigger doWithLock(JedisCommands jedis) throws JobPersistenceException {
                return RedisJobStore.this.storage.retrieveTrigger(triggerKey, jedis);
            }
        }, "Could not retrieve trigger.");
    }

    @Override
    public boolean checkExists(final JobKey jobKey) throws JobPersistenceException {
        return this.doWithLock(new LockCallback<Boolean>(){

            @Override
            public Boolean doWithLock(JedisCommands jedis) throws JobPersistenceException {
                return RedisJobStore.this.storage.checkExists(jobKey, jedis);
            }
        }, "Could not check if job exists: " + jobKey);
    }

    @Override
    public boolean checkExists(final TriggerKey triggerKey) throws JobPersistenceException {
        return this.doWithLock(new LockCallback<Boolean>(){

            @Override
            public Boolean doWithLock(JedisCommands jedis) throws JobPersistenceException {
                return RedisJobStore.this.storage.checkExists(triggerKey, jedis);
            }
        }, "Could not check if trigger exists: " + triggerKey);
    }

    @Override
    public void clearAllSchedulingData() throws JobPersistenceException {
        this.doWithLock(new LockCallbackWithoutResult(){

            @Override
            public Void doWithLock(JedisCommands jedis) throws JobPersistenceException {
                try {
                    RedisJobStore.this.storage.clearAllSchedulingData(jedis);
                }
                catch (ClassNotFoundException e) {
                    throw new JobPersistenceException("Could not clear scheduling data.");
                }
                return null;
            }
        }, "Could not clear scheduling data.");
    }

    @Override
    public void storeCalendar(final String name, final Calendar calendar, final boolean replaceExisting, final boolean updateTriggers) throws ObjectAlreadyExistsException, JobPersistenceException {
        this.doWithLock(new LockCallbackWithoutResult(){

            @Override
            public Void doWithLock(JedisCommands jedis) throws JobPersistenceException {
                RedisJobStore.this.storage.storeCalendar(name, calendar, replaceExisting, updateTriggers, jedis);
                return null;
            }
        }, "Could not store calendar.");
    }

    @Override
    public boolean removeCalendar(final String calName) throws JobPersistenceException {
        return this.doWithLock(new LockCallback<Boolean>(){

            @Override
            public Boolean doWithLock(JedisCommands jedis) throws JobPersistenceException {
                return RedisJobStore.this.storage.removeCalendar(calName, jedis);
            }
        }, "Could not remove calendar.");
    }

    @Override
    public Calendar retrieveCalendar(final String calName) throws JobPersistenceException {
        return this.doWithLock(new LockCallback<Calendar>(){

            @Override
            public Calendar doWithLock(JedisCommands jedis) throws JobPersistenceException {
                return RedisJobStore.this.storage.retrieveCalendar(calName, jedis);
            }
        }, "Could not retrieve calendar.");
    }

    @Override
    public int getNumberOfJobs() throws JobPersistenceException {
        return this.doWithLock(new LockCallback<Integer>(){

            @Override
            public Integer doWithLock(JedisCommands jedis) throws JobPersistenceException {
                return RedisJobStore.this.storage.getNumberOfJobs(jedis);
            }
        }, "Could not get number of jobs.");
    }

    @Override
    public int getNumberOfTriggers() throws JobPersistenceException {
        return this.doWithLock(new LockCallback<Integer>(){

            @Override
            public Integer doWithLock(JedisCommands jedis) throws JobPersistenceException {
                return RedisJobStore.this.storage.getNumberOfTriggers(jedis);
            }
        }, "Could not get number of jobs.");
    }

    @Override
    public int getNumberOfCalendars() throws JobPersistenceException {
        return this.doWithLock(new LockCallback<Integer>(){

            @Override
            public Integer doWithLock(JedisCommands jedis) throws JobPersistenceException {
                return RedisJobStore.this.storage.getNumberOfCalendars(jedis);
            }
        }, "Could not get number of jobs.");
    }

    @Override
    public Set<JobKey> getJobKeys(final GroupMatcher<JobKey> matcher) throws JobPersistenceException {
        return this.doWithLock(new LockCallback<Set<JobKey>>(){

            @Override
            public Set<JobKey> doWithLock(JedisCommands jedis) throws JobPersistenceException {
                return RedisJobStore.this.storage.getJobKeys(matcher, jedis);
            }
        }, "Could not retrieve JobKeys.");
    }

    @Override
    public Set<TriggerKey> getTriggerKeys(final GroupMatcher<TriggerKey> matcher) throws JobPersistenceException {
        return this.doWithLock(new LockCallback<Set<TriggerKey>>(){

            @Override
            public Set<TriggerKey> doWithLock(JedisCommands jedis) throws JobPersistenceException {
                return RedisJobStore.this.storage.getTriggerKeys(matcher, jedis);
            }
        }, "Could not retrieve TriggerKeys.");
    }

    @Override
    public List<String> getJobGroupNames() throws JobPersistenceException {
        return this.doWithLock(new LockCallback<List<String>>(){

            @Override
            public List<String> doWithLock(JedisCommands jedis) throws JobPersistenceException {
                return RedisJobStore.this.storage.getJobGroupNames(jedis);
            }
        }, "Could not retrieve job group names.");
    }

    @Override
    public List<String> getTriggerGroupNames() throws JobPersistenceException {
        return this.doWithLock(new LockCallback<List<String>>(){

            @Override
            public List<String> doWithLock(JedisCommands jedis) throws JobPersistenceException {
                return RedisJobStore.this.storage.getTriggerGroupNames(jedis);
            }
        }, "Could not retrieve trigger group names.");
    }

    @Override
    public List<String> getCalendarNames() throws JobPersistenceException {
        return this.doWithLock(new LockCallback<List<String>>(){

            @Override
            public List<String> doWithLock(JedisCommands jedis) throws JobPersistenceException {
                return RedisJobStore.this.storage.getCalendarNames(jedis);
            }
        }, "Could not retrieve calendar names.");
    }

    @Override
    public List<OperableTrigger> getTriggersForJob(final JobKey jobKey) throws JobPersistenceException {
        return this.doWithLock(new LockCallback<List<OperableTrigger>>(){

            @Override
            public List<OperableTrigger> doWithLock(JedisCommands jedis) throws JobPersistenceException {
                return RedisJobStore.this.storage.getTriggersForJob(jobKey, jedis);
            }
        }, "Could not retrieve triggers for job.");
    }

    @Override
    public Trigger.TriggerState getTriggerState(final TriggerKey triggerKey) throws JobPersistenceException {
        return this.doWithLock(new LockCallback<Trigger.TriggerState>(){

            @Override
            public Trigger.TriggerState doWithLock(JedisCommands jedis) throws JobPersistenceException {
                return RedisJobStore.this.storage.getTriggerState(triggerKey, jedis);
            }
        }, "Could not retrieve trigger state.");
    }

    @Override
    public void pauseTrigger(final TriggerKey triggerKey) throws JobPersistenceException {
        this.doWithLock(new LockCallbackWithoutResult(){

            @Override
            public Void doWithLock(JedisCommands jedis) throws JobPersistenceException {
                RedisJobStore.this.storage.pauseTrigger(triggerKey, jedis);
                return null;
            }
        }, "Could not pause trigger.");
    }

    @Override
    public Collection<String> pauseTriggers(final GroupMatcher<TriggerKey> matcher) throws JobPersistenceException {
        return this.doWithLock(new LockCallback<Collection<String>>(){

            @Override
            public Collection<String> doWithLock(JedisCommands jedis) throws JobPersistenceException {
                return RedisJobStore.this.storage.pauseTriggers(matcher, jedis);
            }
        }, "Could not pause triggers.");
    }

    @Override
    public void pauseJob(final JobKey jobKey) throws JobPersistenceException {
        this.doWithLock(new LockCallbackWithoutResult(){

            @Override
            public Void doWithLock(JedisCommands jedis) throws JobPersistenceException {
                RedisJobStore.this.storage.pauseJob(jobKey, jedis);
                return null;
            }
        }, "Could not pause job.");
    }

    @Override
    public Collection<String> pauseJobs(final GroupMatcher<JobKey> groupMatcher) throws JobPersistenceException {
        return this.doWithLock(new LockCallback<Collection<String>>(){

            @Override
            public Collection<String> doWithLock(JedisCommands jedis) throws JobPersistenceException {
                return RedisJobStore.this.storage.pauseJobs(groupMatcher, jedis);
            }
        }, "Could not pause jobs.");
    }

    @Override
    public void resumeTrigger(final TriggerKey triggerKey) throws JobPersistenceException {
        this.doWithLock(new LockCallbackWithoutResult(){

            @Override
            public Void doWithLock(JedisCommands jedis) throws JobPersistenceException {
                RedisJobStore.this.storage.resumeTrigger(triggerKey, jedis);
                return null;
            }
        }, "Could not resume trigger.");
    }

    @Override
    public Collection<String> resumeTriggers(final GroupMatcher<TriggerKey> matcher) throws JobPersistenceException {
        return this.doWithLock(new LockCallback<Collection<String>>(){

            @Override
            public Collection<String> doWithLock(JedisCommands jedis) throws JobPersistenceException {
                return RedisJobStore.this.storage.resumeTriggers(matcher, jedis);
            }
        }, "Could not resume trigger group(s).");
    }

    @Override
    public Set<String> getPausedTriggerGroups() throws JobPersistenceException {
        return this.doWithLock(new LockCallback<Set<String>>(){

            @Override
            public Set<String> doWithLock(JedisCommands jedis) throws JobPersistenceException {
                return RedisJobStore.this.storage.getPausedTriggerGroups(jedis);
            }
        }, "Could not retrieve paused trigger groups.");
    }

    @Override
    public void resumeJob(final JobKey jobKey) throws JobPersistenceException {
        this.doWithLock(new LockCallbackWithoutResult(){

            @Override
            public Void doWithLock(JedisCommands jedis) throws JobPersistenceException {
                RedisJobStore.this.storage.resumeJob(jobKey, jedis);
                return null;
            }
        }, "Could not resume job.");
    }

    @Override
    public Collection<String> resumeJobs(final GroupMatcher<JobKey> matcher) throws JobPersistenceException {
        return this.doWithLock(new LockCallback<Collection<String>>(){

            @Override
            public Collection<String> doWithLock(JedisCommands jedis) throws JobPersistenceException {
                return RedisJobStore.this.storage.resumeJobs(matcher, jedis);
            }
        }, "Could not resume jobs.");
    }

    @Override
    public void pauseAll() throws JobPersistenceException {
        this.doWithLock(new LockCallbackWithoutResult(){

            @Override
            public Void doWithLock(JedisCommands jedis) throws JobPersistenceException {
                RedisJobStore.this.storage.pauseAll(jedis);
                return null;
            }
        }, "Could not pause all triggers.");
    }

    @Override
    public void resumeAll() throws JobPersistenceException {
        this.doWithLock(new LockCallbackWithoutResult(){

            @Override
            public Void doWithLock(JedisCommands jedis) throws JobPersistenceException {
                RedisJobStore.this.storage.resumeAll(jedis);
                return null;
            }
        }, "Could not resume all triggers.");
    }

    @Override
    public List<OperableTrigger> acquireNextTriggers(final long noLaterThan, final int maxCount, final long timeWindow) throws JobPersistenceException {
        return this.doWithLock(new LockCallback<List<OperableTrigger>>(){

            @Override
            public List<OperableTrigger> doWithLock(JedisCommands jedis) throws JobPersistenceException {
                try {
                    return RedisJobStore.this.storage.acquireNextTriggers(noLaterThan, maxCount, timeWindow, jedis);
                }
                catch (ClassNotFoundException e) {
                    throw new JobPersistenceException(e.getMessage(), e);
                }
            }
        }, "Could not acquire next triggers.");
    }

    @Override
    public void releaseAcquiredTrigger(final OperableTrigger trigger) {
        try {
            this.doWithLock(new LockCallbackWithoutResult(){

                @Override
                public Void doWithLock(JedisCommands jedis) throws JobPersistenceException {
                    RedisJobStore.this.storage.releaseAcquiredTrigger(trigger, jedis);
                    return null;
                }
            }, "Could not release acquired trigger.");
        }
        catch (JobPersistenceException e) {
            logger.error("Could not release acquired trigger.", e);
        }
    }

    @Override
    public List<TriggerFiredResult> triggersFired(final List<OperableTrigger> triggers) throws JobPersistenceException {
        return this.doWithLock(new LockCallback<List<TriggerFiredResult>>(){

            @Override
            public List<TriggerFiredResult> doWithLock(JedisCommands jedis) throws JobPersistenceException {
                try {
                    return RedisJobStore.this.storage.triggersFired(triggers, jedis);
                }
                catch (ClassNotFoundException e) {
                    throw new JobPersistenceException(e.getMessage(), e);
                }
            }
        }, "Could not set triggers as fired.");
    }

    @Override
    public void triggeredJobComplete(final OperableTrigger trigger, final JobDetail jobDetail, final Trigger.CompletedExecutionInstruction triggerInstCode) {
        try {
            this.doWithLock(new LockCallbackWithoutResult(){

                @Override
                public Void doWithLock(JedisCommands jedis) throws JobPersistenceException {
                    try {
                        RedisJobStore.this.storage.triggeredJobComplete(trigger, jobDetail, triggerInstCode, jedis);
                    }
                    catch (ClassNotFoundException e) {
                        logger.error("Could not handle job completion.", e);
                    }
                    return null;
                }
            });
        }
        catch (JobPersistenceException e) {
            logger.error("Could not handle job completion.", e);
        }
    }

    private <T> T doWithLock(LockCallback<T> callback) throws JobPersistenceException {
        return this.doWithLock(callback, null);
    }

    /*
     * Exception decompiling
     */
    private <T> T doWithLock(LockCallback<T> callback, String errorMessage) throws JobPersistenceException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private JedisCommands getResource() throws JobPersistenceException {
        if (this.jedisCluster != null) {
            return this.jedisCluster;
        }
        return this.jedisPool.getResource();
    }

    public void setLockTimeout(int lockTimeout) {
        this.lockTimeout = lockTimeout;
    }

    public void setLockTimeout(String lockTimeout) {
        this.setLockTimeout(Integer.valueOf(lockTimeout));
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setPort(String port) {
        this.setPort(Integer.valueOf(port));
    }

    public void setDatabase(int database) {
        this.database = (short)database;
    }

    public void setDatabase(String database) {
        this.setDatabase(Short.valueOf(database).shortValue());
    }

    public void setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }

    public void setKeyDelimiter(String keyDelimiter) {
        this.keyDelimiter = keyDelimiter;
    }

    public void setRedisCluster(boolean clustered) {
        this.redisCluster = clustered;
    }

    public void setRedisSentinel(boolean sentinel) {
        this.redisSentinel = sentinel;
    }

    public void setMasterGroupName(String masterGroupName) {
        this.masterGroupName = masterGroupName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public void setInstanceId(String schedInstId) {
        this.instanceId = schedInstId;
    }

    @Override
    public void setInstanceName(String schedName) {
    }

    @Override
    public void setThreadPoolSize(int poolSize) {
    }

    private Set<HostAndPort> buildNodesSetFromHost() {
        HashSet<HostAndPort> nodes = new HashSet<HostAndPort>();
        for (String hostName : this.host.split(",")) {
            int hostPort = this.port;
            if (hostName.contains(":")) {
                String[] parts = hostName.split(":");
                hostName = parts[0];
                hostPort = Integer.valueOf(parts[1]);
            }
            nodes.add(new HostAndPort(hostName, hostPort));
        }
        return nodes;
    }

    private abstract class LockCallbackWithoutResult
    implements LockCallback<Void> {
        private LockCallbackWithoutResult() {
        }
    }

    private static interface LockCallback<T> {
        public T doWithLock(JedisCommands var1) throws JobPersistenceException;
    }
}

