/*
 * Decompiled with CFR 0.152.
 */
package net.joelinn.quartz.jobstore;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.joelinn.quartz.jobstore.RedisJobStoreSchema;
import net.joelinn.quartz.jobstore.RedisStorage;
import net.joelinn.quartz.jobstore.mixin.CronTriggerMixin;
import net.joelinn.quartz.jobstore.mixin.JobDetailMixin;
import net.joelinn.quartz.jobstore.mixin.TriggerMixin;
import org.quartz.Calendar;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobPersistenceException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.SchedulerConfigException;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.JobStore;
import org.quartz.spi.OperableTrigger;
import org.quartz.spi.SchedulerSignaler;
import org.quartz.spi.TriggerFiredResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.exceptions.JedisConnectionException;

public class RedisJobStore
implements JobStore {
    private static final Logger logger = LoggerFactory.getLogger(RedisJobStore.class);
    protected static JedisPool jedisPool;
    protected int lockTimeout = 30000;
    protected String host;
    protected int port = 6379;
    protected short database = 0;
    protected String keyPrefix = "";
    protected String keyDelimiter = ":";
    protected String instanceId;
    protected RedisStorage storage;

    @Override
    public void initialize(ClassLoadHelper loadHelper, SchedulerSignaler signaler) throws SchedulerConfigException {
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        jedisPool = new JedisPool(jedisPoolConfig, this.host, this.port, 2000, null, this.database);
        RedisJobStoreSchema redisSchema = new RedisJobStoreSchema(this.keyPrefix, this.keyDelimiter);
        ObjectMapper mapper = new ObjectMapper();
        mapper.addMixInAnnotations(CronTrigger.class, CronTriggerMixin.class);
        mapper.addMixInAnnotations(SimpleTrigger.class, TriggerMixin.class);
        mapper.addMixInAnnotations(JobDetail.class, JobDetailMixin.class);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.storage = new RedisStorage(redisSchema, mapper, signaler, this.instanceId, this.lockTimeout);
    }

    @Override
    public void schedulerStarted() throws SchedulerException {
    }

    @Override
    public void schedulerPaused() {
    }

    @Override
    public void schedulerResumed() {
    }

    @Override
    public void shutdown() {
        if (jedisPool != null) {
            jedisPool.destroy();
        }
    }

    @Override
    public boolean supportsPersistence() {
        return true;
    }

    @Override
    public long getEstimatedTimeToReleaseAndAcquireTrigger() {
        return 100L;
    }

    @Override
    public boolean isClustered() {
        return true;
    }

    @Override
    public void storeJobAndTrigger(JobDetail newJob, OperableTrigger newTrigger) throws ObjectAlreadyExistsException, JobPersistenceException {
        Jedis jedis = jedisPool.getResource();
        try {
            this.storage.waitForLock(jedis);
            this.storage.storeJob(newJob, false, jedis);
            this.storage.storeTrigger(newTrigger, false, jedis);
        }
        catch (ObjectAlreadyExistsException e) {
            logger.info("Job and / or trigger already exist in storage.", e);
            throw e;
        }
        catch (Exception e) {
            logger.error("Could not store job.", e);
            throw new JobPersistenceException(e.getMessage(), e);
        }
        finally {
            this.storage.unlock(jedis);
            jedisPool.returnResource(jedis);
        }
    }

    @Override
    public void storeJob(JobDetail newJob, boolean replaceExisting) throws ObjectAlreadyExistsException, JobPersistenceException {
        Jedis jedis = jedisPool.getResource();
        try {
            this.storage.waitForLock(jedis);
            this.storage.storeJob(newJob, replaceExisting, jedis);
        }
        catch (ObjectAlreadyExistsException e) {
            logger.info("Job hash already exists");
            throw e;
        }
        catch (Exception e) {
            logger.error("Could not store job.", e);
            throw new JobPersistenceException(e.getMessage(), e);
        }
        finally {
            this.storage.unlock(jedis);
            jedisPool.returnResource(jedis);
        }
    }

    @Override
    public void storeJobsAndTriggers(Map<JobDetail, Set<? extends Trigger>> triggersAndJobs, boolean replace) throws ObjectAlreadyExistsException, JobPersistenceException {
        Jedis jedis = jedisPool.getResource();
        try {
            this.storage.waitForLock(jedis);
            for (Map.Entry<JobDetail, Set<? extends Trigger>> entry : triggersAndJobs.entrySet()) {
                this.storage.storeJob(entry.getKey(), replace, jedis);
                for (Trigger trigger : entry.getValue()) {
                    this.storage.storeTrigger((OperableTrigger)trigger, replace, jedis);
                }
            }
        }
        catch (Exception e) {
            logger.error("Could not store jobs and triggers.", e);
            throw new JobPersistenceException(e.getMessage(), e);
        }
        finally {
            this.storage.unlock(jedis);
            jedisPool.returnResource(jedis);
        }
    }

    @Override
    public boolean removeJob(JobKey jobKey) throws JobPersistenceException {
        Jedis jedis = jedisPool.getResource();
        try {
            this.storage.waitForLock(jedis);
            boolean bl = this.storage.removeJob(jobKey, jedis);
            return bl;
        }
        catch (Exception e) {
            logger.error("Could not remove job.", e);
            throw new JobPersistenceException(e.getMessage(), e);
        }
        finally {
            this.storage.unlock(jedis);
            jedisPool.returnResource(jedis);
        }
    }

    @Override
    public boolean removeJobs(List<JobKey> jobKeys) throws JobPersistenceException {
        Jedis jedis = jedisPool.getResource();
        try {
            this.storage.waitForLock(jedis);
            boolean removed = jobKeys.size() > 0;
            for (JobKey jobKey : jobKeys) {
                removed = this.storage.removeJob(jobKey, jedis) && removed;
            }
            boolean bl = removed;
            return bl;
        }
        catch (Exception e) {
            logger.error("Could not remove jobs.", e);
            throw new JobPersistenceException(e.getMessage(), e);
        }
        finally {
            this.storage.unlock(jedis);
            jedisPool.returnResource(jedis);
        }
    }

    @Override
    public JobDetail retrieveJob(JobKey jobKey) throws JobPersistenceException {
        Jedis jedis = jedisPool.getResource();
        JobDetail jobDetail = null;
        try {
            this.storage.waitForLock(jedis);
            jobDetail = this.storage.retrieveJob(jobKey, jedis);
        }
        catch (Exception e) {
            logger.error("Could not retrieve job.", e);
            throw new JobPersistenceException(e.getMessage(), e);
        }
        finally {
            this.storage.unlock(jedis);
            jedisPool.returnResource(jedis);
        }
        return jobDetail;
    }

    @Override
    public void storeTrigger(OperableTrigger newTrigger, boolean replaceExisting) throws ObjectAlreadyExistsException, JobPersistenceException {
        Jedis jedis = jedisPool.getResource();
        try {
            this.storage.waitForLock(jedis);
            this.storage.storeTrigger(newTrigger, replaceExisting, jedis);
        }
        catch (ObjectAlreadyExistsException e) {
            logger.info("Attempted to store a trigger which already exists.");
            throw e;
        }
        catch (Exception e) {
            logger.error("Could not store trigger.", e);
            throw new JobPersistenceException(e.getMessage(), e);
        }
        finally {
            this.storage.unlock(jedis);
            jedisPool.returnResource(jedis);
        }
    }

    @Override
    public boolean removeTrigger(TriggerKey triggerKey) throws JobPersistenceException {
        Jedis jedis = jedisPool.getResource();
        boolean removed = false;
        try {
            this.storage.waitForLock(jedis);
            removed = this.storage.removeTrigger(triggerKey, jedis);
        }
        catch (Exception e) {
            logger.error("Could not remove trigger.", e);
            throw new JobPersistenceException(e.getMessage(), e);
        }
        finally {
            this.storage.unlock(jedis);
            jedisPool.returnResource(jedis);
        }
        return removed;
    }

    @Override
    public boolean removeTriggers(List<TriggerKey> triggerKeys) throws JobPersistenceException {
        Jedis jedis = jedisPool.getResource();
        boolean removed = triggerKeys.size() > 0;
        try {
            this.storage.waitForLock(jedis);
            for (TriggerKey triggerKey : triggerKeys) {
                removed = this.storage.removeTrigger(triggerKey, jedis) && removed;
            }
        }
        catch (Exception e) {
            logger.error("Could not remove trigger.", e);
            throw new JobPersistenceException(e.getMessage(), e);
        }
        finally {
            this.storage.unlock(jedis);
            jedisPool.returnResource(jedis);
        }
        return removed;
    }

    @Override
    public boolean replaceTrigger(TriggerKey triggerKey, OperableTrigger newTrigger) throws JobPersistenceException {
        Jedis jedis = jedisPool.getResource();
        try {
            this.storage.waitForLock(jedis);
            boolean bl = this.storage.replaceTrigger(triggerKey, newTrigger, jedis);
            return bl;
        }
        catch (Exception e) {
            logger.error("Could not remove trigger.", e);
            throw new JobPersistenceException(e.getMessage(), e);
        }
        finally {
            this.storage.unlock(jedis);
            jedisPool.returnResource(jedis);
        }
    }

    @Override
    public OperableTrigger retrieveTrigger(TriggerKey triggerKey) throws JobPersistenceException {
        OperableTrigger trigger = null;
        Jedis jedis = jedisPool.getResource();
        try {
            this.storage.waitForLock(jedis);
            trigger = this.storage.retrieveTrigger(triggerKey, jedis);
        }
        catch (Exception e) {
            logger.error("Could not retrieve trigger.", e);
            throw new JobPersistenceException(e.getMessage(), e);
        }
        finally {
            this.storage.unlock(jedis);
            jedisPool.returnResource(jedis);
        }
        return trigger;
    }

    @Override
    public boolean checkExists(JobKey jobKey) throws JobPersistenceException {
        Jedis jedis = jedisPool.getResource();
        try {
            boolean exists = this.storage.checkExists(jobKey, jedis);
            jedisPool.returnResource(jedis);
            return exists;
        }
        catch (JedisConnectionException e) {
            logger.error("Redis connection error.", e);
            jedisPool.returnBrokenResource(jedis);
            throw new JobPersistenceException(e.getMessage(), e);
        }
        catch (Exception e) {
            logger.error("Could not check if job exists.", e);
            jedisPool.returnResource(jedis);
            throw new JobPersistenceException(e.getMessage(), e);
        }
    }

    @Override
    public boolean checkExists(TriggerKey triggerKey) throws JobPersistenceException {
        Jedis jedis = jedisPool.getResource();
        try {
            boolean exists = this.storage.checkExists(triggerKey, jedis);
            jedisPool.returnResource(jedis);
            return exists;
        }
        catch (JedisConnectionException e) {
            logger.error("Redis connection error.", e);
            jedisPool.returnBrokenResource(jedis);
            throw new JobPersistenceException(e.getMessage(), e);
        }
        catch (Exception e) {
            logger.error("Could not check if trigger exists.", e);
            jedisPool.returnResource(jedis);
            throw new JobPersistenceException(e.getMessage(), e);
        }
    }

    @Override
    public void clearAllSchedulingData() throws JobPersistenceException {
        Jedis jedis = jedisPool.getResource();
        try {
            this.storage.waitForLock(jedis);
            this.storage.clearAllSchedulingData(jedis);
        }
        catch (Exception e) {
            logger.error("Could not clear scheduling data.", e);
            throw new JobPersistenceException(e.getMessage(), e);
        }
        finally {
            this.storage.unlock(jedis);
            jedisPool.returnResource(jedis);
        }
    }

    @Override
    public void storeCalendar(String name, Calendar calendar, boolean replaceExisting, boolean updateTriggers) throws ObjectAlreadyExistsException, JobPersistenceException {
        Jedis jedis = jedisPool.getResource();
        try {
            this.storage.waitForLock(jedis);
            this.storage.storeCalendar(name, calendar, replaceExisting, updateTriggers, jedis);
        }
        catch (Exception e) {
            logger.error("Could not store calendar.", e);
            throw new JobPersistenceException(e.getMessage(), e);
        }
        finally {
            this.storage.unlock(jedis);
            jedisPool.returnResource(jedis);
        }
    }

    @Override
    public boolean removeCalendar(String calName) throws JobPersistenceException {
        Jedis jedis = jedisPool.getResource();
        try {
            this.storage.waitForLock(jedis);
            boolean bl = this.storage.removeCalendar(calName, jedis);
            return bl;
        }
        catch (Exception e) {
            logger.error("Could not remove calendar.", e);
            throw new JobPersistenceException(e.getMessage(), e);
        }
        finally {
            this.storage.unlock(jedis);
            jedisPool.returnResource(jedis);
        }
    }

    @Override
    public Calendar retrieveCalendar(String calName) throws JobPersistenceException {
        Calendar calendar = null;
        Jedis jedis = jedisPool.getResource();
        try {
            this.storage.waitForLock(jedis);
            calendar = this.storage.retrieveCalendar(calName, jedis);
        }
        catch (Exception e) {
            logger.error("Could not retrieve calendar.", e);
            throw new JobPersistenceException(e.getMessage(), e);
        }
        finally {
            this.storage.unlock(jedis);
            jedisPool.returnResource(jedis);
        }
        return calendar;
    }

    @Override
    public int getNumberOfJobs() throws JobPersistenceException {
        Jedis jedis = jedisPool.getResource();
        try {
            int numberOfJobs = this.storage.getNumberOfJobs(jedis);
            jedisPool.returnResource(jedis);
            return numberOfJobs;
        }
        catch (JedisConnectionException e) {
            logger.error("Redis connection error.", e);
            jedisPool.returnBrokenResource(jedis);
            throw new JobPersistenceException(e.getMessage(), e);
        }
        catch (Exception e) {
            logger.error("Could not get number of jobs.", e);
            jedisPool.returnResource(jedis);
            throw new JobPersistenceException(e.getMessage(), e);
        }
    }

    @Override
    public int getNumberOfTriggers() throws JobPersistenceException {
        Jedis jedis = jedisPool.getResource();
        try {
            int numberOfJobs = this.storage.getNumberOfTriggers(jedis);
            jedisPool.returnResource(jedis);
            return numberOfJobs;
        }
        catch (JedisConnectionException e) {
            logger.error("Redis connection error.", e);
            jedisPool.returnBrokenResource(jedis);
            throw new JobPersistenceException(e.getMessage(), e);
        }
        catch (Exception e) {
            logger.error("Could not get number of jobs.", e);
            jedisPool.returnResource(jedis);
            throw new JobPersistenceException(e.getMessage(), e);
        }
    }

    @Override
    public int getNumberOfCalendars() throws JobPersistenceException {
        Jedis jedis = jedisPool.getResource();
        try {
            int numberOfJobs = this.storage.getNumberOfCalendars(jedis);
            jedisPool.returnResource(jedis);
            return numberOfJobs;
        }
        catch (JedisConnectionException e) {
            logger.error("Redis connection error.", e);
            jedisPool.returnBrokenResource(jedis);
            throw new JobPersistenceException(e.getMessage(), e);
        }
        catch (Exception e) {
            logger.error("Could not get number of jobs.", e);
            jedisPool.returnResource(jedis);
            throw new JobPersistenceException(e.getMessage(), e);
        }
    }

    @Override
    public Set<JobKey> getJobKeys(GroupMatcher<JobKey> matcher) throws JobPersistenceException {
        Jedis jedis = jedisPool.getResource();
        try {
            this.storage.lock(jedis);
            Set<JobKey> set = this.storage.getJobKeys(matcher, jedis);
            return set;
        }
        catch (JedisConnectionException e) {
            logger.error("Redis connection error.", e);
            throw new JobPersistenceException(e.getMessage(), e);
        }
        catch (Exception e) {
            logger.error("Could not retrieve JobKeys.", e);
            throw new JobPersistenceException(e.getMessage(), e);
        }
        finally {
            this.storage.unlock(jedis);
            jedisPool.returnResource(jedis);
        }
    }

    @Override
    public Set<TriggerKey> getTriggerKeys(GroupMatcher<TriggerKey> matcher) throws JobPersistenceException {
        Jedis jedis = jedisPool.getResource();
        try {
            Set<TriggerKey> triggerKeys = this.storage.getTriggerKeys(matcher, jedis);
            jedisPool.returnResource(jedis);
            return triggerKeys;
        }
        catch (JedisConnectionException e) {
            logger.error("Redis connection error.", e);
            jedisPool.returnBrokenResource(jedis);
            throw new JobPersistenceException(e.getMessage(), e);
        }
        catch (Exception e) {
            logger.error("Could not retrieve TriggerKeys.", e);
            jedisPool.returnResource(jedis);
            throw new JobPersistenceException(e.getMessage(), e);
        }
    }

    @Override
    public List<String> getJobGroupNames() throws JobPersistenceException {
        Jedis jedis = jedisPool.getResource();
        try {
            List<String> jobGroupNames = this.storage.getJobGroupNames(jedis);
            jedisPool.returnResource(jedis);
            return jobGroupNames;
        }
        catch (JedisConnectionException e) {
            logger.error("Redis connection error.", e);
            jedisPool.returnBrokenResource(jedis);
            throw new JobPersistenceException(e.getMessage(), e);
        }
        catch (Exception e) {
            logger.error("Could not retrieve job group names.", e);
            jedisPool.returnResource(jedis);
            throw new JobPersistenceException(e.getMessage(), e);
        }
    }

    @Override
    public List<String> getTriggerGroupNames() throws JobPersistenceException {
        Jedis jedis = jedisPool.getResource();
        try {
            List<String> triggerGroupNames = this.storage.getTriggerGroupNames(jedis);
            jedisPool.returnResource(jedis);
            return triggerGroupNames;
        }
        catch (JedisConnectionException e) {
            logger.error("Redis connection error.", e);
            jedisPool.returnBrokenResource(jedis);
            throw new JobPersistenceException(e.getMessage(), e);
        }
        catch (Exception e) {
            logger.error("Could not retrieve trigger group names.", e);
            jedisPool.returnResource(jedis);
            throw new JobPersistenceException(e.getMessage(), e);
        }
    }

    @Override
    public List<String> getCalendarNames() throws JobPersistenceException {
        Jedis jedis = jedisPool.getResource();
        try {
            List<String> calendarNames = this.storage.getCalendarNames(jedis);
            jedisPool.returnResource(jedis);
            return calendarNames;
        }
        catch (JedisConnectionException e) {
            logger.error("Redis connection error.", e);
            jedisPool.returnBrokenResource(jedis);
            throw new JobPersistenceException(e.getMessage(), e);
        }
        catch (Exception e) {
            logger.error("Could not retrieve calendar names.", e);
            jedisPool.returnResource(jedis);
            throw new JobPersistenceException(e.getMessage(), e);
        }
    }

    @Override
    public List<OperableTrigger> getTriggersForJob(JobKey jobKey) throws JobPersistenceException {
        ArrayList<OperableTrigger> triggers = new ArrayList();
        Jedis jedis = jedisPool.getResource();
        try {
            this.storage.waitForLock(jedis);
            triggers = this.storage.getTriggersForJob(jobKey, jedis);
        }
        catch (Exception e) {
            logger.error("Could not retrieve triggers for job.", e);
            throw new JobPersistenceException(e.getMessage(), e);
        }
        finally {
            this.storage.unlock(jedis);
            jedisPool.returnResource(jedis);
        }
        return triggers;
    }

    @Override
    public Trigger.TriggerState getTriggerState(TriggerKey triggerKey) throws JobPersistenceException {
        Jedis jedis = jedisPool.getResource();
        try {
            this.storage.waitForLock(jedis);
            Trigger.TriggerState triggerState = this.storage.getTriggerState(triggerKey, jedis);
            return triggerState;
        }
        catch (Exception e) {
            logger.error("Could not retrieve trigger state.", e);
            throw new JobPersistenceException(e.getMessage(), e);
        }
        finally {
            this.storage.unlock(jedis);
            jedisPool.returnResource(jedis);
        }
    }

    @Override
    public void pauseTrigger(TriggerKey triggerKey) throws JobPersistenceException {
        Jedis jedis = jedisPool.getResource();
        try {
            this.storage.waitForLock(jedis);
            this.storage.pauseTrigger(triggerKey, jedis);
        }
        catch (Exception e) {
            logger.error("Could not pause trigger.", e);
            throw new JobPersistenceException(e.getMessage(), e);
        }
        finally {
            this.storage.unlock(jedis);
            jedisPool.returnResource(jedis);
        }
    }

    @Override
    public Collection<String> pauseTriggers(GroupMatcher<TriggerKey> matcher) throws JobPersistenceException {
        Jedis jedis = jedisPool.getResource();
        try {
            this.storage.waitForLock(jedis);
            Collection<String> collection = this.storage.pauseTriggers(matcher, jedis);
            return collection;
        }
        catch (Exception e) {
            logger.error("Could not pause triggers.", e);
            throw new JobPersistenceException(e.getMessage(), e);
        }
        finally {
            this.storage.unlock(jedis);
            jedisPool.returnResource(jedis);
        }
    }

    @Override
    public void pauseJob(JobKey jobKey) throws JobPersistenceException {
        Jedis jedis = jedisPool.getResource();
        try {
            this.storage.waitForLock(jedis);
            this.storage.pauseJob(jobKey, jedis);
        }
        catch (Exception e) {
            logger.error("Could not pause job.", e);
            throw new JobPersistenceException(e.getMessage(), e);
        }
        finally {
            this.storage.unlock(jedis);
            jedisPool.returnResource(jedis);
        }
    }

    @Override
    public Collection<String> pauseJobs(GroupMatcher<JobKey> groupMatcher) throws JobPersistenceException {
        Jedis jedis = jedisPool.getResource();
        try {
            this.storage.waitForLock(jedis);
            Collection<String> collection = this.storage.pauseJobs(groupMatcher, jedis);
            return collection;
        }
        catch (Exception e) {
            logger.error("Could not pause jobs.", e);
            throw new JobPersistenceException(e.getMessage(), e);
        }
        finally {
            this.storage.unlock(jedis);
            jedisPool.returnResource(jedis);
        }
    }

    @Override
    public void resumeTrigger(TriggerKey triggerKey) throws JobPersistenceException {
        Jedis jedis = jedisPool.getResource();
        try {
            this.storage.waitForLock(jedis);
            this.storage.resumeTrigger(triggerKey, jedis);
        }
        catch (Exception e) {
            logger.error("Could not resume trigger.", e);
            throw new JobPersistenceException(e.getMessage(), e);
        }
        finally {
            this.storage.unlock(jedis);
            jedisPool.returnResource(jedis);
        }
    }

    @Override
    public Collection<String> resumeTriggers(GroupMatcher<TriggerKey> matcher) throws JobPersistenceException {
        Jedis jedis = jedisPool.getResource();
        try {
            this.storage.waitForLock(jedis);
            Collection<String> collection = this.storage.resumeTriggers(matcher, jedis);
            return collection;
        }
        catch (Exception e) {
            logger.error("Could not resume trigger group(s).", e);
            throw new JobPersistenceException(e.getMessage(), e);
        }
        finally {
            this.storage.unlock(jedis);
            jedisPool.returnResource(jedis);
        }
    }

    @Override
    public Set<String> getPausedTriggerGroups() throws JobPersistenceException {
        Jedis jedis = jedisPool.getResource();
        try {
            Set<String> set = this.storage.getPausedTriggerGroups(jedis);
            return set;
        }
        catch (Exception e) {
            logger.error("Could not retrieve paused trigger groups.", e);
            throw new JobPersistenceException(e.getMessage(), e);
        }
        finally {
            jedisPool.returnResource(jedis);
        }
    }

    @Override
    public void resumeJob(JobKey jobKey) throws JobPersistenceException {
        Jedis jedis = jedisPool.getResource();
        try {
            this.storage.waitForLock(jedis);
            this.storage.resumeJob(jobKey, jedis);
        }
        catch (Exception e) {
            logger.error("Could not resume job.", e);
            throw new JobPersistenceException(e.getMessage(), e);
        }
        finally {
            this.storage.unlock(jedis);
            jedisPool.returnResource(jedis);
        }
    }

    @Override
    public Collection<String> resumeJobs(GroupMatcher<JobKey> matcher) throws JobPersistenceException {
        Jedis jedis = jedisPool.getResource();
        try {
            this.storage.waitForLock(jedis);
            Collection<String> collection = this.storage.resumeJobs(matcher, jedis);
            return collection;
        }
        catch (Exception e) {
            logger.error("Could not resume jobs.", e);
            throw new JobPersistenceException(e.getMessage(), e);
        }
        finally {
            this.storage.unlock(jedis);
            jedisPool.returnResource(jedis);
        }
    }

    @Override
    public void pauseAll() throws JobPersistenceException {
        Jedis jedis = jedisPool.getResource();
        try {
            this.storage.waitForLock(jedis);
            this.storage.pauseAll(jedis);
        }
        catch (Exception e) {
            logger.error("Could not pause all triggers.", e);
            throw new JobPersistenceException(e.getMessage(), e);
        }
        finally {
            this.storage.unlock(jedis);
            jedisPool.returnResource(jedis);
        }
    }

    @Override
    public void resumeAll() throws JobPersistenceException {
        Jedis jedis = jedisPool.getResource();
        try {
            this.storage.waitForLock(jedis);
            this.storage.resumeAll(jedis);
        }
        catch (Exception e) {
            logger.error("Could not resume all triggers.", e);
            throw new JobPersistenceException(e.getMessage(), e);
        }
        finally {
            this.storage.unlock(jedis);
            jedisPool.returnResource(jedis);
        }
    }

    @Override
    public List<OperableTrigger> acquireNextTriggers(long noLaterThan, int maxCount, long timeWindow) throws JobPersistenceException {
        Jedis jedis = jedisPool.getResource();
        try {
            this.storage.waitForLock(jedis);
            List<OperableTrigger> list = this.storage.acquireNextTriggers(noLaterThan, maxCount, timeWindow, jedis);
            return list;
        }
        catch (Exception e) {
            logger.error("Could not acquire next triggers.", e);
            throw new JobPersistenceException(e.getMessage(), e);
        }
        finally {
            this.storage.unlock(jedis);
            jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseAcquiredTrigger(OperableTrigger trigger) {
        Jedis jedis = jedisPool.getResource();
        try {
            this.storage.waitForLock(jedis);
            this.storage.releaseAcquiredTrigger(trigger, jedis);
        }
        catch (Exception e) {
            logger.error("Could not release acquired trigger.", e);
        }
        finally {
            this.storage.unlock(jedis);
            jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TriggerFiredResult> triggersFired(List<OperableTrigger> triggers) throws JobPersistenceException {
        Jedis jedis = jedisPool.getResource();
        ArrayList<TriggerFiredResult> result = new ArrayList();
        try {
            this.storage.waitForLock(jedis);
            result = this.storage.triggersFired(triggers, jedis);
        }
        catch (Exception e) {
            logger.error("Could not set triggers as fired.", e);
        }
        finally {
            this.storage.unlock(jedis);
            jedisPool.returnResource(jedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void triggeredJobComplete(OperableTrigger trigger, JobDetail jobDetail, Trigger.CompletedExecutionInstruction triggerInstCode) {
        Jedis jedis = jedisPool.getResource();
        try {
            this.storage.waitForLock(jedis);
            this.storage.triggeredJobComplete(trigger, jobDetail, triggerInstCode, jedis);
        }
        catch (Exception e) {
            logger.error("Could not handle job completion.", e);
        }
        finally {
            this.storage.unlock(jedis);
            jedisPool.returnResource(jedis);
        }
    }

    public void setLockTimeout(int lockTimeout) {
        this.lockTimeout = lockTimeout;
    }

    public void setLockTimeout(String lockTimeout) {
        this.setLockTimeout(Integer.valueOf(lockTimeout));
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setPort(String port) {
        this.setPort(Integer.valueOf(port));
    }

    public void setDatabase(short database) {
        this.database = database;
    }

    public void setDatabase(int database) {
        this.database = (short)database;
    }

    public void setDatabase(String database) {
        this.setDatabase(Short.valueOf(database));
    }

    public void setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }

    public void setKeyDelimiter(String keyDelimiter) {
        this.keyDelimiter = keyDelimiter;
    }

    @Override
    public void setInstanceId(String schedInstId) {
        this.instanceId = schedInstId;
    }

    @Override
    public void setInstanceName(String schedName) {
    }

    @Override
    public void setThreadPoolSize(int poolSize) {
    }
}

