/*
 * Decompiled with CFR 0.152.
 */
package net.jockx.fluentpage;

import net.jockx.fluentpage.Assertion;
import net.jockx.fluentpage.Logger;
import net.thucydides.core.pages.PageObject;
import net.thucydides.core.pages.Pages;
import org.openqa.selenium.WebDriver;

public class Page<T extends Page<T>>
extends PageObject {
    private static Page instance;
    private static WebDriver driver;
    private final T page;
    public final Assertion<T> assertion;
    public final Logger<T> logger;

    public static void initialize(WebDriver webDriver) {
        driver = webDriver;
        instance = new Page();
        Page.instance.logger.info("Starting with {}", (Object)webDriver);
    }

    public static <T extends Page> T waitForPage(Class<T> type) {
        return ((Page)((Object)Page.get(type))).waitToLoad();
    }

    public static <T extends Page> T navigateToPage(Class<T> type) {
        return ((Page)((Object)Page.get(type))).navigateTo();
    }

    public static <T extends Page> T get(Class<T> type) {
        return (T)((Object)((Page)instance.switchToPage(type)));
    }

    public static Page get() {
        return instance;
    }

    public Page() {
        super(driver);
        if (driver == null) {
            throw new IllegalStateException("No WebDriver found or initial setup is not complete. Please call Page.initialize(driver) first.");
        }
        this.page = this;
        this.logger = new Logger<T>(this.page);
        this.assertion = new Assertion<T>(this.page);
        this.setPages(new Pages(driver));
    }

    public T navigateTo() {
        return ((Page)((Object)this.page)).waitToLoad();
    }

    public T waitToLoad() {
        this.logger.debug("Waiting for " + ((Object)((Object)this)).getClass().toGenericString());
        return this.page;
    }

    public static String getCurrentUrl() {
        return Page.get().getDriver().getCurrentUrl();
    }
}

