/*
 * Decompiled with CFR 0.152.
 */
package net.joala.net;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.joala.net.Response;

public class DelayedResponse
implements Response {
    private final long delayMillis;
    private final Response response;

    public DelayedResponse(long delayMillis, @Nonnull Response response) {
        Preconditions.checkNotNull((Object)response, (Object)"Response must not be null.");
        this.delayMillis = delayMillis;
        this.response = response;
    }

    @Override
    public void write(@Nonnull HttpExchange exchange) throws IOException {
        Preconditions.checkNotNull((Object)exchange, (Object)"Exchange must not be null.");
        try {
            Thread.sleep(this.delayMillis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.response.write(exchange);
    }

    public static Response delay(long delayMillis, @Nonnull Response response) {
        return new DelayedResponse(delayMillis, response);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("delayMillis", this.delayMillis).add("response", (Object)this.response).toString();
    }
}

