/*
 * Decompiled with CFR 0.152.
 */
package net.joala.net;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import net.joala.net.PreparedResponsesHttpHandler;
import net.joala.net.Response;

class PreparedResponsesHttpHandlerImpl
implements PreparedResponsesHttpHandler {
    private final Deque<Response> responses = new LinkedList<Response>();

    PreparedResponsesHttpHandlerImpl() {
    }

    @Override
    public void feedResponses(Response ... responses) {
        this.responses.addAll(Arrays.asList(responses));
    }

    @Override
    public void clearResponses() {
        this.responses.clear();
    }

    @Override
    public int availableResponses() {
        return this.responses.size();
    }

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        Preconditions.checkState((!this.responses.isEmpty() ? 1 : 0) != 0, (Object)"No responses available anymore.");
        this.responses.pollFirst().write(exchange);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("responses", this.responses).toString();
    }
}

