/*
 * Decompiled with CFR 0.152.
 */
package net.joala.net;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import net.joala.condition.Condition;
import net.joala.condition.DefaultConditionFactory;
import net.joala.expression.AbstractExpression;
import net.joala.expression.Expression;
import net.joala.expression.ExpressionEvaluationException;
import net.joala.net.PortUtils;
import net.joala.net.PreparedResponsesHttpHandler;
import net.joala.net.PreparedResponsesHttpHandlerImpl;
import net.joala.net.StatusCodeResponse;
import net.joala.time.Timeout;
import net.joala.time.TimeoutImpl;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.hamcrest.core.IsEqual;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedWebservice {
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedWebservice.class);
    private static final TimeoutImpl SERVER_STARTUP_TIMEOUT = new TimeoutImpl(5L, TimeUnit.SECONDS);
    private volatile HttpServer server;
    @Nonnull
    private final PreparedResponsesHttpHandler preparedResponsesHttpHandler;
    @Nonnull
    private final URI clientUri;
    @Nonnull
    private final String context;
    private final int port;

    public EmbeddedWebservice() throws IOException {
        this("/");
    }

    public EmbeddedWebservice(@Nonnull String context) throws IOException {
        this(context, PortUtils.freePort());
    }

    public EmbeddedWebservice(@Nonnull String context, int port) throws IOException {
        Preconditions.checkNotNull((Object)context, (Object)"Context must not be null. For root context use '/'.");
        try {
            this.context = context;
            this.port = port;
            InetSocketAddress address = new InetSocketAddress(port);
            this.server = HttpServer.create(address, 0);
            this.preparedResponsesHttpHandler = new PreparedResponsesHttpHandlerImpl();
            this.server.createContext(this.context, this.preparedResponsesHttpHandler);
            this.server.setExecutor(null);
            this.clientUri = URI.create(String.format("http://%s:%d%s", InetAddress.getByName(null).getHostName(), this.port, context));
        }
        catch (IOException e) {
            throw new IOException("Failed to prepare embedded webservice for " + context + ':' + port, e);
        }
        LOG.info("Embedded Webservice ready to start for " + context + ':' + port);
    }

    @Nonnull
    public URI getClientUri() {
        return this.clientUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Preconditions.checkState((this.server != null ? 1 : 0) != 0, (Object)"Server cannot be restarted.");
        this.server.start();
        this.preparedResponsesHttpHandler.feedResponses(StatusCodeResponse.statusCode(200));
        DefaultHttpClient httpClient = this.getStartupHttpClient();
        try {
            this.getStartupCondition(httpClient).assumeThat(IsEqual.equalTo((Object)200));
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
        LOG.info("Started embedded webservice at port {} with context {}.", (Object)this.port, (Object)this.context);
    }

    private Condition<Integer> getStartupCondition(DefaultHttpClient httpClient) {
        return new DefaultConditionFactory((Timeout)SERVER_STARTUP_TIMEOUT).condition((Expression)new ServerStartupStatusCodeExpression(httpClient));
    }

    private DefaultHttpClient getStartupHttpClient() {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpParams httpParams = httpClient.getParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)((int)SERVER_STARTUP_TIMEOUT.in(TimeUnit.MILLISECONDS)));
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)((int)SERVER_STARTUP_TIMEOUT.in(TimeUnit.MILLISECONDS)));
        return httpClient;
    }

    public void stop() {
        this.server.stop(1);
        this.preparedResponsesHttpHandler.clearResponses();
        this.server = null;
        LOG.info("Stopped embedded webservice");
    }

    @Nonnull
    public PreparedResponsesHttpHandler getHttpHandler() {
        return this.preparedResponsesHttpHandler;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("clientUri", (Object)this.clientUri).add("server", (Object)this.server).add("preparedResponsesHttpHandler", (Object)this.preparedResponsesHttpHandler).add("context", (Object)this.context).add("port", this.port).toString();
    }

    private class ServerStartupStatusCodeExpression
    extends AbstractExpression<Integer> {
        private final DefaultHttpClient httpClient;

        private ServerStartupStatusCodeExpression(DefaultHttpClient httpClient) {
            this.httpClient = httpClient;
        }

        public Integer get() {
            HttpHead httpHead = new HttpHead(EmbeddedWebservice.this.clientUri);
            try {
                HttpResponse response = this.httpClient.execute((HttpUriRequest)httpHead);
                HttpEntity httpEntity = response.getEntity();
                StatusLine statusLine = response.getStatusLine();
                int statusCode = statusLine.getStatusCode();
                if (httpEntity != null) {
                    EntityUtils.consume((HttpEntity)httpEntity);
                }
                return statusCode;
            }
            catch (IOException e) {
                throw new ExpressionEvaluationException(String.format("Failure reading from URI %s.", EmbeddedWebservice.this.clientUri), (Throwable)e);
            }
        }
    }
}

