/*
 * Decompiled with CFR 0.152.
 */
package net.joala.data.random;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.RandomStringUtils;

public enum RandomStringType {
    ALL(0, 0, false, false),
    ASCII(32, 127, false, false),
    ALPHABETIC(0, 0, true, false),
    ALPHANUMERIC(0, 0, true, true),
    NUMERIC(0, 0, false, true);

    private final int startChr;
    private final int endChr;
    private final boolean containsAlphabetic;
    private final boolean containsNumbers;

    private RandomStringType(int startChr, int endChr, boolean containsAlphabetic, boolean containsNumbers) {
        this.startChr = startChr;
        this.endChr = endChr;
        this.containsAlphabetic = containsAlphabetic;
        this.containsNumbers = containsNumbers;
    }

    @Nonnull
    public String get(int count) {
        return RandomStringUtils.random((int)count, (int)this.startChr, (int)this.endChr, (boolean)this.containsAlphabetic, (boolean)this.containsNumbers);
    }

    @VisibleForTesting
    int getEndChr() {
        return this.endChr;
    }

    @VisibleForTesting
    int getStartChr() {
        return this.startChr;
    }

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("startChr", this.startChr).add("endChr", this.endChr).add("containsAlphabetic", this.containsAlphabetic).add("containsNumbers", this.containsNumbers).toString();
    }
}

