/*
 * Decompiled with CFR 0.152.
 */
package net.joala.data.random;

import javax.annotation.Nonnull;
import net.joala.data.random.AbstractRandomNumberProvider;
import net.joala.data.random.AbstractRandomNumberType;

public class RandomLongProvider
extends AbstractRandomNumberProvider<Long> {
    public RandomLongProvider() {
        super(new LongRandomNumberType());
    }

    private static final class LongRandomNumberType
    extends AbstractRandomNumberType<Long> {
        private LongRandomNumberType() {
            super(Long.class);
        }

        @Override
        @Nonnull
        public Long min() {
            return Long.MIN_VALUE;
        }

        @Override
        @Nonnull
        public Long max() {
            return Long.MAX_VALUE;
        }

        @Override
        @Nonnull
        public Long sum(Long value1, Long value2) {
            return value1 + value2;
        }

        @Override
        @Nonnull
        public Long percentOf(double percent, Long value) {
            this.checkPercentageArgument(percent);
            return (long)percent * value;
        }
    }
}

