/*
 * Decompiled with CFR 0.152.
 */
package net.joala.data.random;

import javax.annotation.Nonnull;
import net.joala.data.random.AbstractRandomNumberProvider;
import net.joala.data.random.AbstractRandomNumberType;

public class RandomIntegerProvider
extends AbstractRandomNumberProvider<Integer> {
    public RandomIntegerProvider() {
        super(new IntegerRandomNumberType());
    }

    private static final class IntegerRandomNumberType
    extends AbstractRandomNumberType<Integer> {
        private IntegerRandomNumberType() {
            super(Integer.class);
        }

        @Override
        @Nonnull
        public Integer min() {
            return Integer.MIN_VALUE;
        }

        @Override
        @Nonnull
        public Integer max() {
            return Integer.MAX_VALUE;
        }

        @Override
        @Nonnull
        public Integer sum(Integer value1, Integer value2) {
            return value1 + value2;
        }

        @Override
        @Nonnull
        public Integer percentOf(double percent, Integer value) {
            this.checkPercentageArgument(percent);
            return (int)percent * value;
        }
    }
}

