/*
 * Decompiled with CFR 0.152.
 */
package net.joala.data.random;

import javax.annotation.Nonnull;
import net.joala.data.random.AbstractRandomNumberProvider;
import net.joala.data.random.AbstractRandomNumberType;

public class RandomFloatProvider
extends AbstractRandomNumberProvider<Float> {
    public RandomFloatProvider() {
        super(new FloatRandomNumberType());
    }

    private static final class FloatRandomNumberType
    extends AbstractRandomNumberType<Float> {
        private FloatRandomNumberType() {
            super(Float.class);
        }

        @Override
        @Nonnull
        public Float min() {
            return Float.valueOf(Float.MIN_VALUE);
        }

        @Override
        @Nonnull
        public Float max() {
            return Float.valueOf(Float.MAX_VALUE);
        }

        @Override
        @Nonnull
        public Float sum(Float value1, Float value2) {
            return Float.valueOf(value1.floatValue() + value2.floatValue());
        }

        @Override
        @Nonnull
        public Float percentOf(double percent, Float value) {
            this.checkPercentageArgument(percent);
            return Float.valueOf((float)percent * value.floatValue());
        }
    }
}

