/*
 * Decompiled with CFR 0.152.
 */
package net.joala.data.random;

import javax.annotation.Nonnull;
import net.joala.data.random.AbstractRandomNumberProvider;
import net.joala.data.random.AbstractRandomNumberType;

public class RandomDoubleProvider
extends AbstractRandomNumberProvider<Double> {
    public RandomDoubleProvider() {
        super(new DoubleRandomNumberType());
    }

    private static final class DoubleRandomNumberType
    extends AbstractRandomNumberType<Double> {
        private DoubleRandomNumberType() {
            super(Double.class);
        }

        @Override
        @Nonnull
        public Double min() {
            return Double.MIN_VALUE;
        }

        @Override
        @Nonnull
        public Double max() {
            return Double.MAX_VALUE;
        }

        @Override
        @Nonnull
        public Double sum(Double value1, Double value2) {
            return value1 + value2;
        }

        @Override
        @Nonnull
        public Double percentOf(double percent, Double value) {
            this.checkPercentageArgument(percent);
            return percent * value;
        }
    }
}

