/*
 * Decompiled with CFR 0.152.
 */
package net.joala.data.random;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.joala.data.DataProvidingException;
import net.joala.data.random.AbstractRandomDataProvider;
import net.joala.data.random.RandomIntegerProvider;
import net.joala.data.random.RandomStringProvider;
import net.joala.data.random.RandomStringType;

public class DefaultRandomStringProvider
extends AbstractRandomDataProvider<String>
implements RandomStringProvider {
    private static final int DEFAULT_MIN_LEN = 1;
    private static final int DEFAULT_MAX_LEN = 16;
    private static final RandomStringType DEFAULT_STRING_TYPE = RandomStringType.ALL;
    @Nonnegative
    private int minLen;
    @Nonnegative
    private int maxLen;
    @Nonnull
    private RandomStringType stringType;
    @Nullable
    private String prefix;
    @Nullable
    private String postfix;

    public DefaultRandomStringProvider() {
        this(DEFAULT_STRING_TYPE, 1, 16);
    }

    public DefaultRandomStringProvider(@Nonnegative int defaultLen) {
        this(DEFAULT_STRING_TYPE, defaultLen, defaultLen);
    }

    public DefaultRandomStringProvider(@Nonnegative int defaultMinLen, @Nonnegative int defaultMaxLen) {
        this(DEFAULT_STRING_TYPE, defaultMinLen, defaultMaxLen);
    }

    public DefaultRandomStringProvider(@Nonnull RandomStringType type) {
        this(type, 1, 16);
    }

    public DefaultRandomStringProvider(@Nonnull RandomStringType type, @Nonnegative int defaultLen) {
        this(type, defaultLen, defaultLen);
    }

    public DefaultRandomStringProvider(@Nonnull RandomStringType type, @Nonnegative int defaultMinLen, @Nonnegative int defaultMaxLen) {
        Preconditions.checkArgument((defaultMinLen <= defaultMaxLen ? 1 : 0) != 0, (String)"Min length must not be greater than max len: %s >= %s", (Object[])new Object[]{defaultMinLen, defaultMaxLen});
        Preconditions.checkArgument((defaultMinLen >= 0 ? 1 : 0) != 0, (Object)"Minimum length must be non-negative.");
        Preconditions.checkArgument((defaultMaxLen >= 0 ? 1 : 0) != 0, (Object)"Maximum length must be non-negative.");
        Preconditions.checkNotNull((Object)((Object)type), (Object)"String Type must not be null.");
        this.maxLen = defaultMaxLen;
        this.minLen = defaultMinLen;
        this.stringType = type;
    }

    @Override
    public String get() throws DataProvidingException {
        return this.stringType.get(this.getLength());
    }

    @Nonnegative
    protected final int getLength() throws DataProvidingException {
        int prefixLength = this.prefix == null ? 0 : this.prefix.length();
        int postfixLength = this.postfix == null ? 0 : this.postfix.length();
        int predefinedLength = prefixLength + postfixLength;
        Preconditions.checkState((this.maxLen >= predefinedLength ? 1 : 0) != 0, (String)"Maximum length (%s) is less than pre- and/or postfix (%s).", (Object[])new Object[]{this.maxLen, predefinedLength});
        int adjustedMaxLen = this.maxLen - predefinedLength;
        if (this.minLen == this.maxLen) {
            return adjustedMaxLen;
        }
        int adjustedMinLen = this.minLen < predefinedLength ? 0 : this.minLen - predefinedLength;
        return (Integer)new RandomIntegerProvider().min(adjustedMinLen).max(adjustedMaxLen).get();
    }

    @Nonnull
    protected final RandomStringType getStringType() {
        return this.stringType;
    }

    @Nullable
    protected final String getPostfix() {
        return this.postfix;
    }

    @Nullable
    protected final String getPrefix() {
        return this.prefix;
    }

    @Override
    @Nonnull
    public final RandomStringProvider type(@Nonnull RandomStringType type) {
        this.stringType = type;
        return this;
    }

    @Override
    @Nonnull
    public final RandomStringProvider length(@Nonnegative int len) {
        this.maxLen = len;
        this.minLen = len;
        return this;
    }

    @Override
    @Nonnull
    public final RandomStringProvider maxLength(@Nonnegative int len) {
        this.maxLen = len;
        return this;
    }

    @Override
    @Nonnull
    public final RandomStringProvider minLength(@Nonnegative int len) {
        this.minLen = len;
        return this;
    }

    @Override
    @Nonnull
    public RandomStringProvider postfix(@Nullable String postfix) {
        this.postfix = postfix;
        return this;
    }

    @Override
    @Nonnull
    public RandomStringProvider prefix(@Nullable String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("minLen", this.minLen).add("maxLen", this.maxLen).add("stringType", (Object)this.stringType).toString();
    }
}

