/*
 * Decompiled with CFR 0.152.
 */
package net.joala.data.random;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import com.google.common.collect.Ranges;
import javax.annotation.Nonnull;
import net.joala.data.random.RandomNumberType;

public abstract class AbstractRandomNumberType<T extends Comparable<? extends Number>>
implements RandomNumberType<T> {
    private static final Range<Double> VALID_PERCENTAGE_RANGE = Ranges.closed((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0));
    @Nonnull
    private final Class<T> type;

    protected AbstractRandomNumberType(@Nonnull Class<T> type) {
        Preconditions.checkNotNull(type, (Object)"Type must not be null.");
        this.type = type;
    }

    @Override
    @Nonnull
    public final Class<T> getType() {
        return this.type;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("type", this.type).toString();
    }

    protected void checkPercentageArgument(double percent) {
        Preconditions.checkArgument((boolean)VALID_PERCENTAGE_RANGE.contains((Comparable)Double.valueOf(percent)), (String)"Given percentage must be between 0 and 1 but is %s.", (Object[])new Object[]{percent});
    }
}

