/*
 * Decompiled with CFR 0.152.
 */
package net.joala.data.random;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import com.google.common.collect.Ranges;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.joala.data.DataProvidingException;
import net.joala.data.random.AbstractRandomDataProvider;
import net.joala.data.random.RandomNumberProvider;
import net.joala.data.random.RandomNumberType;

public abstract class AbstractRandomNumberProvider<T extends Comparable<? extends Number>>
extends AbstractRandomDataProvider<T>
implements RandomNumberProvider<T> {
    private static final Random GENERATOR = new Random(System.currentTimeMillis());
    @Nonnull
    private T minValue;
    @Nonnull
    private T maxValue;
    @Nonnull
    private final RandomNumberType<T> numberType;

    protected AbstractRandomNumberProvider(@Nonnull RandomNumberType<T> numberType) {
        Preconditions.checkNotNull(numberType, (Object)"Number Type must not be null.");
        this.numberType = numberType;
        this.maxValue = numberType.max();
        this.minValue = numberType.min();
    }

    @Override
    public RandomNumberProvider<T> min(@Nullable T minValue) {
        this.minValue = minValue == null ? this.numberType.min() : minValue;
        return this;
    }

    @Override
    public RandomNumberProvider<T> max(@Nullable T maxValue) {
        this.maxValue = maxValue == null ? this.numberType.max() : maxValue;
        return this;
    }

    @Override
    public T get() throws DataProvidingException {
        try {
            return this.nextRandom(Ranges.closed(this.minValue, this.maxValue));
        }
        catch (IllegalArgumentException e) {
            throw new DataProvidingException("Illegal range.", e);
        }
    }

    private T nextRandom(Range<T> range) {
        Preconditions.checkState((!range.isEmpty() ? 1 : 0) != 0, (Object)"Range must not be empty.");
        Comparable lowerEndpoint = range.lowerEndpoint();
        Comparable upperEndpoint = range.upperEndpoint();
        double random = this.nextRandomRatio();
        return (T)this.numberType.sum(this.numberType.percentOf(random, upperEndpoint), this.numberType.percentOf(1.0 - random, lowerEndpoint));
    }

    @Nonnull
    public final RandomNumberType<T> getNumberType() {
        return this.numberType;
    }

    @VisibleForTesting
    double nextRandomRatio() {
        return GENERATOR.nextDouble();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("numberType", this.numberType).add("minValue", this.minValue).add("maxValue", this.maxValue).toString();
    }
}

